/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.AnnotatedDex;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import java.util.Iterator;

public abstract class DexDeclaration
extends Dex
implements AnnotatedDex {
    @Override
    public boolean uses(Key key) {
        if (this.getKey().equals(key)) {
            return false;
        }
        return this.getId().uses(key);
    }

    public boolean isAccessibleTo(TypeKey typeKey) {
        if (this.getDefining().equals(typeKey)) {
            return true;
        }
        if (this.isInternal()) {
            return this.getPackageName().equals(typeKey.getPackageName());
        }
        return !this.isPrivate();
    }

    public boolean isAccessibleTo(DexClass dexClass) {
        TypeKey defining;
        DexClass myClass = this.getDexClass();
        if (!myClass.isAccessibleTo(defining = dexClass.getDefining())) {
            return false;
        }
        if (myClass.getDefining().equals(defining)) {
            return true;
        }
        return myClass == this || this.isAccessibleTo(defining);
    }

    public boolean isInternal() {
        return (this.getAccessFlagsValue() & 7) == 0;
    }

    public boolean isPublic() {
        return AccessFlag.PUBLIC.isSet(this.getAccessFlagsValue());
    }

    public boolean isProtected() {
        return AccessFlag.PROTECTED.isSet(this.getAccessFlagsValue());
    }

    public boolean isPrivate() {
        return AccessFlag.PRIVATE.isSet(this.getAccessFlagsValue());
    }

    public boolean isNative() {
        return AccessFlag.NATIVE.isSet(this.getAccessFlagsValue());
    }

    public boolean isStatic() {
        return AccessFlag.STATIC.isSet(this.getAccessFlagsValue());
    }

    public boolean isSynthetic() {
        return AccessFlag.SYNTHETIC.isSet(this.getAccessFlagsValue());
    }

    public boolean isAbstract() {
        return AccessFlag.ABSTRACT.isSet(this.getAccessFlagsValue());
    }

    public boolean hasAccessFlag(AccessFlag accessFlag) {
        return accessFlag.isSet(this.getAccessFlagsValue());
    }

    public boolean hasAccessFlag(AccessFlag flag1, AccessFlag flag2) {
        return this.hasAccessFlag(flag1) && this.hasAccessFlag(flag2);
    }

    public boolean hasAccessFlag(AccessFlag flag1, AccessFlag flag2, AccessFlag flag3) {
        return this.hasAccessFlag(flag1) && this.hasAccessFlag(flag2) && this.hasAccessFlag(flag3);
    }

    public abstract IdDefinition<?> getDefinition();

    public abstract Key getKey();

    public abstract IdItem getId();

    public abstract DexClass getDexClass();

    public Iterator<? extends Modifier> getAccessFlags() {
        return this.getDefinition().getAccessFlags();
    }

    public void addAccessFlag(AccessFlag accessFlag) {
        this.getDefinition().addAccessFlag(accessFlag);
    }

    public void removeAccessFlag(AccessFlag accessFlag) {
        this.getDefinition().removeAccessFlag(accessFlag);
    }

    int getAccessFlagsValue() {
        return this.getDefinition().getAccessFlagsValue();
    }

    public TypeKey getDefining() {
        return this.getKey().getDeclaring();
    }

    public DexFile getDexFile() {
        if (this.getClass() == DexClass.class) {
            throw new RuntimeException("getDexFile() must be override for: " + this.getClass());
        }
        return this.getDexClass().getDexFile();
    }

    public DexDirectory getDexDirectory() {
        DexFile dexFile = this.getDexFile();
        if (dexFile != null) {
            return dexFile.getDexDirectory();
        }
        return null;
    }

    @Override
    public DexClassRepository getClassRepository() {
        DexFile dexFile = this.getDexFile();
        if (dexFile != null) {
            return dexFile.getClassRepository();
        }
        return null;
    }

    public String getPackageName() {
        return this.getDefining().getPackageName();
    }

    public abstract void removeSelf();

    public boolean isInSameFile(DexDeclaration dexDeclaration) {
        if (dexDeclaration == null) {
            return false;
        }
        if (dexDeclaration == this) {
            return true;
        }
        DexFile dexFile = this.getDexFile();
        if (dexFile == null) {
            return false;
        }
        return dexFile == dexDeclaration.getDexFile();
    }

    public boolean isInSameFile(DexFile dexFile) {
        return dexFile != null && dexFile.getDexLayout() == this.getDexFile().getDexLayout();
    }

    public boolean isInSameDirectory(DexDeclaration dexDeclaration) {
        if (dexDeclaration == null) {
            return false;
        }
        if (this.isInSameFile(dexDeclaration)) {
            return true;
        }
        DexDirectory directory = this.getDexDirectory();
        if (directory == null) {
            return false;
        }
        return directory == dexDeclaration.getDexDirectory();
    }

    public boolean isInSameDirectory(DexDirectory directory) {
        return this.getDexDirectory() == directory;
    }

    public int hashCode() {
        Key key = this.getKey();
        if (key != null) {
            return key.hashCode();
        }
        return 0;
    }

    @Override
    public String toString() {
        return Modifier.toString(this.getAccessFlags()) + this.getKey();
    }
}

