/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexIntegerVisitor;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.UniqueIterator;
import java.util.Iterator;
import java.util.function.Predicate;

public interface DexClassRepository {
    public int getDexClassesCount();

    public DexClass getDexClass(TypeKey var1);

    public Iterator<DexClass> getDexClasses(Predicate<? super TypeKey> var1);

    public Iterator<DexClass> getDexClassesCloned(Predicate<? super TypeKey> var1);

    public <T extends SectionItem> Iterator<T> getItems(SectionType<T> var1);

    public <T extends SectionItem> Iterator<T> getClonedItems(SectionType<T> var1);

    public <T1 extends SectionItem> Iterator<T1> getItems(SectionType<T1> var1, Key var2);

    public <T1 extends SectionItem> T1 getItem(SectionType<T1> var1, Key var2);

    public <T1 extends SectionItem> int removeEntries(SectionType<T1> var1, Predicate<T1> var2);

    default public <T extends SectionItem> Iterator<T> getClonedItems(SectionType<T> sectionType, Predicate<? super T> filter) {
        return FilterIterator.of(this.getClonedItems(sectionType), filter);
    }

    default public Iterator<DexClass> findUserClasses(Key key) {
        return new UniqueIterator<DexClass>(this.getDexClasses(), dexClass -> dexClass.uses(key));
    }

    default public Iterator<DexClass> getDexClasses() {
        return this.getDexClasses(null);
    }

    default public Iterator<DexClass> getDexClassesCloned() {
        return this.getDexClassesCloned(null);
    }

    default public Iterator<DexClass> getPackageClasses(String packageName) {
        return this.getPackageClasses(packageName, true);
    }

    default public Iterator<DexClass> getPackageClasses(String packageName, boolean includeSubPackages) {
        return this.getDexClasses(key -> key.isPackage(packageName, includeSubPackages));
    }

    default public DexMethod getDeclaredMethod(MethodKey methodKey) {
        DexClass dexClass = this.getDexClass(methodKey.getDeclaring());
        if (dexClass != null) {
            return dexClass.getDeclaredMethod(methodKey);
        }
        return null;
    }

    default public DexField getDeclaredField(FieldKey fieldKey) {
        DexClass dexClass = this.getDexClass(fieldKey.getDeclaring());
        if (dexClass != null) {
            return dexClass.getDeclaredField(fieldKey);
        }
        return null;
    }

    default public DexDeclaration getDexDeclaration(Key key) {
        if (key instanceof TypeKey) {
            return this.getDexClass((TypeKey)key);
        }
        if (key instanceof MethodKey) {
            return this.getDeclaredMethod((MethodKey)key);
        }
        if (key instanceof FieldKey) {
            return this.getDeclaredField((FieldKey)key);
        }
        return null;
    }

    default public Iterator<DexMethod> getDeclaredMethods() {
        return new IterableIterator<DexClass, DexMethod>(this.getDexClasses()){

            @Override
            public Iterator<DexMethod> iterator(DexClass dexClass) {
                return dexClass.getDeclaredMethods();
            }
        };
    }

    default public Iterator<DexField> getDeclaredFields() {
        return new IterableIterator<DexClass, DexField>(this.getDexClasses()){

            @Override
            public Iterator<DexField> iterator(DexClass dexClass) {
                return dexClass.getDeclaredFields();
            }
        };
    }

    default public Iterator<IntegerReference> visitIntegers() {
        return new DexIntegerVisitor(this);
    }

    default public int removeAnnotations(TypeKey typeKey) {
        return this.removeEntries(SectionType.ANNOTATION_ITEM, annotationItem -> typeKey.equals(annotationItem.getTypeKey()));
    }

    default public int removeAnnotationElements(MethodKey methodKey) {
        int removeCount = 0;
        TypeKey typeKey = methodKey.getDeclaring();
        Predicate<AnnotationElement> elementFilter = element -> element.is(methodKey);
        Iterator<AnnotationItem> iterator = this.getClonedItems(SectionType.ANNOTATION_ITEM);
        while (iterator.hasNext()) {
            int count;
            AnnotationItem annotationItem = iterator.next();
            if (!typeKey.equals(methodKey.getDeclaring()) || (count = annotationItem.remove(elementFilter)) == 0) continue;
            if (annotationItem.isEmpty()) {
                annotationItem.removeSelf();
            }
            removeCount += count;
        }
        return removeCount;
    }
}

