/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.model.DexValue;
import com.reandroid.dex.reference.TypeListReference;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NullValue;
import com.reandroid.dex.value.StringValue;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.collection.UniqueIterator;
import com.reandroid.utils.io.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class DexClass
extends DexDeclaration
implements Comparable<DexClass> {
    private final DexFile dexFile;
    private final ClassId classId;

    public DexClass(DexFile dexFile, ClassId classId) {
        this.dexFile = dexFile;
        this.classId = classId;
    }

    public boolean usesNative() {
        if (this.isNative()) {
            return true;
        }
        Iterator<DexMethod> methods = this.getDeclaredMethods();
        while (methods.hasNext()) {
            DexMethod dexMethod = methods.next();
            if (!dexMethod.isNative()) continue;
            return true;
        }
        Iterator<DexField> fields = this.getDeclaredFields();
        while (fields.hasNext()) {
            DexField dexField = fields.next();
            if (!dexField.isNative()) continue;
            return true;
        }
        return false;
    }

    public void replaceKeys(Key search, Key replace) {
        this.getId().replaceKeys(search, replace);
    }

    public Set<DexClass> getRequired() {
        return this.getRequired(null);
    }

    public Set<DexClass> getRequired(Predicate<TypeKey> exclude) {
        HashSet<DexClass> results = new HashSet<DexClass>();
        results.add(this);
        this.searchRequired(exclude, results);
        return results;
    }

    private void searchRequired(Predicate<TypeKey> exclude, Set<DexClass> results) {
        DexClassRepository dexClassRepository = this.getClassRepository();
        Iterator<TypeKey> iterator = this.usedTypes();
        while (iterator.hasNext()) {
            DexClass dexClass;
            TypeKey typeKey = iterator.next();
            if (exclude != null && !exclude.test(typeKey) || (dexClass = dexClassRepository.getDexClass(typeKey)) == null || results.contains(dexClass)) continue;
            results.add(dexClass);
            dexClass.searchRequired(exclude, results);
        }
    }

    public Iterator<TypeKey> usedTypes() {
        Iterator<Key> iterator = ComputeIterator.of(this.getId().usedIds(), IdItem::getKey);
        IterableIterator<Key, Key> mentioned = new IterableIterator<Key, Key>(iterator){

            @Override
            public Iterator<Key> iterator(Key element) {
                return element.mentionedKeys();
            }
        };
        return InstanceIterator.of(mentioned, TypeKey.class);
    }

    public DexMethod getStaticConstructor() {
        MethodKey methodKey = MethodKey.STATIC_CONSTRUCTOR.changeDeclaring(this.getDefining());
        return this.getDeclaredMethod(methodKey);
    }

    public DexField getField(FieldKey fieldKey) {
        if (!this.isAccessibleTo(fieldKey.getDeclaring())) {
            return null;
        }
        DexField dexField = this.getDeclaredField(fieldKey);
        if (dexField != null) {
            return dexField;
        }
        DexClass superClass = this.getSuperClass();
        if (superClass != null && (dexField = superClass.getField(fieldKey)) != null) {
            if (dexField.isAccessibleTo(this.getDefining())) {
                return dexField;
            }
            return null;
        }
        Iterator<DexClass> iterator = this.getInterfaceClasses();
        while (iterator.hasNext()) {
            dexField = iterator.next().getField(fieldKey);
            if (dexField == null || !dexField.isAccessibleTo(this.getDefining())) continue;
            return dexField;
        }
        return null;
    }

    public DexField getDeclaredField(FieldKey fieldKey) {
        Iterator<DexField> iterator = this.getDeclaredFields();
        while (iterator.hasNext()) {
            DexField dexField = iterator.next();
            if (!fieldKey.equals(dexField.getKey(), false, true)) continue;
            return dexField;
        }
        return null;
    }

    public DexMethod getMethod(MethodKey methodKey) {
        DexMethod dexMethod = this.getDeclaredMethod(methodKey);
        if (dexMethod != null) {
            return dexMethod;
        }
        Iterator<DexClass> iterator = this.getSuperTypes();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            dexMethod = dexClass.getDeclaredMethod(methodKey);
            if (dexMethod == null || !dexMethod.isAccessibleTo(methodKey.getDeclaring())) continue;
            return dexMethod;
        }
        return null;
    }

    public Iterator<DexMethod> getMethods(MethodKey methodKey) {
        return CombiningIterator.two(this.getDeclaredMethods(methodKey), ComputeIterator.of(this.getSuperTypes(), dexClass -> {
            DexMethod method = dexClass.getDeclaredMethod(methodKey);
            if (method != null && method.isAccessibleTo(methodKey.getDeclaring())) {
                return method;
            }
            return null;
        }));
    }

    public Iterator<DexMethod> getExtending(MethodKey methodKey) {
        return CombiningIterator.of(this.getDeclaredMethod(methodKey), ComputeIterator.of(this.getExtending(), dexClass -> dexClass.getExtending(methodKey)));
    }

    public Iterator<DexMethod> getImplementations(MethodKey methodKey) {
        return CombiningIterator.of(this.getDeclaredMethod(methodKey), ComputeIterator.of(this.getImplementations(), dexClass -> dexClass.getImplementations(methodKey)));
    }

    public Iterator<MethodKey> getOverridingKeys(MethodKey methodKey) {
        MethodKey key = methodKey.changeDeclaring(this.getKey());
        return CombiningIterator.of(CombiningIterator.singleOne(key, SingleIterator.of(this.getBridgedMethod(methodKey))), ComputeIterator.of(this.getOverriding(), dexClass -> dexClass.getOverridingKeys(key)));
    }

    private MethodKey getBridgedMethod(MethodKey methodKey) {
        DexMethod dexMethod = this.getDeclaredMethod(methodKey);
        if (dexMethod == null) {
            return null;
        }
        if ((dexMethod = dexMethod.getBridged()) == null) {
            return null;
        }
        return dexMethod.getKey();
    }

    public boolean containsDeclaredMethod(MethodKey methodKey) {
        return this.getDeclaredMethod(methodKey) != null;
    }

    public DexMethod getDeclaredMethod(MethodKey methodKey) {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        while (iterator.hasNext()) {
            DexMethod dexMethod = iterator.next();
            if (!methodKey.equalsNameAndParameters(dexMethod.getKey())) continue;
            return dexMethod;
        }
        return null;
    }

    public Iterator<DexMethod> getDeclaredMethods(MethodKey methodKey) {
        return FilterIterator.of(this.getDeclaredMethods(), dexMethod -> methodKey.equalsNameAndParameters(dexMethod.getKey()));
    }

    public Iterator<DexClass> getOverridingAndSuperTypes() {
        return CombiningIterator.two(this.getOverriding(), this.getSuperTypes());
    }

    public Iterator<DexClass> getSuperTypes() {
        final TypeKey overflow = this.getDefining();
        Iterator<DexClass> iterator = CombiningIterator.two(SingleIterator.of(this.getSuperClass()), this.getInterfaceClasses());
        return new IterableIterator<DexClass, DexClass>(iterator){

            @Override
            public Iterator<DexClass> iterator(DexClass element) {
                if (overflow.equals(element.getDefining())) {
                    throw new IllegalArgumentException("Recursive class super: " + overflow);
                }
                return CombiningIterator.two(SingleIterator.of(element), element.getSuperTypes());
            }
        };
    }

    public Iterator<DexClass> getOverriding() {
        return CombiningIterator.two(this.getExtending(), this.getImplementations());
    }

    public Iterator<DexClass> getExtending() {
        return this.getDexFile().searchExtending(this.getKey());
    }

    public Iterator<DexClass> getImplementations() {
        return this.getDexFile().searchImplementations(this.getKey());
    }

    public DexClass getSuperClass() {
        return this.search(this.getSuperClassKey());
    }

    public Iterator<DexField> getDeclaredFields() {
        return CombiningIterator.two(this.getStaticFields(), this.getInstanceFields());
    }

    public DexField getOrCreateStaticField(FieldKey fieldKey) {
        return this.createField(this.getOrCreateStatic(fieldKey));
    }

    public FieldDef getOrCreateStatic(FieldKey fieldKey) {
        return this.getOrCreateClassData().getOrCreateStatic(fieldKey);
    }

    public Iterator<DexField> getStaticFields() {
        ClassData classData = this.getClassData();
        if (classData == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(classData.getStaticFields(), this::createField);
    }

    public Iterator<DexField> getInstanceFields() {
        ClassData classData = this.getClassData();
        if (classData == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(classData.getInstanceFields(), this::createField);
    }

    public Iterator<DexMethod> getDeclaredMethods(Predicate<DexMethod> filter) {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        if (filter == null) {
            return iterator;
        }
        return FilterIterator.of(iterator, filter);
    }

    public Iterator<DexMethod> getDeclaredMethods() {
        return CombiningIterator.two(this.getDirectMethods(), this.getVirtualMethods());
    }

    public Iterator<DexMethod> getDirectMethods() {
        ClassData classData = this.getClassData();
        if (classData == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(classData.getDirectMethods(), this::createMethod);
    }

    public Iterator<DexMethod> getVirtualMethods() {
        ClassData classData = this.getClassData();
        if (classData == null) {
            return EmptyIterator.of();
        }
        return ComputeIterator.of(classData.getVirtualMethods(), this::createMethod);
    }

    public DexMethod getOrCreateDirectMethod(MethodKey methodKey) {
        return this.createMethod(this.getOrCreateClassData().getOrCreateDirect(methodKey));
    }

    public DexMethod getOrCreateVirtualMethod(MethodKey methodKey) {
        return this.createMethod(this.getOrCreateClassData().getOrCreateVirtual(methodKey));
    }

    public DexMethod getOrCreateStaticMethod(MethodKey methodKey) {
        DexMethod dexMethod = this.getOrCreateDirectMethod(methodKey);
        dexMethod.addAccessFlag(AccessFlag.STATIC);
        return dexMethod;
    }

    DexField createField(FieldDef fieldDef) {
        return new DexField(this, fieldDef);
    }

    DexMethod createMethod(MethodDef methodDef) {
        return new DexMethod(this, methodDef);
    }

    public boolean isInterface() {
        return AccessFlag.INTERFACE.isSet(this.getAccessFlagsValue());
    }

    public boolean isEnum() {
        return AccessFlag.ENUM.isSet(this.getAccessFlagsValue());
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return this.getDexInstructions(null);
    }

    public Iterator<DexInstruction> getDexInstructions(Predicate<DexMethod> filter) {
        return new IterableIterator<DexMethod, DexInstruction>(this.getDeclaredMethods(filter)){

            @Override
            public Iterator<DexInstruction> iterator(DexMethod element) {
                return element.getInstructions();
            }
        };
    }

    public void decode(SmaliWriter writer, File outDir) throws IOException {
        File file = new File(outDir, this.toFilePath());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create dir: " + dir);
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        writer.setWriter(new OutputStreamWriter(outputStream));
        this.append(writer);
        writer.close();
        outputStream.close();
    }

    private String toFilePath() {
        String name = this.getDefining().getTypeName();
        name = name.substring(1, name.length() - 1);
        name = name.replace('/', File.separatorChar);
        return name + ".smali";
    }

    @Override
    public DexFile getDexFile() {
        return this.dexFile;
    }

    @Override
    public ClassId getId() {
        return this.classId;
    }

    @Override
    public DexClass getDexClass() {
        return this;
    }

    @Override
    public TypeKey getKey() {
        return this.getId().getKey();
    }

    public ClassId getDefinition() {
        return this.getId();
    }

    public TypeKey getSuperClassKey() {
        return this.getId().getSuperClassKey();
    }

    public void setSuperClass(TypeKey superClass) {
        this.getId().setSuperClass(superClass);
    }

    public String getSourceFileName() {
        return this.getId().getSourceFileName();
    }

    public void setSourceFile(String sourceFile) {
        this.getId().setSourceFile(sourceFile);
    }

    public Iterator<DexClass> getInterfaceClasses() {
        return ComputeIterator.of(this.getInterfaces(), this::search);
    }

    DexClass search(TypeKey typeKey) {
        return this.getClassRepository().getDexClass(typeKey);
    }

    public boolean containsInterface(TypeKey typeKey) {
        return CollectionUtil.contains(this.getInterfaces(), typeKey);
    }

    public Iterator<TypeKey> getInterfaces() {
        return this.getId().getInterfaceKeys();
    }

    public void addInterface(TypeKey typeKey) {
        this.addInterface(typeKey.getTypeName());
    }

    public void addInterface(String typeName) {
        TypeListReference reference = this.getId().getInterfacesReference();
        reference.add(typeName);
    }

    public void clearInterfaces() {
        TypeListReference reference = this.getId().getInterfacesReference();
        reference.setItem((TypeList)null);
    }

    public void clearDebug() {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        while (iterator.hasNext()) {
            iterator.next().clearDebug();
        }
    }

    public void removeAnnotations(Predicate<AnnotationItem> filter) {
        ClassId classId = this.getId();
        AnnotationSet annotationSet = classId.getClassAnnotations();
        if (annotationSet == null) {
            return;
        }
        annotationSet.remove(filter);
        annotationSet.refresh();
        if (annotationSet.size() == 0) {
            annotationSet.removeSelf();
            classId.setClassAnnotations(null);
            AnnotationsDirectory directory = this.getId().getAnnotationsDirectory();
            if (directory != null && directory.isEmpty()) {
                directory.removeSelf();
                classId.setAnnotationsDirectory(null);
            }
        }
        this.getId().refresh();
    }

    public void fixDalvikInnerClassName() {
        AnnotationItem annotationItem = this.getId().getDalvikInnerClass();
        if (annotationItem == null) {
            return;
        }
        AnnotationElement element = annotationItem.getElement("name");
        if (element == null) {
            return;
        }
        DexValueBlock<StringValue> valueBlock = element.getValue();
        if (!valueBlock.is(DexValueType.STRING)) {
            return;
        }
        TypeKey typeKey = this.getKey();
        if (!typeKey.isInnerName()) {
            element.setValue(new NullValue());
            return;
        }
        StringValue value = (StringValue)valueBlock;
        value.setString(typeKey.getSimpleInnerName());
    }

    public List<Key> fixAccessibility() {
        DexClassRepository repository = this.getClassRepository();
        ArrayCollection<Key> results = new ArrayCollection<Key>();
        UniqueIterator<Key> iterator = new UniqueIterator<Key>(this.getId().usedKeys());
        iterator.exclude(this.getKey());
        while (iterator.hasNext()) {
            Key key = iterator.next();
            if (!this.fixAccessibility(repository.getDexDeclaration(key))) continue;
            results.add(key);
        }
        return results;
    }

    private boolean fixAccessibility(DexDeclaration declaration) {
        if (declaration != null && !declaration.isAccessibleTo(this)) {
            declaration.addAccessFlag(AccessFlag.PUBLIC);
            return true;
        }
        return false;
    }

    public TypeKey getDalvikEnclosingClass() {
        Key key = this.getId().getDalvikEnclosing();
        if (key != null) {
            return key.getDeclaring();
        }
        return null;
    }

    public String getDalvikInnerClassName() {
        DexValue dexValue = this.getAnnotationValue(TypeKey.DALVIK_InnerClass, "name");
        if (dexValue != null) {
            return dexValue.getString();
        }
        return null;
    }

    public void updateDalvikInnerClassName(String name) {
        DexValue dexValue = this.getAnnotationValue(TypeKey.DALVIK_InnerClass, "name");
        if (dexValue != null) {
            dexValue.setString(name);
        }
    }

    public void createDalvikInnerClassName(String name) {
        DexValue dexValue = this.getOrCreateAnnotationValue(TypeKey.DALVIK_InnerClass, "name", DexValueType.STRING);
        dexValue.setString(name);
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations() {
        AnnotationSet annotationSet = this.getId().getClassAnnotations();
        if (annotationSet != null) {
            return ComputeIterator.of(annotationSet.iterator(), annotationItem -> DexAnnotation.create(this, annotationItem));
        }
        return EmptyIterator.of();
    }

    @Override
    public Iterator<DexAnnotation> getAnnotations(TypeKey typeKey) {
        AnnotationSet annotationSet = this.getId().getClassAnnotations();
        if (annotationSet != null) {
            return ComputeIterator.of(annotationSet.getAll(typeKey), annotationItem -> DexAnnotation.create(this, annotationItem));
        }
        return EmptyIterator.of();
    }

    @Override
    public DexAnnotation getAnnotation(TypeKey typeKey) {
        AnnotationSet annotationSet = this.getId().getClassAnnotations();
        if (annotationSet != null) {
            return DexAnnotation.create(this, annotationSet.get(typeKey));
        }
        return null;
    }

    @Override
    public DexAnnotation getOrCreateAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getId().getOrCreateClassAnnotations().getOrCreate(typeKey));
    }

    @Override
    public DexAnnotation newAnnotation(TypeKey typeKey) {
        return DexAnnotation.create(this, this.getId().getOrCreateClassAnnotations().addNewItem(typeKey));
    }

    ClassData getOrCreateClassData() {
        return this.getId().getOrCreateClassData();
    }

    ClassData getClassData() {
        return this.getId().getClassData();
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    public void edit() {
        this.getId().edit();
    }

    @Override
    public int compareTo(DexClass dexClass) {
        return this.getKey().compareTo(dexClass.getKey());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getClassData();
        this.getId().append(writer);
    }

    public void writeSmali(SmaliWriter writer, File dir) throws IOException {
        File file = this.toSmaliFile(dir);
        IOUtil.writeUtf8(this.toSmali(writer), file);
    }

    public File toSmaliFile(File dir) {
        return new File(dir, this.buildSmaliPath());
    }

    public String buildSmaliPath() {
        String type = this.getKey().getTypeName();
        type = type.substring(1, type.length() - 1);
        type = type.replace('/', File.separatorChar);
        type = type + ".smali";
        return type;
    }

    public String toSmali() throws IOException {
        return SmaliWriter.toString(this);
    }

    public String toSmali(SmaliWriter writer) throws IOException {
        return SmaliWriter.toString(writer, this);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.TYPE;
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexClass dexClass = (DexClass)obj;
        if (!this.isInSameFile(dexClass)) {
            return false;
        }
        return this.getKey().equals(dexClass.getKey());
    }

    @Override
    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

