/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexAnnotationElement;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Iterator;

public class DexAnnotation
extends Dex
implements Iterable<DexAnnotationElement> {
    private final Dex declaring;
    private final AnnotationItem annotationItem;

    public DexAnnotation(Dex declaring, AnnotationItem annotationItem) {
        this.declaring = declaring;
        this.annotationItem = annotationItem;
    }

    public TypeKey getType() {
        return this.getAnnotationItem().getTypeKey();
    }

    public void setType(TypeKey typeKey) {
        this.getAnnotationItem().setType(typeKey);
    }

    @Override
    public boolean uses(Key key) {
        return this.getAnnotationItem().uses(key);
    }

    public boolean contains(String name) {
        return this.getAnnotationItem().containsName(name);
    }

    public DexAnnotationElement get(String name) {
        return DexAnnotationElement.create(this, this.getAnnotationItem().getElement(name));
    }

    public DexAnnotationElement get(int index) {
        return DexAnnotationElement.create(this, this.getAnnotationItem().getElement(index));
    }

    public int size() {
        return this.getAnnotationItem().getElementsCount();
    }

    @Override
    public Iterator<DexAnnotationElement> iterator() {
        return ComputeIterator.of(this.getAnnotationItem().iterator(), element -> DexAnnotationElement.create(this, element));
    }

    public Iterator<DexAnnotationElement> clonedIterator() {
        return ComputeIterator.of(this.getAnnotationItem().clonedIterator(), element -> DexAnnotationElement.create(this, element));
    }

    public AnnotationVisibility getVisibility() {
        return this.getAnnotationItem().getVisibility();
    }

    public void setVisibility(AnnotationVisibility visibility) {
        this.getAnnotationItem().setVisibility(visibility);
    }

    public DexAnnotationElement getOrCreate(String name) {
        return DexAnnotationElement.create(this, this.getAnnotationItem().getOrCreateElement(name));
    }

    public void removeSelf() {
        this.getAnnotationItem().removeSelf();
    }

    public AnnotationItem getAnnotationItem() {
        return this.annotationItem;
    }

    public Dex getDeclaring() {
        return this.declaring;
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDeclaring().getClassRepository();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getAnnotationItem().append(writer);
    }

    public static DexAnnotation create(Dex declaring, AnnotationItem annotationItem) {
        if (declaring != null && annotationItem != null) {
            return new DexAnnotation(declaring, annotationItem);
        }
        return null;
    }
}

