/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexAnnotation;
import com.reandroid.dex.model.DexAnnotationElement;
import com.reandroid.dex.model.DexValue;
import com.reandroid.dex.value.DexValueType;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public interface AnnotatedDex {
    public Iterator<DexAnnotation> getAnnotations();

    public Iterator<DexAnnotation> getAnnotations(TypeKey var1);

    public DexAnnotation getAnnotation(TypeKey var1);

    public DexAnnotation getOrCreateAnnotation(TypeKey var1);

    public DexAnnotation newAnnotation(TypeKey var1);

    public ElementType getElementType();

    default public DexAnnotationElement getAnnotationElement(TypeKey typeKey, String name) {
        DexAnnotation dexAnnotation = this.getAnnotation(typeKey);
        if (dexAnnotation != null) {
            return dexAnnotation.get(name);
        }
        return null;
    }

    default public DexAnnotationElement getOrCreateAnnotationElement(TypeKey typeKey, String name) {
        DexAnnotationElement element = this.getAnnotationElement(typeKey, name);
        if (element != null) {
            return element;
        }
        DexAnnotation annotation = this.getOrCreateAnnotation(typeKey);
        return annotation.getOrCreate(name);
    }

    default public DexValue getAnnotationValue(TypeKey typeKey, String name) {
        DexAnnotationElement element = this.getAnnotationElement(typeKey, name);
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    default public DexValue getOrCreateAnnotationValue(TypeKey typeKey, String name, DexValueType<?> valueType) {
        DexAnnotationElement element = this.getOrCreateAnnotationElement(typeKey, name);
        return element.getOrCreateValue(valueType);
    }
}

