/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;

public class TypeListKey
implements Key,
Iterable<String> {
    private final String[] parameters;

    public TypeListKey(String[] parameters) {
        this.parameters = parameters;
    }

    public TypeListKey remove(int index) {
        String[] parameters = this.getParameterNames();
        if (parameters == null) {
            return this;
        }
        int length = parameters.length;
        if (index < 0 || index >= length) {
            return this;
        }
        String[] results = length == 1 ? null : new String[length - 1];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (i == index) continue;
            results[count] = parameters[i];
            ++count;
        }
        return new TypeListKey(results);
    }

    public TypeListKey add(String name) {
        int length = 0;
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            length = parameters.length;
        }
        String[] results = new String[length + 1];
        int count = 0;
        if (parameters != null) {
            for (int i = 0; i < length; ++i) {
                results[count] = parameters[i];
                ++count;
            }
        }
        results[count] = name;
        return new TypeListKey(results);
    }

    public String[] getParameterNames() {
        return this.parameters;
    }

    public int indexOf(String name) {
        if (name == null) {
            return -1;
        }
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                if (!name.equals(parameters[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(TypeKey typeKey) {
        if (typeKey == null) {
            return -1;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!typeKey.equals(this.getType(i))) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            return parameters.length;
        }
        return 0;
    }

    public String get(int i) {
        return this.getParameterNames()[i];
    }

    public TypeKey getType(int i) {
        return TypeKey.create(this.get(i));
    }

    public Iterator<TypeKey> getTypes() {
        return ComputeIterator.of(this.iterator(), TypeKey::create);
    }

    @Override
    public Iterator<String> iterator() {
        return ArrayIterator.of(this.getParameterNames());
    }

    public Iterator<TypeKey> mentionedKeys() {
        return this.getTypes();
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        TypeListKey result = this;
        if (search.equals(result)) {
            return replace;
        }
        String[] parameters = this.getParameterNames();
        if (parameters != null && search instanceof TypeKey) {
            TypeKey searchType = (TypeKey)search;
            String replaceType = ((TypeKey)replace).getTypeName();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                if (!searchType.equals(new TypeKey(parameters[i]))) continue;
                parameters[i] = replaceType;
            }
        }
        return result;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        TypeListKey key = (TypeListKey)obj;
        return CompareUtil.compare(this.getParameterNames(), key.getParameterNames());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeListKey)) {
            return false;
        }
        TypeListKey key = (TypeListKey)obj;
        return CompareUtil.compare(this.getParameterNames(), key.getParameterNames()) == 0;
    }

    public int hashCode() {
        int hash = 1;
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String param : parameters) {
                hash = hash * 31 + param.hashCode();
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String parameter : parameters) {
                builder.append(parameter);
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static TypeListKey create(TypeList typeList) {
        return TypeListKey.create(typeList.getNames());
    }

    public static TypeListKey create(String[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        return new TypeListKey(parameters);
    }
}

