/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class TypeKey
implements Key {
    private final String typeName;
    private String simpleName;
    public static final TypeKey NULL = new TypeKey("00"){

        @Override
        public boolean isPlatform() {
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isTypeArray() {
            return false;
        }

        @Override
        public boolean isTypeObject() {
            return false;
        }

        @Override
        public TypeKey getDeclaring() {
            return this;
        }

        @Override
        public String getTypeName() {
            return StringsUtil.EMPTY;
        }

        @Override
        public Iterator<TypeKey> mentionedKeys() {
            return EmptyIterator.of();
        }

        @Override
        public Key replaceKey(Key search, Key replace) {
            return this;
        }

        @Override
        public boolean isPackage(String packageName) {
            return false;
        }

        @Override
        public boolean isPackage(String packageName, boolean checkSubPackage) {
            return false;
        }

        @Override
        public TypeKey setArrayDimension(int dimension) {
            return this;
        }

        @Override
        public TypeKey setPackage(String packageName) {
            return this;
        }

        @Override
        public void append(SmaliWriter writer) {
        }
    };
    public static final TypeKey TYPE_B = new PrimitiveTypeKey("B", "byte");
    public static final TypeKey TYPE_C = new PrimitiveTypeKey("C", "char");
    public static final TypeKey TYPE_D = new PrimitiveTypeKey("D", "double"){

        @Override
        public boolean isWide() {
            return true;
        }
    };
    public static final TypeKey TYPE_F = new PrimitiveTypeKey("F", "float");
    public static final TypeKey TYPE_I = new PrimitiveTypeKey("I", "int");
    public static final TypeKey TYPE_J = new PrimitiveTypeKey("J", "long"){

        @Override
        public boolean isWide() {
            return true;
        }
    };
    public static final TypeKey TYPE_S = new PrimitiveTypeKey("S", "short");
    public static final TypeKey TYPE_V = new PrimitiveTypeKey("V", "void");
    public static final TypeKey TYPE_Z = new PrimitiveTypeKey("Z", "boolean");
    public static final TypeKey CLASS = new TypeKey("Ljava/lang/Class;");
    public static final TypeKey OBJECT = new TypeKey("Ljava/lang/Object;");
    public static final TypeKey STRING = new TypeKey("Ljava/lang/String;");
    public static final TypeKey DALVIK_EnclosingClass = new TypeKey("Ldalvik/annotation/EnclosingClass;");
    public static final TypeKey DALVIK_EnclosingMethod = new TypeKey("Ldalvik/annotation/EnclosingMethod;");
    public static final TypeKey DALVIK_InnerClass = new TypeKey("Ldalvik/annotation/InnerClass;");
    public static final TypeKey DALVIK_MemberClass = new TypeKey("Ldalvik/annotation/MemberClasses;");
    public static final TypeKey DALVIK_Signature = new TypeKey("Ldalvik/annotation/Signature;");

    public TypeKey(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getSourceName() {
        StringBuilder builder = new StringBuilder();
        String declaring = DexUtils.toSourceName(this.getDeclaringName());
        builder.append(declaring);
        int array = this.getArrayDimension();
        for (int i = 0; i < array; ++i) {
            builder.append("[]");
        }
        return builder.toString();
    }

    @Override
    public TypeKey getDeclaring() {
        String main = this.getDeclaringName();
        if (main.equals(this.getTypeName())) {
            return this;
        }
        return TypeKey.create(main);
    }

    public Iterator<TypeKey> mentionedKeys() {
        return SingleIterator.of(this);
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        return this;
    }

    public String getDeclaringName() {
        return DexUtils.toDeclaringType(this.getTypeName());
    }

    public String getSignatureTypeName() {
        return DexUtils.toSignatureType(this.getTypeName());
    }

    public TypeKey setArrayDimension(int dimension) {
        if (dimension == this.getArrayDimension()) {
            return this;
        }
        return new TypeKey(this.getArrayType(dimension));
    }

    public String getArrayType(int dimension) {
        return DexUtils.makeArrayType(this.getTypeName(), dimension);
    }

    public int getArrayDimension() {
        return DexUtils.countArrayPrefix(this.getTypeName());
    }

    public boolean isTypeSignature() {
        return DexUtils.isTypeSignature(this.getTypeName());
    }

    public boolean isTypeArray() {
        return DexUtils.isTypeArray(this.getTypeName());
    }

    public boolean isTypeObject() {
        return DexUtils.isTypeObject(this.getTypeName());
    }

    public boolean isPrimitive() {
        return DexUtils.isPrimitive(this.getTypeName());
    }

    public boolean isWide() {
        String name = this.getTypeName();
        if (name.length() != 1) {
            return false;
        }
        return name.equals(TYPE_D.getTypeName()) || name.equals(TYPE_J.getTypeName());
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            this.simpleName = DexUtils.getSimpleName(this.getTypeName());
        }
        return this.simpleName;
    }

    public String getSimpleInnerName() {
        return DexUtils.getSimpleInnerName(this.getTypeName());
    }

    public boolean isInnerName() {
        return !this.getSimpleName().equals(this.getSimpleInnerName());
    }

    public String getPackageName() {
        return DexUtils.getPackageName(this.getTypeName());
    }

    public String getPackageSourceName() {
        String packageName = this.getPackageName();
        int i = packageName.length() - 1;
        if (i < 1) {
            return StringsUtil.EMPTY;
        }
        return packageName.substring(1, i).replace('/', '.');
    }

    public TypeKey changeTypeName(String typeName) {
        return this.changeTypeName(TypeKey.create(typeName));
    }

    public TypeKey changeTypeName(TypeKey typeKey) {
        if (this.equals(typeKey)) {
            return this;
        }
        return typeKey.setArrayDimension(this.getArrayDimension());
    }

    public TypeKey renamePackage(String from, String to) {
        String packageName = this.getPackageName();
        if (packageName.equals(from)) {
            return this.setPackage(packageName, to);
        }
        int i = from.length();
        if (i == 1 || packageName.length() < i || !packageName.startsWith(from)) {
            return this;
        }
        return this.setPackage(packageName, packageName.replace(from, to));
    }

    public TypeKey setPackage(String packageName) {
        return this.setPackage(this.getPackageName(), packageName);
    }

    private TypeKey setPackage(String myPackage, String packageName) {
        if (myPackage.equals(packageName)) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(packageName);
        int i = packageName.length() - 1;
        if (i > 0 && packageName.charAt(i) != '/') {
            builder.append('/');
        }
        builder.append(this.getSimpleName());
        String name = this.getTypeName();
        char postFix = name.charAt(name.length() - 1);
        if (postFix == ';' || postFix == '<') {
            builder.append(postFix);
        }
        TypeKey typeKey = new TypeKey(builder.toString());
        return typeKey.setArrayDimension(this.getArrayDimension());
    }

    public boolean isPackage(String packageName) {
        return this.isPackage(packageName, !"L".equals(packageName));
    }

    public boolean isPackage(String packageName, boolean checkSubPackage) {
        if (this.isPrimitive()) {
            return false;
        }
        String name = this.getPackageName();
        if (checkSubPackage) {
            return name.startsWith(packageName);
        }
        return name.equals(packageName);
    }

    public TypeKey getEnclosingClass() {
        String parent;
        String type = this.getTypeName();
        if (type.equals(parent = DexUtils.getParentClassName(type))) {
            return this;
        }
        return new TypeKey(parent);
    }

    public TypeKey createInnerClass(String simpleName) {
        String child;
        String type = this.getTypeName();
        if (type.equals(child = DexUtils.createChildClass(type, simpleName))) {
            return this;
        }
        return new TypeKey(child);
    }

    public Iterator<String> iteratePackageNames() {
        if (this.getTypeName().indexOf(47) < 0) {
            return EmptyIterator.of();
        }
        final String packageName = this.getPackageName();
        return new Iterator<String>(){
            String name;
            {
                this.name = packageName;
            }

            @Override
            public boolean hasNext() {
                return this.name.charAt(this.name.length() - 1) == '/';
            }

            @Override
            public String next() {
                String result;
                String name = result = this.name;
                while (name.charAt(name.length() - 1) == '/') {
                    name = name.substring(0, name.length() - 1);
                }
                int i = name.lastIndexOf(47);
                if (i > 0) {
                    name = name.substring(0, i + 1);
                }
                this.name = name;
                return result;
            }
        };
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getTypeName());
    }

    public int compareInnerFirst(TypeKey other) {
        String name2;
        if (this.equals(other)) {
            return 0;
        }
        String name1 = this.getSimpleName();
        int diff = StringsUtil.diffStart(name1, name2 = other.getSimpleName());
        if (diff > 0 && name1.charAt(diff) == '$' && diff > name1.lastIndexOf(47) + 1) {
            return CompareUtil.compare(name2, name1);
        }
        name1 = this.getTypeName();
        name2 = other.getTypeName();
        return CompareUtil.compare(name1, name2);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (obj == this) {
            return 0;
        }
        TypeKey key = (TypeKey)obj;
        return CompareUtil.compare(this.getTypeName(), key.getTypeName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeKey)) {
            return false;
        }
        TypeKey key = (TypeKey)obj;
        return this.getTypeName().equals(key.getTypeName());
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public String toString() {
        return this.getTypeName();
    }

    public static TypeKey parse(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.indexOf(62) > 0 || name.indexOf(40) > 0 || name.indexOf(64) > 0) {
            return null;
        }
        if (name.indexOf(47) > 0 || name.indexOf(59) > 0 || name.charAt(0) == '[') {
            return TypeKey.create(name);
        }
        if (name.indexOf(46) >= 0) {
            return TypeKey.create(DexUtils.toBinaryName(name));
        }
        for (i = 0; name.charAt(i) == '[' && i < name.length() - 1; ++i) {
        }
        if (TypeKey.primitiveType(name.charAt(i)) != null) {
            return TypeKey.create(name);
        }
        if (name.equals(TYPE_B.getSourceName())) {
            return TYPE_B;
        }
        if (name.equals(TYPE_D.getSourceName())) {
            return TYPE_D;
        }
        if (name.equals(TYPE_F.getSourceName())) {
            return TYPE_F;
        }
        if (name.equals(TYPE_I.getSourceName())) {
            return TYPE_I;
        }
        if (name.equals(TYPE_J.getSourceName())) {
            return TYPE_J;
        }
        if (name.equals(TYPE_S.getSourceName())) {
            return TYPE_S;
        }
        if (name.equals(TYPE_V.getSourceName())) {
            return TYPE_V;
        }
        if (name.equals(TYPE_Z.getSourceName())) {
            return TYPE_Z;
        }
        return TypeKey.create(DexUtils.toBinaryName(name));
    }

    public static TypeKey create(String typeName) {
        if (typeName == null) {
            return null;
        }
        int length = typeName.length();
        if (length == 0) {
            return null;
        }
        if (length != 1) {
            return new TypeKey(typeName);
        }
        return TypeKey.primitiveType(typeName.charAt(0));
    }

    public static TypeKey read(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int position = reader.position();
        StringBuilder builder = new StringBuilder();
        while (reader.get() == 91) {
            builder.append(reader.readASCII());
        }
        byte b = reader.get();
        if (b != 76) {
            builder.append(reader.readASCII());
        } else {
            int i = reader.indexOfBeforeLineEnd(';');
            if (i < 0) {
                reader.position(position);
                throw new SmaliParseException("Invalid type, missing ';'", reader);
            }
            builder.append(reader.readString(++i - reader.position()));
        }
        TypeKey typeKey = TypeKey.create(builder.toString());
        if (typeKey == null) {
            reader.position(position);
            throw new SmaliParseException("Invalid type", reader);
        }
        return typeKey;
    }

    public static TypeKey primitiveType(char ch) {
        switch (ch) {
            case 'B': {
                return TYPE_B;
            }
            case 'C': {
                return TYPE_C;
            }
            case 'D': {
                return TYPE_D;
            }
            case 'F': {
                return TYPE_F;
            }
            case 'I': {
                return TYPE_I;
            }
            case 'J': {
                return TYPE_J;
            }
            case 'S': {
                return TYPE_S;
            }
            case 'V': {
                return TYPE_V;
            }
            case 'Z': {
                return TYPE_Z;
            }
        }
        return null;
    }

    public static TypeKey parseSignature(String type) {
        if (DexUtils.isTypeOrSignature(type)) {
            return new TypeKey(type);
        }
        return null;
    }

    static class PrimitiveTypeKey
    extends TypeKey {
        private final String sourceName;

        public PrimitiveTypeKey(String type, String sourceName) {
            super(type);
            this.sourceName = sourceName;
        }

        @Override
        public boolean uses(Key key) {
            return this.equals(key);
        }

        @Override
        public String getSourceName() {
            return this.sourceName;
        }

        @Override
        public TypeKey getDeclaring() {
            return this;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public boolean isTypeObject() {
            return false;
        }

        @Override
        public boolean isTypeArray() {
            return false;
        }

        @Override
        public boolean isInnerName() {
            return false;
        }

        @Override
        public boolean isTypeSignature() {
            return false;
        }
    }
}

