/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class StringKey
implements Key {
    private final String text;
    private boolean mSignature;
    public static final StringKey EMPTY = new StringKey(StringsUtil.EMPTY);

    public StringKey(String text) {
        this.text = text;
    }

    public String getString() {
        return this.text;
    }

    public String getEncodedString() {
        return DexUtils.encodeString(this.getString());
    }

    public String getQuoted() {
        return DexUtils.quoteString(this.getString());
    }

    @Override
    public boolean isPlatform() {
        return false;
    }

    public boolean isSignature() {
        return this.mSignature;
    }

    public void setSignature(boolean signature) {
        this.mSignature = signature;
    }

    @Override
    public TypeKey getDeclaring() {
        if (!this.isSignature()) {
            return null;
        }
        return TypeKey.parseSignature(this.getString());
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleOne(this.getDeclaring(), SingleIterator.of(this));
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        return this;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(DexUtils.quoteString(this.getString()));
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        StringKey key = (StringKey)obj;
        return CompareUtil.compare(this.getString(), key.getString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringKey)) {
            return false;
        }
        StringKey stringKey = (StringKey)obj;
        return Objects.equals(this.getString(), stringKey.getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public String toString() {
        return this.getQuoted();
    }

    public static StringKey create(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return EMPTY;
        }
        text = DexUtils.decodeString(text);
        return new StringKey(text);
    }

    public static StringKey read(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        SmaliParseException.expect(reader, '\"');
        String str = reader.readEscapedString('\"');
        SmaliParseException.expect(reader, '\"');
        return StringKey.create(str);
    }
}

