/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class ProtoKey
implements Key {
    private final String[] parameters;
    private final String returnType;
    private int mHash;

    public ProtoKey(String[] parameters, String returnType) {
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public int getRegister(int index) {
        int result = 0;
        int size = this.getParametersCount();
        if (index < size) {
            size = index;
        }
        for (int i = 0; i < size; ++i) {
            TypeKey typeKey = this.getParameter(i);
            ++result;
            if (!typeKey.isWide()) continue;
            ++result;
        }
        return result;
    }

    public int getParameterIndex(int register) {
        int size = this.getParametersCount();
        int registerCount = 0;
        for (int i = 0; i < size; ++i) {
            if (registerCount == register) {
                return i;
            }
            TypeKey typeKey = this.getParameter(i);
            ++registerCount;
            if (!typeKey.isWide()) continue;
            ++registerCount;
        }
        return -1;
    }

    public ProtoKey removeParameter(int index) {
        TypeListKey typeListKey = this.getParameterListKey();
        if (typeListKey != null) {
            typeListKey = typeListKey.remove(index);
        }
        return ProtoKey.create(typeListKey, this.getReturnTypeName());
    }

    public ProtoKey changeReturnType(TypeKey typeKey) {
        return this.changeReturnType(typeKey.getTypeName());
    }

    public ProtoKey changeReturnType(String type) {
        if (type.equals(this.getReturnTypeName())) {
            return this;
        }
        return new ProtoKey(this.getParameterNames(), type);
    }

    public TypeListKey getParameterListKey() {
        return TypeListKey.create(this.getParameterNames());
    }

    public TypeKey getReturnType() {
        return new TypeKey(this.getReturnTypeName());
    }

    public String getReturnTypeName() {
        return this.returnType;
    }

    public int getParametersCount() {
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            return parameters.length;
        }
        return 0;
    }

    public String[] getParameterNames() {
        return this.parameters;
    }

    public String getParameterName(int i) {
        return this.getParameterNames()[i];
    }

    public TypeKey getParameter(int i) {
        return TypeKey.create(this.getParameterName(i));
    }

    public Iterator<TypeKey> getParameters() {
        return ComputeIterator.of(ArrayIterator.of(this.getParameterNames()), TypeKey::create);
    }

    public String getShorty() {
        StringBuilder builder = new StringBuilder();
        builder.append(ProtoKey.toShorty(this.getReturnTypeName()));
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String param : parameters) {
                builder.append(ProtoKey.toShorty(param));
            }
        }
        return builder.toString();
    }

    public int getParameterRegistersCount() {
        int result = 0;
        Iterator<TypeKey> iterator = this.getParameters();
        while (iterator.hasNext()) {
            TypeKey key = iterator.next();
            ++result;
            if (!key.isWide()) continue;
            ++result;
        }
        return result;
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleThree(this, SingleIterator.of(StringKey.create(this.getShorty())), this.getParameters(), SingleIterator.of(this.getReturnType()));
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        String[] parameters;
        ProtoKey result = this;
        if (search.equals(result)) {
            return replace;
        }
        if (search.equals(result.getReturnType())) {
            result = result.changeReturnType((TypeKey)replace);
        }
        if ((parameters = this.getParameterNames()) != null && search instanceof TypeKey) {
            TypeKey searchType = (TypeKey)search;
            String replaceType = ((TypeKey)replace).getTypeName();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                if (!searchType.equals(new TypeKey(parameters[i]))) continue;
                parameters[i] = replaceType;
            }
        }
        return result;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('(');
        writer.appendAll(this.getParameters(), false);
        writer.append(')');
        this.getReturnType().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        ProtoKey key = (ProtoKey)obj;
        int i = CompareUtil.compare(this.getParameterNames(), key.getParameterNames());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getReturnTypeName(), key.getReturnTypeName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtoKey)) {
            return false;
        }
        ProtoKey protoKey = (ProtoKey)obj;
        return Objects.equals(this.getReturnTypeName(), protoKey.getReturnTypeName()) && CompareUtil.compare(this.getParameterNames(), protoKey.getParameterNames()) == 0;
    }

    public int hashCode() {
        String[] parameters;
        int hash = this.mHash;
        if (hash != 0) {
            return hash;
        }
        hash = 1;
        String type = this.getReturnTypeName();
        if (type != null) {
            hash += type.hashCode();
        }
        if ((parameters = this.getParameterNames()) != null) {
            for (String param : parameters) {
                hash = hash * 31 + param.hashCode();
            }
        }
        this.mHash = hash;
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String parameter : parameters) {
                builder.append(parameter);
            }
        }
        builder.append(')');
        String type = this.getReturnTypeName();
        if (type != null) {
            builder.append(type);
        }
        return builder.toString();
    }

    public static ProtoKey create(ProtoId protoId) {
        TypeKey returnType = protoId.getReturnType();
        if (returnType == null) {
            return null;
        }
        return new ProtoKey(protoId.getParameterNames(), returnType.getTypeName());
    }

    public static ProtoKey create(TypeListKey typeListKey, String returnType) {
        if (returnType == null) {
            return null;
        }
        String[] parameters = null;
        if (typeListKey != null) {
            parameters = typeListKey.getParameterNames();
        }
        return new ProtoKey(parameters, returnType);
    }

    public static ProtoKey read(SmaliReader reader) throws IOException {
        String[] parameters;
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '(');
        reader.skipWhitespacesOrComment();
        ArrayCollection parameterKeys = new ArrayCollection();
        while (!reader.finished() && reader.get() != 41) {
            parameterKeys.add(TypeKey.read(reader));
            reader.skipWhitespacesOrComment();
        }
        SmaliParseException.expect(reader, ')');
        TypeKey returnType = TypeKey.read(reader);
        int size = parameterKeys.size();
        if (size == 0) {
            parameters = null;
        } else {
            parameters = new String[size];
            for (int i = 0; i < size; ++i) {
                parameters[i] = ((TypeKey)parameterKeys.get(i)).getTypeName();
            }
        }
        return new ProtoKey(parameters, returnType.getTypeName());
    }

    private static char toShorty(String typeName) {
        if (typeName.length() == 1) {
            return typeName.charAt(0);
        }
        if (typeName.length() == 0) {
            throw new RuntimeException();
        }
        return 'L';
    }
}

