/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyUtil;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;

public class MethodKey
implements Key {
    private final String declaring;
    private final String name;
    private final String[] parameters;
    private final String returnType;
    private int mParamsHash;
    public static final MethodKey STATIC_CONSTRUCTOR = new MethodKey(TypeKey.OBJECT.getTypeName(), "<clinit>", null, TypeKey.TYPE_V.getTypeName());
    public static final MethodKey EQUALS = new MethodKey(TypeKey.OBJECT.getTypeName(), "equals", new String[]{TypeKey.OBJECT.getTypeName()}, TypeKey.TYPE_Z.getTypeName());
    public static final MethodKey HASHCODE = new MethodKey(TypeKey.OBJECT.getTypeName(), "hashCode", null, TypeKey.TYPE_I.getTypeName());
    public static final MethodKey TO_STRING = new MethodKey(TypeKey.OBJECT.getTypeName(), "toString", null, TypeKey.STRING.getTypeName());
    public static final MethodKey CONSTRUCTOR = new MethodKey(TypeKey.OBJECT.getTypeName(), "<init>", null, TypeKey.TYPE_V.getTypeName());
    public static final MethodKey CONSTRUCTOR_STATIC = new MethodKey(TypeKey.OBJECT.getTypeName(), "<clinit>", null, TypeKey.TYPE_V.getTypeName());

    public MethodKey(String declaring, String name, String[] parameters, String returnType) {
        this.declaring = declaring;
        this.name = name;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public MethodKey(TypeKey typeKey, String name, String[] parameters, String returnType) {
        this(typeKey.getTypeName(), name, parameters, returnType);
    }

    public MethodKey(TypeKey typeKey, String name, String[] parameters, TypeKey returnType) {
        this(typeKey.getTypeName(), name, parameters, returnType.getTypeName());
    }

    public int getRegister(int index) {
        return this.getProtoKey().getRegister(index);
    }

    public MethodKey changeDeclaring(TypeKey typeKey) {
        return this.changeDeclaring(typeKey.getTypeName());
    }

    public MethodKey changeDeclaring(String declaring) {
        if (declaring.equals(this.getDeclaringName())) {
            return this;
        }
        return new MethodKey(declaring, this.getName(), this.getParameterNames(), this.getReturnTypeName());
    }

    public MethodKey changeName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        return new MethodKey(this.getDeclaringName(), name, this.getParameterNames(), this.getReturnTypeName());
    }

    public MethodKey changeParameters(String[] parameters) {
        if (parameters == this.getParameterNames()) {
            return this;
        }
        return new MethodKey(this.getDeclaringName(), this.getName(), parameters, this.getReturnTypeName());
    }

    public MethodKey changeParameter(int index, TypeKey parameter) {
        return this.changeParameter(index, parameter.getTypeName());
    }

    public MethodKey changeParameter(int index, String parameter) {
        if (parameter.equals(this.getParameter(index))) {
            return this;
        }
        String[] update = (String[])this.parameters.clone();
        update[index] = parameter;
        return new MethodKey(this.getDeclaringName(), this.getName(), update, this.getReturnTypeName());
    }

    public MethodKey changeReturnType(TypeKey typeKey) {
        return this.changeReturnType(typeKey.getTypeName());
    }

    public MethodKey changeReturnType(String type) {
        if (type.equals(this.getReturnTypeName())) {
            return this;
        }
        return new MethodKey(this.getDeclaringName(), this.getName(), this.getParameterNames(), type);
    }

    public MethodKey removeParameter(int index) {
        ProtoKey protoKey = this.getProtoKey();
        protoKey = protoKey.removeParameter(index);
        return new MethodKey(this.getDeclaringName(), this.getName(), protoKey.getParameterNames(), this.getReturnTypeName());
    }

    @Override
    public TypeKey getDeclaring() {
        return new TypeKey(this.getDeclaringName());
    }

    public StringKey getNameKey() {
        return new StringKey(this.getName());
    }

    public ProtoKey getProtoKey() {
        return new ProtoKey(this.getParameterNames(), this.getReturnTypeName());
    }

    public TypeKey getReturnType() {
        return new TypeKey(this.getReturnTypeName());
    }

    public String getDeclaringName() {
        return this.declaring;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameterNames() {
        return this.parameters;
    }

    public Iterator<TypeKey> getParameters() {
        return ComputeIterator.of(ArrayIterator.of(this.getParameterNames()), TypeKey::create);
    }

    public int getParametersCount() {
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            return parameters.length;
        }
        return 0;
    }

    public String getParameter(int i) {
        return this.getParameterNames()[i];
    }

    public TypeKey getParameterType(int i) {
        return TypeKey.create(this.getParameter(i));
    }

    public String getReturnTypeName() {
        return this.returnType;
    }

    public int getParameterRegistersCount() {
        return this.getProtoKey().getParameterRegistersCount();
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleTwo(this, CombiningIterator.singleOne(this.getDeclaring(), SingleIterator.of(this.getNameKey())), this.getProtoKey().mentionedKeys());
    }

    public MethodKey replaceTypes(Function<TypeKey, TypeKey> function) {
        MethodKey result = this;
        TypeKey typeKey = this.getDeclaring();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeDeclaring(typeKey);
        typeKey = this.getReturnType();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeReturnType(typeKey);
        int count = this.getParametersCount();
        for (int i = 0; i < count; ++i) {
            typeKey = this.getParameterType(i);
            typeKey = typeKey.changeTypeName(function.apply(typeKey));
            result = result.changeParameter(i, typeKey);
        }
        return result;
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        String[] parameters;
        MethodKey result = this;
        if (search.equals(result)) {
            return replace;
        }
        if (search.equals(result.getDeclaring())) {
            result = result.changeDeclaring((TypeKey)replace);
        }
        if (search.equals(result.getReturnType())) {
            result = result.changeReturnType((TypeKey)replace);
        }
        if ((parameters = this.getParameterNames()) != null && search instanceof TypeKey) {
            TypeKey searchType = (TypeKey)search;
            String replaceType = ((TypeKey)replace).getTypeName();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                if (!searchType.equals(new TypeKey(parameters[i]))) continue;
                parameters[i] = replaceType;
            }
        }
        return result;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDeclaring().append(writer);
        writer.append("->");
        writer.append(this.getName());
        this.getProtoKey().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        return this.compareTo(obj, true);
    }

    public int compareTo(Object obj, boolean checkDefining) {
        int i;
        if (obj == null) {
            return -1;
        }
        MethodKey key = (MethodKey)obj;
        if (checkDefining && (i = CompareUtil.compare(this.getDeclaringName(), key.getDeclaringName())) != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getName(), key.getName());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getParameterNames(), key.getParameterNames());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getReturnTypeName(), key.getReturnTypeName());
    }

    public boolean equalsIgnoreDeclaring(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getName(), other.getName())) {
            return false;
        }
        if (this.getNameParamsHashCode() != other.getNameParamsHashCode()) {
            return false;
        }
        int i = CompareUtil.compare(this.getParameterNames(), other.getParameterNames());
        if (i != 0) {
            return false;
        }
        return KeyUtil.matches(this.getReturnTypeName(), other.getReturnTypeName());
    }

    public boolean equalsIgnoreReturnType(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getDeclaringName(), other.getDeclaringName())) {
            return false;
        }
        if (!KeyUtil.matches(this.getName(), other.getName())) {
            return false;
        }
        if (this.getNameParamsHashCode() != other.getNameParamsHashCode()) {
            return false;
        }
        int i = CompareUtil.compare(this.getParameterNames(), other.getParameterNames());
        return i == 0;
    }

    public boolean equalsNameAndParameters(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getName(), other.getName())) {
            return false;
        }
        if (this.getNameParamsHashCode() != other.getNameParamsHashCode()) {
            return false;
        }
        int i = CompareUtil.compare(this.getParameterNames(), other.getParameterNames());
        return i == 0;
    }

    public boolean equalsIgnoreName(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getDeclaringName(), other.getDeclaringName())) {
            return false;
        }
        int i = CompareUtil.compare(this.getParameterNames(), other.getParameterNames());
        if (i != 0) {
            return false;
        }
        return KeyUtil.matches(this.getReturnTypeName(), other.getReturnTypeName());
    }

    public boolean equalsName(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getName(), other.getName());
    }

    public boolean equalsName(String name) {
        return KeyUtil.matches(this.getName(), name);
    }

    public boolean equalsProto(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        int i = CompareUtil.compare(this.getParameterNames(), other.getParameterNames());
        if (i != 0) {
            return false;
        }
        return KeyUtil.matches(this.getReturnTypeName(), other.getReturnTypeName());
    }

    public boolean equalsDeclaring(String declaring) {
        return KeyUtil.matches(this.getDeclaringName(), declaring);
    }

    public boolean equalsDeclaring(TypeKey declaring) {
        if (declaring == null) {
            return false;
        }
        return KeyUtil.matches(this.getDeclaringName(), declaring.getTypeName());
    }

    public boolean equalsDeclaring(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getDeclaringName(), other.getDeclaringName());
    }

    public boolean equalsReturnType(String returnTypeName) {
        return KeyUtil.matches(this.getReturnTypeName(), returnTypeName);
    }

    public boolean equalsReturnType(TypeKey returnType) {
        if (returnType == null) {
            return false;
        }
        return KeyUtil.matches(this.getReturnTypeName(), returnType.getTypeName());
    }

    public boolean equalsReturnType(MethodKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getReturnTypeName(), other.getReturnTypeName());
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true, true);
    }

    public boolean equals(Object obj, boolean checkDefining, boolean checkType) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey methodKey = (MethodKey)obj;
        if (this.getNameParamsHashCode() != methodKey.getNameParamsHashCode()) {
            return false;
        }
        if (!KeyUtil.matches(this.getName(), methodKey.getName())) {
            return false;
        }
        int i = CompareUtil.compare(this.getParameterNames(), methodKey.getParameterNames());
        if (i != 0) {
            return false;
        }
        if (checkDefining && !KeyUtil.matches(this.getDeclaringName(), methodKey.getDeclaringName())) {
            return false;
        }
        if (checkType) {
            return KeyUtil.matches(this.getReturnTypeName(), methodKey.getReturnTypeName());
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        String defining = this.getDeclaringName();
        if (defining != null) {
            hash += defining.hashCode();
        }
        hash = hash * 31 + this.getNameParamsHashCode();
        String returnType = this.getReturnTypeName();
        hash *= 31;
        if (returnType != null) {
            hash += returnType.hashCode();
        }
        return hash;
    }

    private int getNameParamsHashCode() {
        int hash = this.mParamsHash;
        if (hash != 0) {
            return hash;
        }
        hash = 31 + this.getName().hashCode();
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String param : parameters) {
                hash = hash * 31 + param.hashCode();
            }
        }
        this.mParamsHash = hash;
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String defining = this.getDeclaringName();
        if (defining != null) {
            builder.append(defining);
            builder.append("->");
        }
        builder.append(this.getName());
        builder.append('(');
        String[] parameters = this.getParameterNames();
        if (parameters != null) {
            for (String parameter : parameters) {
                builder.append(parameter);
            }
        }
        builder.append(')');
        String type = this.getReturnTypeName();
        if (type != null) {
            builder.append(type);
        }
        return builder.toString();
    }

    public static MethodKey parse(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() < 6 || text.charAt(0) != 'L' && text.charAt(0) != '[') {
            return null;
        }
        int i = text.indexOf(";->");
        if (i < 0) {
            return null;
        }
        String defining = text.substring(0, i + 1);
        if ((i = (text = text.substring(i + 3)).indexOf(40)) < 0) {
            return null;
        }
        String name = text.substring(0, i);
        if ((i = (text = text.substring(i + 1)).indexOf(41)) < 0) {
            return null;
        }
        String[] parameters = DexUtils.splitParameters(text.substring(0, i));
        text = text.substring(i + 1);
        String returnType = null;
        if (!StringsUtil.isEmpty(text)) {
            returnType = text;
        }
        return new MethodKey(defining, name, parameters, returnType);
    }

    public static MethodKey create(MethodId methodId) {
        TypeKey defining = methodId.getDefining();
        if (defining == null) {
            return null;
        }
        String name = methodId.getName();
        if (name == null) {
            return null;
        }
        return new MethodKey(defining, name, methodId.getParameterNames(), methodId.getReturnTypeName());
    }

    public static MethodKey read(SmaliReader reader) throws IOException {
        TypeKey declaring = TypeKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '-');
        SmaliParseException.expect(reader, '>');
        reader.skipWhitespacesOrComment();
        String name = reader.readEscapedString('(');
        ProtoKey protoKey = ProtoKey.read(reader);
        return new MethodKey(declaring.getTypeName(), name, protoKey.getParameterNames(), protoKey.getReturnTypeName());
    }
}

