/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.CombiningIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class MethodHandleKey
implements Key {
    private final MethodKey id;
    private final MethodKey member;

    public MethodHandleKey(MethodKey id, MethodKey member) {
        this.id = id;
        this.member = member;
    }

    public MethodKey getId() {
        return this.id;
    }

    public MethodKey getMember() {
        return this.member;
    }

    @Override
    public TypeKey getDeclaring() {
        return this.getId().getDeclaring();
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return CombiningIterator.two(this.getId().mentionedKeys(), this.getMember().mentionedKeys());
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        MethodKey id = (MethodKey)this.getId().replaceKey(search, replace);
        MethodKey member = (MethodKey)this.getMember().replaceKey(search, replace);
        if (id != this.getId() || member != this.getMember()) {
            return new MethodHandleKey(id, member);
        }
        return this;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getId().append(writer);
        writer.append(", ");
        this.getMember().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        MethodHandleKey other = (MethodHandleKey)obj;
        int i = CompareUtil.compare(this.getId(), other.getId());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getMember(), other.getMember());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodHandleKey)) {
            return false;
        }
        MethodHandleKey other = (MethodHandleKey)obj;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getMember(), other.getMember());
    }

    public int hashCode() {
        return this.getId().hashCode() + this.getMember().hashCode() * 31;
    }

    public String toString() {
        return this.getId() + ", " + this.getMember();
    }
}

