/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyUtil;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;

public class FieldKey
implements Key {
    private final String declaring;
    private final String name;
    private final String type;

    public FieldKey(String declaring, String name, String type) {
        this.declaring = declaring;
        this.name = name;
        this.type = type;
    }

    @Deprecated
    public FieldKey changeDefining(TypeKey typeKey) {
        return this.changeDeclaring(typeKey);
    }

    @Deprecated
    public FieldKey changeDefining(String defining) {
        return this.changeDeclaring(defining);
    }

    public FieldKey changeDeclaring(TypeKey typeKey) {
        return this.changeDeclaring(typeKey.getTypeName());
    }

    public FieldKey changeDeclaring(String defining) {
        if (defining.equals(this.getDeclaringName())) {
            return this;
        }
        return new FieldKey(defining, this.getName(), this.getTypeName());
    }

    public FieldKey changeName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        return new FieldKey(this.getDeclaringName(), name, this.getTypeName());
    }

    public FieldKey changeType(TypeKey typeKey) {
        return this.changeType(typeKey.getTypeName());
    }

    public FieldKey changeType(String type) {
        if (type.equals(this.getTypeName())) {
            return this;
        }
        return new FieldKey(this.getDeclaringName(), this.getName(), type);
    }

    @Override
    public TypeKey getDeclaring() {
        return new TypeKey(this.getDeclaringName());
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleThree(this, SingleIterator.of(this.getDeclaring()), SingleIterator.of(this.getNameKey()), SingleIterator.of(this.getType()));
    }

    public FieldKey replaceTypes(Function<TypeKey, TypeKey> function) {
        FieldKey result = this;
        TypeKey typeKey = this.getDeclaring();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeDeclaring(typeKey);
        typeKey = this.getType();
        typeKey = typeKey.changeTypeName(function.apply(typeKey));
        result = result.changeType(typeKey);
        return result;
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        FieldKey result = this;
        if (search.equals(result)) {
            return replace;
        }
        if (search.equals(result.getDeclaring())) {
            result = result.changeDeclaring((TypeKey)replace);
        }
        if (search.equals(result.getType())) {
            result = result.changeType((TypeKey)replace);
        }
        return result;
    }

    public StringKey getNameKey() {
        return new StringKey(this.getName());
    }

    public TypeKey getType() {
        return new TypeKey(this.getTypeName());
    }

    public String getDeclaringName() {
        return this.declaring;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.type;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendOptional(this.getDeclaring());
        writer.append("->");
        writer.append(this.getName());
        writer.append(':');
        writer.appendOptional(this.getType());
    }

    @Override
    public int compareTo(Object obj) {
        return this.compareTo(obj, true);
    }

    public int compareTo(Object obj, boolean compareDefining) {
        int i;
        if (obj == null) {
            return -1;
        }
        FieldKey key = (FieldKey)obj;
        if (compareDefining && (i = CompareUtil.compare(this.getDeclaringName(), key.getDeclaringName())) != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getName(), key.getName());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getTypeName(), key.getTypeName());
    }

    public int hashCode() {
        int hash = 1;
        String defining = this.getDeclaringName();
        if (defining != null) {
            hash += defining.hashCode();
        }
        return hash * 31 + this.getName().hashCode();
    }

    public boolean equalsDeclaring(String declaring) {
        if (declaring == null) {
            return false;
        }
        return KeyUtil.matches(this.getDeclaringName(), declaring);
    }

    public boolean equalsDeclaring(TypeKey declaring) {
        if (declaring == null) {
            return false;
        }
        return KeyUtil.matches(this.getDeclaringName(), declaring.getTypeName());
    }

    public boolean equalsDeclaring(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getDeclaringName(), other.getDeclaringName());
    }

    public boolean equalsIgnoreName(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!KeyUtil.matches(this.getDeclaringName(), other.getDeclaringName())) {
            return false;
        }
        return KeyUtil.matches(this.getTypeName(), other.getTypeName());
    }

    public boolean equalsName(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getName(), other.getName());
    }

    public boolean equalsName(String name) {
        return KeyUtil.matches(this.getName(), name);
    }

    public boolean equalsType(String returnTypeName) {
        return KeyUtil.matches(this.getTypeName(), returnTypeName);
    }

    public boolean equalsType(TypeKey returnType) {
        if (returnType == null) {
            return false;
        }
        return KeyUtil.matches(this.getTypeName(), returnType.getTypeName());
    }

    public boolean equalsType(FieldKey other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return KeyUtil.matches(this.getTypeName(), other.getTypeName());
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true, true);
    }

    public boolean equals(Object obj, boolean checkDefining, boolean checkType) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldKey)) {
            return false;
        }
        FieldKey fieldKey = (FieldKey)obj;
        if (!KeyUtil.matches(this.getName(), fieldKey.getName())) {
            return false;
        }
        if (checkDefining && !KeyUtil.matches(this.getDeclaringName(), fieldKey.getDeclaringName())) {
            return false;
        }
        if (checkType) {
            return KeyUtil.matches(this.getTypeName(), fieldKey.getTypeName());
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDeclaringName());
        builder.append("->");
        builder.append(this.getName());
        String type = this.getTypeName();
        if (type != null) {
            builder.append(':');
            builder.append(this.getTypeName());
        }
        return builder.toString();
    }

    public static FieldKey parse(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() < 6 || text.charAt(0) != 'L') {
            return null;
        }
        int i = text.indexOf(";->");
        if (i < 0) {
            return null;
        }
        String defining = text.substring(0, i + 1);
        if ((i = (text = text.substring(i + 3)).indexOf(58)) < 0) {
            return null;
        }
        String name = text.substring(0, i);
        text = text.substring(i + 1);
        String type = null;
        if (!StringsUtil.isEmpty(text)) {
            type = text;
        }
        return new FieldKey(defining, name, type);
    }

    public static FieldKey create(FieldId fieldId) {
        TypeKey defining = fieldId.getDefining();
        if (defining == null) {
            return null;
        }
        String name = fieldId.getName();
        if (name == null) {
            return null;
        }
        TypeKey fieldType = fieldId.getFieldType();
        if (fieldType == null) {
            return null;
        }
        return new FieldKey(defining.getTypeName(), name, fieldType.getTypeName());
    }

    public static FieldKey read(SmaliReader reader) throws IOException {
        TypeKey declaring = TypeKey.read(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, '-');
        SmaliParseException.expect(reader, '>');
        reader.skipWhitespacesOrComment();
        int i1 = reader.indexOfBeforeLineEnd(':');
        int i2 = reader.indexOfWhiteSpaceOrComment();
        if (i1 < 0 && i2 < 0) {
            throw new SmaliParseException("Expecting ':'", reader);
        }
        int i = i1 < 0 || i2 >= 0 && i2 < i1 ? i2 : i1;
        char stop = reader.getASCII(i);
        String name = reader.readEscapedString(stop);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, ':');
        TypeKey type = TypeKey.read(reader);
        return new FieldKey(declaring.getTypeName(), name, type.getTypeName());
    }
}

