/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Sle128Item;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.CatchAllHandler;
import com.reandroid.dex.ins.CatchTypedHandler;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.HandlerOffset;
import com.reandroid.dex.ins.HandlerOffsetArray;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.model.SmaliCodeCatch;
import com.reandroid.dex.smali.model.SmaliCodeCatchAll;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;

public class TryItem
extends FixedDexContainerWithTool
implements Iterable<Label> {
    private final HandlerOffsetArray handlerOffsetArray;
    final Sle128Item handlersCount;
    private final BlockList<CatchTypedHandler> catchTypedHandlerList;
    private CatchAllHandler catchAllHandler;
    private HandlerOffset mHandlerOffset;

    public TryItem(HandlerOffsetArray handlerOffsetArray) {
        super(3);
        this.handlerOffsetArray = handlerOffsetArray;
        this.handlersCount = new Sle128Item();
        this.catchTypedHandlerList = new BlockList();
        this.addChild(0, this.handlersCount);
        this.addChild(1, this.catchTypedHandlerList);
    }

    private TryItem() {
        super(0);
        this.handlerOffsetArray = null;
        this.handlersCount = null;
        this.catchTypedHandlerList = null;
    }

    public boolean isCopy() {
        return false;
    }

    InstructionList getInstructionList() {
        return this.getTryBlock().getInstructionList();
    }

    TryBlock getTryBlock() {
        return this.getParent(TryBlock.class);
    }

    TryItem newCopy() {
        return new Copy(this);
    }

    HandlerOffset getHandlerOffset() {
        HandlerOffset handlerOffset = this.mHandlerOffset;
        if (handlerOffset == null) {
            this.mHandlerOffset = handlerOffset = this.getHandlerOffsetArray().getOrCreate(this.getIndex());
            handlerOffset.setTryItem(this);
        }
        return handlerOffset;
    }

    HandlerOffsetArray getHandlerOffsetArray() {
        return this.handlerOffsetArray;
    }

    BlockList<CatchTypedHandler> getCatchTypedHandlerBlockList() {
        return this.catchTypedHandlerList;
    }

    Iterator<CatchTypedHandler> getCatchTypedHandlers() {
        return this.catchTypedHandlerList.iterator();
    }

    TryItem getTryItem() {
        return this;
    }

    void updateCount() {
        Sle128Item handlersCount = this.handlersCount;
        if (handlersCount == null) {
            return;
        }
        int count = this.catchTypedHandlerList.size();
        if (this.hasCatchAllHandler()) {
            count = -count;
        }
        handlersCount.set(count);
    }

    @Override
    public Iterator<Label> iterator() {
        return new ExpandIterator<Label>(this.getExceptionHandlers());
    }

    public int getCatchTypedHandlersCount() {
        return this.getCatchTypedHandlerBlockList().size();
    }

    public Iterator<ExceptionHandler> getExceptionHandlers() {
        Iterator<Object> iterator1 = EmptyIterator.of();
        CatchAllHandler handler = this.getCatchAllHandler();
        if (handler != null) {
            iterator1 = SingleIterator.of(handler);
        }
        return new CombiningIterator(this.getCatchTypedHandlers(), iterator1);
    }

    public ExceptionHandler getExceptionHandler(TypeKey typeKey) {
        Iterator<CatchTypedHandler> iterator = this.getCatchTypedHandlers();
        while (iterator.hasNext()) {
            CatchTypedHandler handler = iterator.next();
            if (!typeKey.equals(handler.getKey())) continue;
            return handler;
        }
        return null;
    }

    public int getStartAddress() {
        return this.getHandlerOffset().getStartAddress();
    }

    public void setStartAddress(int address) {
        this.getHandlerOffset().setStartAddress(address);
    }

    public int getCatchCodeUnit() {
        return this.getHandlerOffset().getCatchCodeUnit();
    }

    public void setCatchCodeUnit(int codeUnit) {
        this.getHandlerOffset().setCatchCodeUnit(codeUnit);
    }

    public boolean hasCatchAllHandler() {
        return this.getCatchAllHandler() != null;
    }

    public CatchAllHandler getCatchAllHandler() {
        return this.catchAllHandler;
    }

    public CatchAllHandler getOrCreateCatchAll() {
        CatchAllHandler handler = this.getCatchAllHandler();
        if (handler == null) {
            this.initCatchAllHandler();
            handler = this.getCatchAllHandler();
        }
        return handler;
    }

    private CatchAllHandler initCatchAllHandler() {
        CatchAllHandler catchAllHandler = this.getCatchAllHandler();
        if (catchAllHandler == null) {
            catchAllHandler = new CatchAllHandler();
            this.addChild(2, catchAllHandler);
            this.catchAllHandler = catchAllHandler;
        }
        return catchAllHandler;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateCount();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int maxPosition = reader.getPosition();
        int position = this.getHandlerOffsetArray().getItemsStart() + this.getHandlerOffset().getOffset();
        reader.seek(position);
        this.handlersCount.readBytes(reader);
        int count = this.handlersCount.get();
        boolean hasCatchAll = false;
        if (count <= 0) {
            count = -count;
            hasCatchAll = true;
        }
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        handlerList.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.readBytes(reader);
        }
        if (hasCatchAll) {
            this.initCatchAllHandler().readBytes(reader);
        }
        if (maxPosition > reader.getPosition()) {
            reader.seek(maxPosition);
        }
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        TryItem tryItem;
        if (counter.FOUND) {
            return;
        }
        Block end = counter.END;
        if (end instanceof Copy && (tryItem = ((Copy)end).getTryItem()) == this) {
            counter.FOUND = true;
            return;
        }
        super.onCountUpTo(counter);
    }

    public void removeSelf() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            tryBlock.remove(this);
        }
    }

    public void remove(ExceptionHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler == this.catchAllHandler) {
            handler.onRemove();
            this.catchAllHandler = null;
        } else if (handler instanceof CatchTypedHandler && this.catchTypedHandlerList != null && this.catchTypedHandlerList.contains(handler)) {
            this.catchTypedHandlerList.remove((CatchTypedHandler)handler);
            handler.onRemove();
        }
    }

    public void onRemove() {
        HandlerOffset handlerOffset = this.mHandlerOffset;
        BlockList<CatchTypedHandler> list = this.catchTypedHandlerList;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                CatchTypedHandler handler = list.get(i);
                handler.onRemove();
                handler.setParent(null);
            }
            list.destroy();
        }
        this.remove(this.catchAllHandler);
        if (handlerOffset != null) {
            this.mHandlerOffset = null;
            handlerOffset.removeSelf();
        }
        this.setParent(null);
    }

    public void merge(TryItem tryItem) {
        this.mergeOffset(tryItem);
        this.mergeHandlers(tryItem);
    }

    void mergeHandlers(TryItem tryItem) {
        BlockList<CatchTypedHandler> comingList = tryItem.getCatchTypedHandlerBlockList();
        int size = comingList.size();
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        handlerList.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            CatchTypedHandler coming = comingList.get(i);
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.merge(coming);
        }
        if (tryItem.hasCatchAllHandler()) {
            this.initCatchAllHandler().merge(tryItem.getCatchAllHandler());
        }
        this.updateCount();
    }

    void mergeOffset(TryItem tryItem) {
        HandlerOffset coming = tryItem.getHandlerOffset();
        HandlerOffset handlerOffset = this.getHandlerOffset();
        handlerOffset.setCatchCodeUnit(coming.getCatchCodeUnit());
        handlerOffset.setStartAddress(coming.getStartAddress());
    }

    public void fromSmali(SmaliCodeTryItem smaliCodeTryItem) {
        this.setStartAddress(smaliCodeTryItem.getStartAddress());
        SmaliSet<SmaliCodeCatch> smaliCodeCatchSet = smaliCodeTryItem.getCatchSet();
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        int size = smaliCodeCatchSet.size();
        for (int i = 0; i < size; ++i) {
            SmaliCodeCatch smaliCodeCatch = smaliCodeCatchSet.get(i);
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.fromSmali(smaliCodeCatch);
        }
        SmaliCodeCatchAll smaliCodeCatchAll = smaliCodeTryItem.getCatchAll();
        if (smaliCodeCatchAll != null) {
            CatchAllHandler catchAllHandler = this.initCatchAllHandler();
            catchAllHandler.fromSmali(smaliCodeCatchAll);
        }
        this.updateCount();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryItem tryItem = (TryItem)obj;
        return Objects.equals(this.catchTypedHandlerList, tryItem.catchTypedHandlerList) && Objects.equals(this.catchAllHandler, tryItem.catchAllHandler);
    }

    public int hashCode() {
        int hash = 1;
        hash *= 31;
        Block obj = this.catchTypedHandlerList;
        if (obj != null) {
            hash = hash * 31 + obj.hashCode();
        }
        hash *= 31;
        obj = this.catchAllHandler;
        if (obj != null) {
            hash = hash * 31 + obj.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<ExceptionHandler> handlers = this.getExceptionHandlers();
        while (handlers.hasNext()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(handlers.next());
        }
        return builder.toString();
    }

    static class Copy
    extends TryItem {
        private final TryItem tryItem;

        public Copy(TryItem tryItem) {
            this.tryItem = tryItem;
        }

        @Override
        public boolean isCopy() {
            return true;
        }

        @Override
        TryBlock getTryBlock() {
            return this.tryItem.getTryBlock();
        }

        @Override
        TryItem newCopy() {
            return this.tryItem.newCopy();
        }

        @Override
        HandlerOffsetArray getHandlerOffsetArray() {
            return this.tryItem.getHandlerOffsetArray();
        }

        @Override
        Iterator<CatchTypedHandler> getCatchTypedHandlers() {
            return ComputeIterator.of(this.tryItem.getCatchTypedHandlers(), new Function<CatchTypedHandler, CatchTypedHandler>(){

                @Override
                public CatchTypedHandler apply(CatchTypedHandler catchTypedHandler) {
                    CatchTypedHandler copy = catchTypedHandler.newCopy();
                    copy.setParent(this);
                    return copy;
                }
            });
        }

        @Override
        BlockList<CatchTypedHandler> getCatchTypedHandlerBlockList() {
            return this.tryItem.getCatchTypedHandlerBlockList();
        }

        @Override
        TryItem getTryItem() {
            return this.tryItem.getTryItem();
        }

        @Override
        public CatchAllHandler getCatchAllHandler() {
            CatchAllHandler catchAllHandler = this.tryItem.getCatchAllHandler();
            if (catchAllHandler != null) {
                CatchAllHandler copy = catchAllHandler.newCopy();
                copy.setParent(this);
                return copy;
            }
            return null;
        }

        @Override
        public CatchAllHandler getOrCreateCatchAll() {
            return this.tryItem.getOrCreateCatchAll();
        }

        @Override
        public int countBytes() {
            return 0;
        }

        @Override
        public int onWriteBytes(OutputStream stream) throws IOException {
            return 0;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }

        @Override
        protected void onPreRefresh() {
        }

        @Override
        protected void onRefreshed() {
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
        }

        @Override
        void updateCount() {
        }

        @Override
        void mergeHandlers(TryItem tryItem) {
        }
    }
}

