/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.HandlerOffset;
import com.reandroid.dex.ins.HandlerOffsetArray;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class TryBlock
extends FixedDexContainerWithTool
implements Creator<TryItem>,
Iterable<TryItem>,
LabelsSet {
    private final CodeItem codeItem;
    private HandlerOffsetArray handlerOffsetArray;
    private Ule128Item tryItemsCount;
    private ByteArray unknownBytes;
    private BlockList<TryItem> tryItemArray;
    private DexPositionAlign positionAlign;
    private static final int INDEX_offsetArray = 0;
    private static final int INDEX_itemsCount = 1;
    private static final int INDEX_unknownBytes = 2;
    private static final int INDEX_itemArray = 3;
    private static final int INDEX_positionAlign = 4;

    public TryBlock(CodeItem codeItem) {
        super(5);
        this.codeItem = codeItem;
    }

    InstructionList getInstructionList() {
        return this.getCodeItem().getInstructionList();
    }

    private CodeItem getCodeItem() {
        return this.codeItem;
    }

    public int getTryItemCount() {
        if (this.isNull()) {
            return 0;
        }
        return this.tryItemArray.getCount();
    }

    public int getRealTryItemCount() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return 0;
        }
        int count = 0;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            TryItem tryItem = array.get(i);
            if (tryItem.isCopy()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<? extends Label> getLabels() {
        return new ExpandIterator(this.iterator());
    }

    public TryItem createNext() {
        this.initialize();
        TryItem tryItem = this.newInstance();
        this.add(tryItem);
        return tryItem;
    }

    private void add(TryItem tryItem) {
        if (this.tryItemArray != null) {
            this.tryItemArray.add(tryItem);
            this.handlerOffsetArray.ensureSize(this.tryItemArray.size());
        }
    }

    public TryItem get(int i) {
        if (this.tryItemArray != null) {
            return this.tryItemArray.get(i);
        }
        return null;
    }

    @Override
    public Iterator<TryItem> iterator() {
        if (this.isNull()) {
            return EmptyIterator.of();
        }
        return this.tryItemArray.iterator();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        if (this.isNull()) {
            return;
        }
        this.updateHandlerOffsets();
        this.updateCount();
        this.positionAlign.align(this);
    }

    private void updateCount() {
        if (this.isNull()) {
            return;
        }
        this.tryItemsCount.set(this.getRealTryItemCount());
    }

    private void updateHandlerOffsets() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return;
        }
        int baseOffset = this.tryItemsCount.countBytes();
        HandlerOffsetArray offsetArray = this.handlerOffsetArray;
        int size = array.getCount();
        offsetArray.setSize(size);
        for (int i = 0; i < size; ++i) {
            TryItem item = array.get(i);
            HandlerOffset offset = (HandlerOffset)offsetArray.get(i);
            int count = array.countUpTo(item);
            offset.setOffset(count += baseOffset);
        }
    }

    private HandlerOffsetArray initHandlersOffset() {
        if (this.handlerOffsetArray == null) {
            this.handlerOffsetArray = new HandlerOffsetArray(this.getCodeItem().getTryCountReference());
            this.addChild(0, this.handlerOffsetArray);
        }
        return this.handlerOffsetArray;
    }

    private void initTryItemArray() {
        if (this.tryItemArray != null) {
            return;
        }
        this.tryItemsCount = new Ule128Item();
        this.addChild(1, this.tryItemsCount);
        this.tryItemArray = new BlockList<TryItem>(this);
        this.addChild(3, this.tryItemArray);
    }

    @Override
    public void setNull(boolean is_null) {
        if (is_null == this.isNull()) {
            return;
        }
        if (is_null) {
            this.clear();
        } else {
            this.initialize();
        }
    }

    private void initialize() {
        this.initHandlersOffset();
        this.initTryItemArray();
        if (this.positionAlign == null) {
            this.positionAlign = new DexPositionAlign();
            this.addChild(4, this.positionAlign);
        }
    }

    private void clear() {
        if (this.handlerOffsetArray != null) {
            this.handlerOffsetArray.setParent(null);
            this.handlerOffsetArray.setIndex(-1);
            this.handlerOffsetArray = null;
        }
        if (this.tryItemsCount != null) {
            this.tryItemsCount.setParent(null);
            this.tryItemsCount.setIndex(-1);
            this.tryItemArray = null;
        }
        if (this.tryItemArray != null) {
            this.tryItemArray.clearChildes();
            this.tryItemArray.setParent(null);
            this.tryItemArray.setIndex(-1);
            this.tryItemArray = null;
        }
        if (this.positionAlign != null) {
            this.positionAlign.setParent(null);
            this.positionAlign.setIndex(-1);
            this.positionAlign = null;
        }
        this.addChild(0, null);
        this.addChild(1, null);
        this.addChild(2, null);
        this.addChild(3, null);
        this.addChild(4, null);
    }

    @Override
    public boolean isNull() {
        return this.tryItemArray == null;
    }

    public void remove(TryItem tryItem) {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        if (tryItemArray != null && tryItemArray.remove(tryItem)) {
            tryItem.onRemove();
        }
    }

    public void onRemove() {
        DexPositionAlign positionAlign;
        HandlerOffsetArray array;
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        if (tryItemArray != null) {
            this.tryItemArray = null;
            int count = tryItemArray.getCount();
            for (int i = 0; i < count; ++i) {
                TryItem tryItem = tryItemArray.getLast();
                tryItem.onRemove();
            }
            tryItemArray.clearChildes();
        }
        if ((array = this.handlerOffsetArray) != null) {
            array.setSize(0);
            this.handlerOffsetArray = null;
        }
        if ((positionAlign = this.positionAlign) != null) {
            this.positionAlign = null;
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean is_null = this.getCodeItem().getTryCountReference().get() == 0;
        this.setNull(is_null);
        if (is_null) {
            return;
        }
        this.handlerOffsetArray.onReadBytes(reader);
        this.tryItemsCount.onReadBytes(reader);
        this.readUnknownBytes(reader);
        this.tryItemArray.setSize(this.handlerOffsetArray.size());
        this.tryItemArray.readChildes(reader);
        this.positionAlign.onReadBytes(reader);
    }

    private void setUnknownBytes(int count) {
        if (count <= 0 || this.isNull()) {
            ByteArray unknown = this.unknownBytes;
            if (unknown != null) {
                unknown.setParent(null);
                unknown.setIndex(-1);
                unknown.setSize(0);
                this.unknownBytes = null;
            }
            return;
        }
        ByteArray unknown = this.unknownBytes;
        if (unknown == null) {
            this.unknownBytes = unknown = new ByteArray(count);
            unknown.setParent(this);
            this.addChild(2, unknown);
        } else {
            unknown.setSize(count);
        }
    }

    private void readUnknownBytes(BlockReader reader) throws IOException {
        int minStart = this.handlerOffsetArray.getMinStart();
        this.setUnknownBytes(minStart -= this.tryItemsCount.countBytes());
        ByteArray unknown = this.unknownBytes;
        if (unknown != null) {
            unknown.readBytes(reader);
        }
    }

    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    @Override
    public TryItem newInstance() {
        return new TryItem(this.initHandlersOffset());
    }

    public TryItem[] newArrayInstance(int length) {
        return new TryItem[length];
    }

    @Override
    public TryItem newInstanceAt(int index) {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        HandlerOffsetArray offsetArray = this.initHandlersOffset();
        if (tryItemArray.size() < 2) {
            return new TryItem(offsetArray);
        }
        int i = offsetArray.indexOf(offsetArray.getOffset(index));
        TryItem tryItem = null;
        if (i >= 0 && i < index && (tryItem = tryItemArray.get(i)) != null) {
            tryItem = tryItem.newCopy();
        }
        if (tryItem == null) {
            tryItem = new TryItem(offsetArray);
        }
        return tryItem;
    }

    public void merge(TryBlock tryBlock) {
        boolean is_null = tryBlock.isNull();
        this.setNull(is_null);
        if (is_null) {
            return;
        }
        int count = tryBlock.getTryItemCount();
        for (int i = 0; i < count; ++i) {
            TryItem comingSource;
            TryItem coming = tryBlock.get(i);
            TryItem tryItem = coming != (comingSource = coming.getTryItem()) ? this.get(comingSource.getIndex()).newCopy() : this.newInstance();
            this.add(tryItem);
            tryItem.merge(coming);
        }
        this.updateHandlerOffsets();
        this.updateCount();
    }

    public void fromSmali(SmaliCodeTryItem smaliCodeTryItem) {
        this.initialize();
        TryItem tryItem = this.newInstance();
        this.add(tryItem);
        this.initHandlersOffset().setSize(this.tryItemArray.size());
        tryItem.fromSmali(smaliCodeTryItem);
        this.updateHandlerOffsets();
        this.updateCount();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryBlock tryBlock = (TryBlock)obj;
        if (this.isNull()) {
            return tryBlock.isNull();
        }
        return Objects.equals(this.handlerOffsetArray, tryBlock.handlerOffsetArray) && Objects.equals(this.tryItemArray, tryBlock.tryItemArray);
    }

    public int hashCode() {
        int hash = 1;
        BlockList obj = this.handlerOffsetArray;
        hash *= 31;
        if (obj != null) {
            hash += ((Object)obj).hashCode();
        }
        obj = this.tryItemArray;
        hash *= 31;
        if (obj != null) {
            hash += ((Object)obj).hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return "tryItems = " + this.tryItemArray.toString() + ", bytes=" + this.countBytes();
    }
}

