/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.RegisterReference;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.SizedSupplier;
import java.io.IOException;
import java.util.Iterator;

public class RegistersIterator
implements SizedSupplier<RegisterReference>,
Iterable<RegisterReference>,
SmaliFormat {
    private final RegistersTable registersTable;
    private final RegistersSet registersSet;

    public RegistersIterator(RegistersTable registersTable, RegistersSet registersSet) {
        this.registersTable = registersTable;
        this.registersSet = registersSet;
    }

    @Override
    public RegisterReference get(int index) {
        return new RegisterReference(this.getRegistersTable(), this.getRegistersSet(), index);
    }

    @Override
    public int size() {
        return this.getRegistersSet().getRegistersCount();
    }

    public void setSize(int size) {
        this.getRegistersSet().setRegistersCount(size);
    }

    public boolean isRange() {
        return this.getRegistersSet().isRegistersRange();
    }

    @Override
    public Iterator<RegisterReference> iterator() {
        return new IndexIterator<RegisterReference>(this);
    }

    public RegistersSet getRegistersSet() {
        return this.registersSet;
    }

    public RegistersTable getRegistersTable() {
        return this.registersTable;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        if (size == 0) {
            return;
        }
        if (this.getRegistersSet().isRegistersRange()) {
            this.get(0).append(writer);
            writer.append(" .. ");
            this.get(size - 1).append(writer);
            return;
        }
        String separator = ", ";
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                writer.append(separator);
            }
            this.get(i).append(writer);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegistersIterator)) {
            return false;
        }
        RegistersIterator iterator = (RegistersIterator)obj;
        int size = this.size();
        if (size != iterator.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.get(i).equals(iterator.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = hash * 31 + this.get(i).hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String separator = ", ";
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                builder.append(separator);
            }
            builder.append(this.get(i));
        }
        return builder.toString();
    }
}

