/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.data.IntegerList;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class PackedSwitchDataList
extends IntegerList
implements SmaliFormat,
LabelsSet {
    private final IntegerReference firstKey;
    private final InsPackedSwitchData switchData;

    public PackedSwitchDataList(InsPackedSwitchData switchData, IntegerReference itemCount, IntegerReference firstKey) {
        super(itemCount);
        this.firstKey = firstKey;
        this.switchData = switchData;
    }

    public int getFirstKey() {
        return this.firstKey.get();
    }

    public int getBaseAddress() {
        InsPackedSwitch packedSwitch = this.switchData.getParentPackedSwitch();
        if (packedSwitch == null) {
            return 0;
        }
        return packedSwitch.getAddress();
    }

    @Override
    public int size() {
        return super.size();
    }

    public Data getData(int index) {
        return new Data(this, index);
    }

    public void merge(PackedSwitchDataList dataList) {
        this.firstKey.set(dataList.firstKey.get());
        int size = dataList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.put(i, dataList.get(i));
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.getData(i).append(writer);
        }
    }

    public Iterator<Data> getLabels() {
        return new ArraySupplierIterator<Data>(new ArraySupplier<Data>(){

            @Override
            public Data get(int i) {
                return PackedSwitchDataList.this.getData(i);
            }

            @Override
            public int getCount() {
                return PackedSwitchDataList.this.size();
            }
        });
    }

    public static class Data
    implements IntegerReference,
    SmaliFormat,
    Label {
        private final PackedSwitchDataList dataList;
        private final int index;

        Data(PackedSwitchDataList dataList, int index) {
            this.dataList = dataList;
            this.index = index;
        }

        @Override
        public void set(int value) {
            this.dataList.put(this.index, value);
        }

        @Override
        public int get() {
            return this.dataList.get(this.index);
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.newLine();
            writer.append(this.getLabelName());
        }

        @Override
        public void appendExtra(SmaliWriter writer) throws IOException {
            writer.append(this.getLabelName());
        }

        @Override
        public int getAddress() {
            return this.get();
        }

        @Override
        public int getTargetAddress() {
            return this.dataList.getBaseAddress() + this.get();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.set(targetAddress - this.dataList.getBaseAddress());
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":pswitch_", this.getTargetAddress(), 1);
        }

        public int hashCode() {
            return Objects.hash(this.dataList, this.index);
        }

        @Override
        public int getSortOrder() {
            return 5;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Data data = (Data)obj;
            return this.index == data.index && this.dataList == data.dataList;
        }

        public String toString() {
            return this.getLabelName();
        }
    }
}

