/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.BlockCreator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.common.OperandType;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Ins10x;
import com.reandroid.dex.ins.Ins11x;
import com.reandroid.dex.ins.Ins12x;
import com.reandroid.dex.ins.Ins20bc;
import com.reandroid.dex.ins.Ins21c;
import com.reandroid.dex.ins.Ins21s;
import com.reandroid.dex.ins.Ins21t;
import com.reandroid.dex.ins.Ins22b;
import com.reandroid.dex.ins.Ins22c;
import com.reandroid.dex.ins.Ins22cs;
import com.reandroid.dex.ins.Ins22s;
import com.reandroid.dex.ins.Ins22t;
import com.reandroid.dex.ins.Ins22x;
import com.reandroid.dex.ins.Ins23x;
import com.reandroid.dex.ins.Ins31i;
import com.reandroid.dex.ins.Ins32x;
import com.reandroid.dex.ins.Ins35c;
import com.reandroid.dex.ins.Ins35mi;
import com.reandroid.dex.ins.Ins35ms;
import com.reandroid.dex.ins.Ins3rc;
import com.reandroid.dex.ins.Ins3rmi;
import com.reandroid.dex.ins.Ins3rms;
import com.reandroid.dex.ins.Ins45cc;
import com.reandroid.dex.ins.Ins4rcc;
import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.InsConst;
import com.reandroid.dex.ins.InsConst16;
import com.reandroid.dex.ins.InsConst16High;
import com.reandroid.dex.ins.InsConst4;
import com.reandroid.dex.ins.InsConstString;
import com.reandroid.dex.ins.InsConstStringJumbo;
import com.reandroid.dex.ins.InsConstWide;
import com.reandroid.dex.ins.InsConstWide16;
import com.reandroid.dex.ins.InsConstWide32;
import com.reandroid.dex.ins.InsConstWideHigh16;
import com.reandroid.dex.ins.InsFillArrayData;
import com.reandroid.dex.ins.InsGoto;
import com.reandroid.dex.ins.InsNop;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CombiningIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Opcode<T extends Ins>
implements BlockCreator<T>,
SmaliFormat {
    private static final Opcode<?>[] VALUES;
    private static final Opcode<?>[] PAYLOADS;
    private static final Opcode<?>[] VALUES_2;
    private static final Opcode<?>[] VALUES_3;
    private static final Map<String, Opcode<?>> NAME_MAP;
    public static final Opcode<InsNop> NOP;
    public static final Opcode<Ins12x> MOVE;
    public static final Opcode<Ins22x> MOVE_FROM16;
    public static final Opcode<Ins32x> MOVE_16;
    public static final Opcode<Ins12x> MOVE_WIDE;
    public static final Opcode<Ins22x> MOVE_WIDE_FROM16;
    public static final Opcode<Ins32x> MOVE_WIDE_16;
    public static final Opcode<Ins12x> MOVE_OBJECT;
    public static final Opcode<Ins22x> MOVE_OBJECT_FROM16;
    public static final Opcode<Ins32x> MOVE_OBJECT_16;
    public static final Opcode<Ins11x> MOVE_RESULT;
    public static final Opcode<Ins11x> MOVE_RESULT_WIDE;
    public static final Opcode<Ins11x> MOVE_RESULT_OBJECT;
    public static final Opcode<Ins11x> MOVE_EXCEPTION;
    public static final Opcode<Ins10x> RETURN_VOID;
    public static final Opcode<Ins11x> RETURN;
    public static final Opcode<Ins11x> RETURN_WIDE;
    public static final Opcode<Ins11x> RETURN_OBJECT;
    public static final Opcode<InsConst4> CONST_4;
    public static final Opcode<InsConst16> CONST_16;
    public static final Opcode<InsConst> CONST;
    public static final Opcode<InsConst16High> CONST_HIGH16;
    public static final Opcode<InsConstWide16> CONST_WIDE_16;
    public static final Opcode<InsConstWide32> CONST_WIDE_32;
    public static final Opcode<InsConstWide> CONST_WIDE;
    public static final Opcode<InsConstWideHigh16> CONST_WIDE_HIGH16;
    public static final Opcode<InsConstString> CONST_STRING;
    public static final Opcode<InsConstStringJumbo> CONST_STRING_JUMBO;
    public static final Opcode<Ins21c> CONST_CLASS;
    public static final Opcode<Ins11x> MONITOR_ENTER;
    public static final Opcode<Ins11x> MONITOR_EXIT;
    public static final Opcode<Ins21c> CHECK_CAST;
    public static final Opcode<Ins22c> INSTANCE_OF;
    public static final Opcode<Ins12x> ARRAY_LENGTH;
    public static final Opcode<Ins21c> NEW_INSTANCE;
    public static final Opcode<Ins22c> NEW_ARRAY;
    public static final Opcode<Ins35c> FILLED_NEW_ARRAY;
    public static final Opcode<Ins3rc> FILLED_NEW_ARRAY_RANGE;
    public static final Opcode<InsFillArrayData> FILL_ARRAY_DATA;
    public static final Opcode<Ins11x> THROW;
    public static final Opcode<InsGoto> GOTO;
    public static final Opcode<InsGoto> GOTO_16;
    public static final Opcode<InsGoto> GOTO_32;
    public static final Opcode<InsPackedSwitch> PACKED_SWITCH;
    public static final Opcode<InsSparseSwitch> SPARSE_SWITCH;
    public static final Opcode<Ins23x> CMPL_FLOAT;
    public static final Opcode<Ins23x> CMPG_FLOAT;
    public static final Opcode<Ins23x> CMPL_DOUBLE;
    public static final Opcode<Ins23x> CMPG_DOUBLE;
    public static final Opcode<Ins23x> CMP_LONG;
    public static final Opcode<Ins22t> IF_EQ;
    public static final Opcode<Ins22t> IF_NE;
    public static final Opcode<Ins22t> IF_LT;
    public static final Opcode<Ins22t> IF_GE;
    public static final Opcode<Ins22t> IF_GT;
    public static final Opcode<Ins22t> IF_LE;
    public static final Opcode<Ins21t> IF_EQZ;
    public static final Opcode<Ins21t> IF_NEZ;
    public static final Opcode<Ins21t> IF_LTZ;
    public static final Opcode<Ins21t> IF_GEZ;
    public static final Opcode<Ins21t> IF_GTZ;
    public static final Opcode<Ins21t> IF_LEZ;
    public static final Opcode<Ins23x> AGET;
    public static final Opcode<Ins23x> AGET_WIDE;
    public static final Opcode<Ins23x> AGET_OBJECT;
    public static final Opcode<Ins23x> AGET_BOOLEAN;
    public static final Opcode<Ins23x> AGET_BYTE;
    public static final Opcode<Ins23x> AGET_CHAR;
    public static final Opcode<Ins23x> AGET_SHORT;
    public static final Opcode<Ins23x> APUT;
    public static final Opcode<Ins23x> APUT_WIDE;
    public static final Opcode<Ins23x> APUT_OBJECT;
    public static final Opcode<Ins23x> APUT_BOOLEAN;
    public static final Opcode<Ins23x> APUT_BYTE;
    public static final Opcode<Ins23x> APUT_CHAR;
    public static final Opcode<Ins23x> APUT_SHORT;
    public static final Opcode<Ins22c> IGET;
    public static final Opcode<Ins22c> IGET_WIDE;
    public static final Opcode<Ins22c> IGET_OBJECT;
    public static final Opcode<Ins22c> IGET_BOOLEAN;
    public static final Opcode<Ins22c> IGET_BYTE;
    public static final Opcode<Ins22c> IGET_CHAR;
    public static final Opcode<Ins22c> IGET_SHORT;
    public static final Opcode<Ins22c> IPUT;
    public static final Opcode<Ins22c> IPUT_WIDE;
    public static final Opcode<Ins22c> IPUT_OBJECT;
    public static final Opcode<Ins22c> IPUT_BOOLEAN;
    public static final Opcode<Ins22c> IPUT_BYTE;
    public static final Opcode<Ins22c> IPUT_CHAR;
    public static final Opcode<Ins22c> IPUT_SHORT;
    public static final Opcode<Ins21c> SGET;
    public static final Opcode<Ins21c> SGET_WIDE;
    public static final Opcode<Ins21c> SGET_OBJECT;
    public static final Opcode<Ins21c> SGET_BOOLEAN;
    public static final Opcode<Ins21c> SGET_BYTE;
    public static final Opcode<Ins21c> SGET_CHAR;
    public static final Opcode<Ins21c> SGET_SHORT;
    public static final Opcode<Ins21c> SPUT;
    public static final Opcode<Ins21c> SPUT_WIDE;
    public static final Opcode<Ins21c> SPUT_OBJECT;
    public static final Opcode<Ins21c> SPUT_BOOLEAN;
    public static final Opcode<Ins21c> SPUT_BYTE;
    public static final Opcode<Ins21c> SPUT_CHAR;
    public static final Opcode<Ins21c> SPUT_SHORT;
    public static final Opcode<Ins35c> INVOKE_VIRTUAL;
    public static final Opcode<Ins35c> INVOKE_SUPER;
    public static final Opcode<Ins35c> INVOKE_DIRECT;
    public static final Opcode<Ins35c> INVOKE_STATIC;
    public static final Opcode<Ins35c> INVOKE_INTERFACE;
    public static final Opcode<Ins10x> RETURN_VOID_NO_BARRIER;
    public static final Opcode<Ins3rc> INVOKE_VIRTUAL_RANGE;
    public static final Opcode<Ins3rc> INVOKE_SUPER_RANGE;
    public static final Opcode<Ins3rc> INVOKE_DIRECT_RANGE;
    public static final Opcode<Ins3rc> INVOKE_STATIC_RANGE;
    public static final Opcode<Ins3rc> INVOKE_INTERFACE_RANGE;
    public static final Opcode<Ins12x> NEG_INT;
    public static final Opcode<Ins12x> NOT_INT;
    public static final Opcode<Ins12x> NEG_LONG;
    public static final Opcode<Ins12x> NOT_LONG;
    public static final Opcode<Ins12x> NEG_FLOAT;
    public static final Opcode<Ins12x> NEG_DOUBLE;
    public static final Opcode<Ins12x> INT_TO_LONG;
    public static final Opcode<Ins12x> INT_TO_FLOAT;
    public static final Opcode<Ins12x> INT_TO_DOUBLE;
    public static final Opcode<Ins12x> LONG_TO_INT;
    public static final Opcode<Ins12x> LONG_TO_FLOAT;
    public static final Opcode<Ins12x> LONG_TO_DOUBLE;
    public static final Opcode<Ins12x> FLOAT_TO_INT;
    public static final Opcode<Ins12x> FLOAT_TO_LONG;
    public static final Opcode<Ins12x> FLOAT_TO_DOUBLE;
    public static final Opcode<Ins12x> DOUBLE_TO_INT;
    public static final Opcode<Ins12x> DOUBLE_TO_LONG;
    public static final Opcode<Ins12x> DOUBLE_TO_FLOAT;
    public static final Opcode<Ins12x> INT_TO_BYTE;
    public static final Opcode<Ins12x> INT_TO_CHAR;
    public static final Opcode<Ins12x> INT_TO_SHORT;
    public static final Opcode<Ins23x> ADD_INT;
    public static final Opcode<Ins23x> SUB_INT;
    public static final Opcode<Ins23x> MUL_INT;
    public static final Opcode<Ins23x> DIV_INT;
    public static final Opcode<Ins23x> REM_INT;
    public static final Opcode<Ins23x> AND_INT;
    public static final Opcode<Ins23x> OR_INT;
    public static final Opcode<Ins23x> XOR_INT;
    public static final Opcode<Ins23x> SHL_INT;
    public static final Opcode<Ins23x> SHR_INT;
    public static final Opcode<Ins23x> USHR_INT;
    public static final Opcode<Ins23x> ADD_LONG;
    public static final Opcode<Ins23x> SUB_LONG;
    public static final Opcode<Ins23x> MUL_LONG;
    public static final Opcode<Ins23x> DIV_LONG;
    public static final Opcode<Ins23x> REM_LONG;
    public static final Opcode<Ins23x> AND_LONG;
    public static final Opcode<Ins23x> OR_LONG;
    public static final Opcode<Ins23x> XOR_LONG;
    public static final Opcode<Ins23x> SHL_LONG;
    public static final Opcode<Ins23x> SHR_LONG;
    public static final Opcode<Ins23x> USHR_LONG;
    public static final Opcode<Ins23x> ADD_FLOAT;
    public static final Opcode<Ins23x> SUB_FLOAT;
    public static final Opcode<Ins23x> MUL_FLOAT;
    public static final Opcode<Ins23x> DIV_FLOAT;
    public static final Opcode<Ins23x> REM_FLOAT;
    public static final Opcode<Ins23x> ADD_DOUBLE;
    public static final Opcode<Ins23x> SUB_DOUBLE;
    public static final Opcode<Ins23x> MUL_DOUBLE;
    public static final Opcode<Ins23x> DIV_DOUBLE;
    public static final Opcode<Ins23x> REM_DOUBLE;
    public static final Opcode<Ins12x> ADD_INT_2ADDR;
    public static final Opcode<Ins12x> SUB_INT_2ADDR;
    public static final Opcode<Ins12x> MUL_INT_2ADDR;
    public static final Opcode<Ins12x> DIV_INT_2ADDR;
    public static final Opcode<Ins12x> REM_INT_2ADDR;
    public static final Opcode<Ins12x> AND_INT_2ADDR;
    public static final Opcode<Ins12x> OR_INT_2ADDR;
    public static final Opcode<Ins12x> XOR_INT_2ADDR;
    public static final Opcode<Ins12x> SHL_INT_2ADDR;
    public static final Opcode<Ins12x> SHR_INT_2ADDR;
    public static final Opcode<Ins12x> USHR_INT_2ADDR;
    public static final Opcode<Ins12x> ADD_LONG_2ADDR;
    public static final Opcode<Ins12x> SUB_LONG_2ADDR;
    public static final Opcode<Ins12x> MUL_LONG_2ADDR;
    public static final Opcode<Ins12x> DIV_LONG_2ADDR;
    public static final Opcode<Ins12x> REM_LONG_2ADDR;
    public static final Opcode<Ins12x> AND_LONG_2ADDR;
    public static final Opcode<Ins12x> OR_LONG_2ADDR;
    public static final Opcode<Ins12x> XOR_LONG_2ADDR;
    public static final Opcode<Ins12x> SHL_LONG_2ADDR;
    public static final Opcode<Ins12x> SHR_LONG_2ADDR;
    public static final Opcode<Ins12x> USHR_LONG_2ADDR;
    public static final Opcode<Ins12x> ADD_FLOAT_2ADDR;
    public static final Opcode<Ins12x> SUB_FLOAT_2ADDR;
    public static final Opcode<Ins12x> MUL_FLOAT_2ADDR;
    public static final Opcode<Ins12x> DIV_FLOAT_2ADDR;
    public static final Opcode<Ins12x> REM_FLOAT_2ADDR;
    public static final Opcode<Ins12x> ADD_DOUBLE_2ADDR;
    public static final Opcode<Ins12x> SUB_DOUBLE_2ADDR;
    public static final Opcode<Ins12x> MUL_DOUBLE_2ADDR;
    public static final Opcode<Ins12x> DIV_DOUBLE_2ADDR;
    public static final Opcode<Ins12x> REM_DOUBLE_2ADDR;
    public static final Opcode<Ins22s> ADD_INT_LIT16;
    public static final Opcode<Ins22s> RSUB_INT;
    public static final Opcode<Ins22s> MUL_INT_LIT16;
    public static final Opcode<Ins22s> DIV_INT_LIT16;
    public static final Opcode<Ins22s> REM_INT_LIT16;
    public static final Opcode<Ins22s> AND_INT_LIT16;
    public static final Opcode<Ins22s> OR_INT_LIT16;
    public static final Opcode<Ins22s> XOR_INT_LIT16;
    public static final Opcode<Ins22b> ADD_INT_LIT8;
    public static final Opcode<Ins22b> RSUB_INT_LIT8;
    public static final Opcode<Ins22b> MUL_INT_LIT8;
    public static final Opcode<Ins22b> DIV_INT_LIT8;
    public static final Opcode<Ins22b> REM_INT_LIT8;
    public static final Opcode<Ins22b> AND_INT_LIT8;
    public static final Opcode<Ins22b> OR_INT_LIT8;
    public static final Opcode<Ins22b> XOR_INT_LIT8;
    public static final Opcode<Ins22b> SHL_INT_LIT8;
    public static final Opcode<Ins22b> SHR_INT_LIT8;
    public static final Opcode<Ins22b> USHR_INT_LIT8;
    public static final Opcode<Ins22c> IGET_VOLATILE;
    public static final Opcode<Ins22c> IPUT_VOLATILE;
    public static final Opcode<Ins21c> SGET_VOLATILE;
    public static final Opcode<Ins21c> SPUT_VOLATILE;
    public static final Opcode<Ins22c> IGET_OBJECT_VOLATILE;
    public static final Opcode<Ins22c> IGET_WIDE_VOLATILE;
    public static final Opcode<Ins22c> IPUT_WIDE_VOLATILE;
    public static final Opcode<Ins21c> SGET_WIDE_VOLATILE;
    public static final Opcode<Ins21c> SPUT_WIDE_VOLATILE;
    public static final Opcode<Ins22cs> IPUT_BYTE_QUICK;
    public static final Opcode<Ins20bc> THROW_VERIFICATION_ERROR;
    public static final Opcode<Ins35mi> EXECUTE_INLINE;
    public static final Opcode<Ins3rmi> EXECUTE_INLINE_RANGE;
    public static final Opcode<Ins35c> INVOKE_DIRECT_EMPTY;
    public static final Opcode<Ins10x> RETURN_VOID_BARRIER;
    public static final Opcode<Ins22cs> IGET_QUICK;
    public static final Opcode<Ins22cs> IGET_WIDE_QUICK;
    public static final Opcode<Ins22cs> IGET_OBJECT_QUICK;
    public static final Opcode<Ins22cs> IPUT_QUICK;
    public static final Opcode<Ins22cs> IPUT_WIDE_QUICK;
    public static final Opcode<Ins22cs> IPUT_OBJECT_QUICK;
    public static final Opcode<Ins35ms> INVOKE_VIRTUAL_QUICK;
    public static final Opcode<Ins3rms> INVOKE_VIRTUAL_QUICK_RANGE;
    public static final Opcode<Ins35ms> INVOKE_SUPER_QUICK;
    public static final Opcode<Ins3rms> INVOKE_SUPER_QUICK_RANGE;
    public static final Opcode<Ins22c> IPUT_OBJECT_VOLATILE;
    public static final Opcode<Ins21c> SGET_OBJECT_VOLATILE;
    public static final Opcode<Ins21c> SPUT_OBJECT_VOLATILE;
    public static final Opcode<Ins21c> CONST_METHOD_TYPE;
    public static final Opcode<InsPackedSwitchData> PACKED_SWITCH_PAYLOAD;
    public static final Opcode<InsSparseSwitchData> SPARSE_SWITCH_PAYLOAD;
    public static final Opcode<InsArrayData> ARRAY_PAYLOAD;
    public static final Opcode<Ins22cs> IPUT_BOOLEAN_QUICK;
    public static final Opcode<Ins22cs> IPUT_CHAR_QUICK;
    public static final Opcode<Ins22cs> IPUT_SHORT_QUICK;
    public static final Opcode<Ins22cs> IGET_BOOLEAN_QUICK;
    public static final Opcode<Ins3rc> INVOKE_OBJECT_INIT_RANGE;
    public static final Opcode<Ins22cs> IGET_CHAR_QUICK;
    public static final Opcode<Ins22cs> IGET_SHORT_QUICK;
    public static final Opcode<Ins45cc> INVOKE_POLYMORPHIC;
    public static final Opcode<Ins4rcc> INVOKE_POLYMORPHIC_RANGE;
    public static final Opcode<Ins35c> INVOKE_CUSTOM;
    public static final Opcode<Ins3rc> INVOKE_CUSTOM_RANGE;
    public static final Opcode<Ins21c> CONST_METHOD_HANDLE;
    public static final Opcode<Ins22cs> IGET_BYTE_QUICK;
    private final int value;
    private final int size;
    private final String name;
    private final SectionType<? extends IdItem> sectionType;
    private final InsCreator<T> creator;

    private Opcode(int value, int size, String name, SectionType<? extends IdItem> sectionType, InsCreator<T> creator) {
        this.value = value;
        this.size = size;
        this.name = name;
        this.sectionType = sectionType;
        this.creator = creator;
    }

    private Opcode(int value, int size, String name, InsCreator<T> creator) {
        this(value, size, name, null, creator);
    }

    public int getValue() {
        return this.value;
    }

    public int size() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasOutRegisters() {
        if (this.getSectionType() == SectionType.METHOD_ID) {
            return true;
        }
        return this == FILLED_NEW_ARRAY || this == FILLED_NEW_ARRAY_RANGE;
    }

    public boolean isFieldAccess() {
        return this.getSectionType() == SectionType.FIELD_ID;
    }

    public boolean isFieldGet() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        return this.getName().charAt(1) == 'g';
    }

    public boolean isFieldPut() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        return this.getName().charAt(1) == 'p';
    }

    public boolean isFieldAccessStatic() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        return this.getName().charAt(0) == 's';
    }

    public boolean isFieldAccessVirtual() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        return this.getName().charAt(0) == 'i';
    }

    public boolean isFieldStaticGet() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        String name = this.getName();
        return name.charAt(0) == 's' && name.charAt(1) == 'g';
    }

    public boolean isFieldStaticPut() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        String name = this.getName();
        return name.charAt(0) == 's' && name.charAt(1) == 'p';
    }

    public boolean isFieldVirtualGet() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        String name = this.getName();
        return name.charAt(0) == 'i' && name.charAt(1) == 'g';
    }

    public boolean isFieldVirtualPut() {
        if (this.getSectionType() != SectionType.FIELD_ID) {
            return false;
        }
        String name = this.getName();
        return name.charAt(0) == 'i' && name.charAt(1) == 'p';
    }

    public boolean isMethodInvoke() {
        return this.getSectionType() == SectionType.METHOD_ID;
    }

    public boolean isMethodInvokeStatic() {
        if (this.getSectionType() != SectionType.METHOD_ID) {
            return false;
        }
        return this.getName().charAt(8) == 't';
    }

    public boolean isReturning() {
        String name = this.getName();
        return name.charAt(0) == 'r' && name.charAt(2) == 't';
    }

    public boolean isMoveResultValue() {
        String name = this.getName();
        if (name.length() < 6) {
            return false;
        }
        return name.charAt(0) == 'm' && name.charAt(5) == 'r';
    }

    public SectionType<? extends IdItem> getSectionType() {
        return this.sectionType;
    }

    public RegisterFormat getRegisterFormat() {
        return this.creator.getRegisterFormat();
    }

    public OperandType getOperandType() {
        return this.creator.getOperandType();
    }

    @Override
    public T newInstance() {
        return (T)((Ins)this.creator.newInstance());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getName());
        writer.append(' ');
    }

    public String toString() {
        return this.getName();
    }

    public static Opcode<?> valueOf(int value) {
        if (value <= 255) {
            return VALUES[value];
        }
        for (Opcode<?> opcode : PAYLOADS) {
            if (value != opcode.value) continue;
            return opcode;
        }
        return null;
    }

    public static Opcode<?> valueOf(String name) {
        return NAME_MAP.get(name);
    }

    public static Iterator<Opcode<?>> values() {
        return CombiningIterator.four(new ArrayIterator(VALUES), new ArrayIterator(PAYLOADS), new ArrayIterator(VALUES_2), new ArrayIterator(VALUES_3));
    }

    public static Opcode<?> read(BlockReader reader) throws IOException {
        int value = reader.read();
        if (value == 0) {
            value = reader.read() << 8;
            reader.offset(-1);
        }
        reader.offset(-1);
        return Opcode.valueOf(value);
    }

    public static Opcode<?> parseSmali(SmaliReader reader, boolean skip) {
        reader.skipWhitespaces();
        if (!Opcode.isPrefix(reader.get())) {
            return null;
        }
        int i = reader.indexOfWhiteSpaceOrComment();
        String name = skip ? reader.readString(i) : reader.getString(i -= reader.position());
        return Opcode.valueOf(name);
    }

    public static Opcode<?> parse(String line) {
        return Opcode.parse(0, line);
    }

    public static Opcode<?> parse(int start, String smali) {
        int i1 = StringsUtil.skipWhitespace(start, smali);
        if (i1 == smali.length()) {
            return null;
        }
        int i2 = smali.indexOf(32, i1 + 1);
        if (i2 < i1) {
            return null;
        }
        return Opcode.valueOf(smali.substring(i1, i2));
    }

    public static boolean isPrefix(byte b) {
        switch (b) {
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    static {
        Opcode[] values = new Opcode[256];
        VALUES = values;
        PAYLOADS = new Opcode[3];
        VALUES_2 = new Opcode[12];
        VALUES_3 = new Opcode[1];
        HashMap map = new HashMap();
        NAME_MAP = map;
        values[0] = NOP = new Opcode<InsNop>(0, 2, "nop", new InsNopCreator(0));
        values[1] = MOVE = new Opcode<Ins12x>(1, 2, "move", new Ins12xCreator(1));
        values[2] = MOVE_FROM16 = new Opcode<Ins22x>(2, 4, "move/from16", new Ins22xCreator(2));
        values[3] = MOVE_16 = new Opcode<Ins32x>(3, 6, "move/16", new Ins32xCreator(3));
        values[4] = MOVE_WIDE = new Opcode<Ins12x>(4, 2, "move-wide", new Ins12xCreator(4));
        values[5] = MOVE_WIDE_FROM16 = new Opcode<Ins22x>(5, 4, "move-wide/from16", new Ins22xCreator(5));
        values[6] = MOVE_WIDE_16 = new Opcode<Ins32x>(6, 6, "move-wide/16", new Ins32xCreator(6));
        values[7] = MOVE_OBJECT = new Opcode<Ins12x>(7, 2, "move-object", new Ins12xCreator(7));
        values[8] = MOVE_OBJECT_FROM16 = new Opcode<Ins22x>(8, 4, "move-object/from16", new Ins22xCreator(8));
        values[9] = MOVE_OBJECT_16 = new Opcode<Ins32x>(9, 6, "move-object/16", new Ins32xCreator(9));
        values[10] = MOVE_RESULT = new Opcode<Ins11x>(10, 2, "move-result", new Ins11xWriteCreator(10));
        values[11] = MOVE_RESULT_WIDE = new Opcode<Ins11x>(11, 2, "move-result-wide", new Ins11xWriteCreator(11));
        values[12] = MOVE_RESULT_OBJECT = new Opcode<Ins11x>(12, 2, "move-result-object", new Ins11xWriteCreator(12));
        values[13] = MOVE_EXCEPTION = new Opcode<Ins11x>(13, 2, "move-exception", new Ins11xWriteCreator(13));
        values[14] = RETURN_VOID = new Opcode<Ins10x>(14, 2, "return-void", new Ins10xCreator(14));
        values[15] = RETURN = new Opcode<Ins11x>(15, 2, "return", new Ins11xCreator(15));
        values[16] = RETURN_WIDE = new Opcode<Ins11x>(16, 2, "return-wide", new Ins11xCreator(16));
        values[17] = RETURN_OBJECT = new Opcode<Ins11x>(17, 2, "return-object", new Ins11xCreator(17));
        values[18] = CONST_4 = new Opcode<InsConst4>(18, 2, "const/4", new InsConst4Creator(18));
        values[19] = CONST_16 = new Opcode<InsConst16>(19, 4, "const/16", new InsConst16Creator(19));
        values[20] = CONST = new Opcode<InsConst>(20, 6, "const", new InsConstCreator(20));
        values[21] = CONST_HIGH16 = new Opcode<InsConst16High>(21, 4, "const/high16", new InsConst16HighCreator(21));
        values[22] = CONST_WIDE_16 = new Opcode<InsConstWide16>(22, 4, "const-wide/16", new InsConstWide16Creator(22));
        values[23] = CONST_WIDE_32 = new Opcode<InsConstWide32>(23, 6, "const-wide/32", new InsConstWide32Creator(23));
        values[24] = CONST_WIDE = new Opcode<InsConstWide>(24, 10, "const-wide", new InsConstWideCreator(24));
        values[25] = CONST_WIDE_HIGH16 = new Opcode<InsConstWideHigh16>(25, 4, "const-wide/high16", new InsConstWideHigh16Creator(25));
        values[26] = CONST_STRING = new Opcode<InsConstString>(26, 4, "const-string", SectionType.STRING_ID, new InsConstStringCreator(26));
        values[27] = CONST_STRING_JUMBO = new Opcode<InsConstStringJumbo>(27, 6, "const-string/jumbo", SectionType.STRING_ID, new InsConstStringJumboCreator(27));
        values[28] = CONST_CLASS = new Opcode<Ins21c>(28, 4, "const-class", SectionType.TYPE_ID, new Ins21cCreator(28));
        values[29] = MONITOR_ENTER = new Opcode<Ins11x>(29, 2, "monitor-enter", new Ins11xCreator(29));
        values[30] = MONITOR_EXIT = new Opcode<Ins11x>(30, 2, "monitor-exit", new Ins11xCreator(30));
        values[31] = CHECK_CAST = new Opcode<Ins21c>(31, 4, "check-cast", SectionType.TYPE_ID, new Ins21cCreator(31));
        values[32] = INSTANCE_OF = new Opcode<Ins22c>(32, 4, "instance-of", SectionType.TYPE_ID, new Ins22cCreator(32));
        values[33] = ARRAY_LENGTH = new Opcode<Ins12x>(33, 2, "array-length", new Ins12xCreator(33));
        values[34] = NEW_INSTANCE = new Opcode<Ins21c>(34, 4, "new-instance", SectionType.TYPE_ID, new Ins21cCreator(34));
        values[35] = NEW_ARRAY = new Opcode<Ins22c>(35, 4, "new-array", SectionType.TYPE_ID, new Ins22cCreator(35));
        values[36] = FILLED_NEW_ARRAY = new Opcode<Ins35c>(36, 6, "filled-new-array", SectionType.TYPE_ID, new Ins35cCreator(36));
        values[37] = FILLED_NEW_ARRAY_RANGE = new Opcode<Ins3rc>(37, 6, "filled-new-array/range", SectionType.TYPE_ID, new Ins3rcCreator(37));
        values[38] = FILL_ARRAY_DATA = new Opcode<InsFillArrayData>(38, 6, "fill-array-data", new InsFillArrayDataCreator(38));
        values[39] = THROW = new Opcode<Ins11x>(39, 2, "throw", new Ins11xCreator(39));
        values[40] = GOTO = new Opcode<InsGoto>(40, 2, "goto", new InsGotoCreator(40));
        values[41] = GOTO_16 = new Opcode<InsGoto>(41, 4, "goto/16", new InsGotoCreator(41));
        values[42] = GOTO_32 = new Opcode<InsGoto>(42, 6, "goto/32", new InsGotoCreator(42));
        values[43] = PACKED_SWITCH = new Opcode<InsPackedSwitch>(43, 6, "packed-switch", new InsPackedSwitchCreator(43));
        values[44] = SPARSE_SWITCH = new Opcode<InsSparseSwitch>(44, 6, "sparse-switch", new InsSparseSwitchCreator(44));
        values[45] = CMPL_FLOAT = new Opcode<Ins23x>(45, 4, "cmpl-float", new Ins23xCreator(45));
        values[46] = CMPG_FLOAT = new Opcode<Ins23x>(46, 4, "cmpg-float", new Ins23xCreator(46));
        values[47] = CMPL_DOUBLE = new Opcode<Ins23x>(47, 4, "cmpl-double", new Ins23xCreator(47));
        values[48] = CMPG_DOUBLE = new Opcode<Ins23x>(48, 4, "cmpg-double", new Ins23xCreator(48));
        values[49] = CMP_LONG = new Opcode<Ins23x>(49, 4, "cmp-long", new Ins23xCreator(49));
        values[50] = IF_EQ = new Opcode<Ins22t>(50, 4, "if-eq", new Ins22tCreator(50));
        values[51] = IF_NE = new Opcode<Ins22t>(51, 4, "if-ne", new Ins22tCreator(51));
        values[52] = IF_LT = new Opcode<Ins22t>(52, 4, "if-lt", new Ins22tCreator(52));
        values[53] = IF_GE = new Opcode<Ins22t>(53, 4, "if-ge", new Ins22tCreator(53));
        values[54] = IF_GT = new Opcode<Ins22t>(54, 4, "if-gt", new Ins22tCreator(54));
        values[55] = IF_LE = new Opcode<Ins22t>(55, 4, "if-le", new Ins22tCreator(55));
        values[56] = IF_EQZ = new Opcode<Ins21t>(56, 4, "if-eqz", new Ins21tCreator(56));
        values[57] = IF_NEZ = new Opcode<Ins21t>(57, 4, "if-nez", new Ins21tCreator(57));
        values[58] = IF_LTZ = new Opcode<Ins21t>(58, 4, "if-ltz", new Ins21tCreator(58));
        values[59] = IF_GEZ = new Opcode<Ins21t>(59, 4, "if-gez", new Ins21tCreator(59));
        values[60] = IF_GTZ = new Opcode<Ins21t>(60, 4, "if-gtz", new Ins21tCreator(60));
        values[61] = IF_LEZ = new Opcode<Ins21t>(61, 4, "if-lez", new Ins21tCreator(61));
        values[68] = AGET = new Opcode<Ins23x>(68, 4, "aget", new Ins23xCreator(68));
        values[69] = AGET_WIDE = new Opcode<Ins23x>(69, 4, "aget-wide", new Ins23xCreator(69));
        values[70] = AGET_OBJECT = new Opcode<Ins23x>(70, 4, "aget-object", new Ins23xCreator(70));
        values[71] = AGET_BOOLEAN = new Opcode<Ins23x>(71, 4, "aget-boolean", new Ins23xCreator(71));
        values[72] = AGET_BYTE = new Opcode<Ins23x>(72, 4, "aget-byte", new Ins23xCreator(72));
        values[73] = AGET_CHAR = new Opcode<Ins23x>(73, 4, "aget-char", new Ins23xCreator(73));
        values[74] = AGET_SHORT = new Opcode<Ins23x>(74, 4, "aget-short", new Ins23xCreator(74));
        values[75] = APUT = new Opcode<Ins23x>(75, 4, "aput", new Ins23xAputCreator(75));
        values[76] = APUT_WIDE = new Opcode<Ins23x>(76, 4, "aput-wide", new Ins23xAputCreator(76));
        values[77] = APUT_OBJECT = new Opcode<Ins23x>(77, 4, "aput-object", new Ins23xAputCreator(77));
        values[78] = APUT_BOOLEAN = new Opcode<Ins23x>(78, 4, "aput-boolean", new Ins23xAputCreator(78));
        values[79] = APUT_BYTE = new Opcode<Ins23x>(79, 4, "aput-byte", new Ins23xAputCreator(79));
        values[80] = APUT_CHAR = new Opcode<Ins23x>(80, 4, "aput-char", new Ins23xAputCreator(80));
        values[81] = APUT_SHORT = new Opcode<Ins23x>(81, 4, "aput-short", new Ins23xAputCreator(81));
        values[82] = IGET = new Opcode<Ins22c>(82, 4, "iget", SectionType.FIELD_ID, new Ins22cCreator(82));
        values[83] = IGET_WIDE = new Opcode<Ins22c>(83, 4, "iget-wide", SectionType.FIELD_ID, new Ins22cCreator(83));
        values[84] = IGET_OBJECT = new Opcode<Ins22c>(84, 4, "iget-object", SectionType.FIELD_ID, new Ins22cCreator(84));
        values[85] = IGET_BOOLEAN = new Opcode<Ins22c>(85, 4, "iget-boolean", SectionType.FIELD_ID, new Ins22cCreator(85));
        values[86] = IGET_BYTE = new Opcode<Ins22c>(86, 4, "iget-byte", SectionType.FIELD_ID, new Ins22cCreator(86));
        values[87] = IGET_CHAR = new Opcode<Ins22c>(87, 4, "iget-char", SectionType.FIELD_ID, new Ins22cCreator(87));
        values[88] = IGET_SHORT = new Opcode<Ins22c>(88, 4, "iget-short", SectionType.FIELD_ID, new Ins22cCreator(88));
        values[89] = IPUT = new Opcode<Ins22c>(89, 4, "iput", SectionType.FIELD_ID, new Ins22cPutCreator(89));
        values[90] = IPUT_WIDE = new Opcode<Ins22c>(90, 4, "iput-wide", SectionType.FIELD_ID, new Ins22cPutCreator(90));
        values[91] = IPUT_OBJECT = new Opcode<Ins22c>(91, 4, "iput-object", SectionType.FIELD_ID, new Ins22cPutCreator(91));
        values[92] = IPUT_BOOLEAN = new Opcode<Ins22c>(92, 4, "iput-boolean", SectionType.FIELD_ID, new Ins22cPutCreator(92));
        values[93] = IPUT_BYTE = new Opcode<Ins22c>(93, 4, "iput-byte", SectionType.FIELD_ID, new Ins22cPutCreator(93));
        values[94] = IPUT_CHAR = new Opcode<Ins22c>(94, 4, "iput-char", SectionType.FIELD_ID, new Ins22cPutCreator(94));
        values[95] = IPUT_SHORT = new Opcode<Ins22c>(95, 4, "iput-short", SectionType.FIELD_ID, new Ins22cPutCreator(95));
        values[96] = SGET = new Opcode<Ins21c>(96, 4, "sget", SectionType.FIELD_ID, new Ins21cCreator(96));
        values[97] = SGET_WIDE = new Opcode<Ins21c>(97, 4, "sget-wide", SectionType.FIELD_ID, new Ins21cCreator(97));
        values[98] = SGET_OBJECT = new Opcode<Ins21c>(98, 4, "sget-object", SectionType.FIELD_ID, new Ins21cCreator(98));
        values[99] = SGET_BOOLEAN = new Opcode<Ins21c>(99, 4, "sget-boolean", SectionType.FIELD_ID, new Ins21cCreator(99));
        values[100] = SGET_BYTE = new Opcode<Ins21c>(100, 4, "sget-byte", SectionType.FIELD_ID, new Ins21cCreator(100));
        values[101] = SGET_CHAR = new Opcode<Ins21c>(101, 4, "sget-char", SectionType.FIELD_ID, new Ins21cCreator(101));
        values[102] = SGET_SHORT = new Opcode<Ins21c>(102, 4, "sget-short", SectionType.FIELD_ID, new Ins21cCreator(102));
        values[103] = SPUT = new Opcode<Ins21c>(103, 4, "sput", SectionType.FIELD_ID, new Ins21cPutCreator(103));
        values[104] = SPUT_WIDE = new Opcode<Ins21c>(104, 4, "sput-wide", SectionType.FIELD_ID, new Ins21cPutCreator(104));
        values[105] = SPUT_OBJECT = new Opcode<Ins21c>(105, 4, "sput-object", SectionType.FIELD_ID, new Ins21cPutCreator(105));
        values[106] = SPUT_BOOLEAN = new Opcode<Ins21c>(106, 4, "sput-boolean", SectionType.FIELD_ID, new Ins21cPutCreator(106));
        values[107] = SPUT_BYTE = new Opcode<Ins21c>(107, 4, "sput-byte", SectionType.FIELD_ID, new Ins21cPutCreator(107));
        values[108] = SPUT_CHAR = new Opcode<Ins21c>(108, 4, "sput-char", SectionType.FIELD_ID, new Ins21cPutCreator(108));
        values[109] = SPUT_SHORT = new Opcode<Ins21c>(109, 4, "sput-short", SectionType.FIELD_ID, new Ins21cPutCreator(109));
        values[110] = INVOKE_VIRTUAL = new Opcode<Ins35c>(110, 6, "invoke-virtual", SectionType.METHOD_ID, new Ins35cCreator(110));
        values[111] = INVOKE_SUPER = new Opcode<Ins35c>(111, 6, "invoke-super", SectionType.METHOD_ID, new Ins35cCreator(111));
        values[112] = INVOKE_DIRECT = new Opcode<Ins35c>(112, 6, "invoke-direct", SectionType.METHOD_ID, new Ins35cCreator(112));
        values[113] = INVOKE_STATIC = new Opcode<Ins35c>(113, 6, "invoke-static", SectionType.METHOD_ID, new Ins35cCreator(113));
        values[114] = INVOKE_INTERFACE = new Opcode<Ins35c>(114, 6, "invoke-interface", SectionType.METHOD_ID, new Ins35cCreator(114));
        values[115] = RETURN_VOID_NO_BARRIER = new Opcode<Ins10x>(115, 2, "return-void-no-barrier", new Ins10xCreator(115));
        values[116] = INVOKE_VIRTUAL_RANGE = new Opcode<Ins3rc>(116, 6, "invoke-virtual/range", SectionType.METHOD_ID, new Ins3rcCreator(116));
        values[117] = INVOKE_SUPER_RANGE = new Opcode<Ins3rc>(117, 6, "invoke-super/range", SectionType.METHOD_ID, new Ins3rcCreator(117));
        values[118] = INVOKE_DIRECT_RANGE = new Opcode<Ins3rc>(118, 6, "invoke-direct/range", SectionType.METHOD_ID, new Ins3rcCreator(118));
        values[119] = INVOKE_STATIC_RANGE = new Opcode<Ins3rc>(119, 6, "invoke-static/range", SectionType.METHOD_ID, new Ins3rcCreator(119));
        values[120] = INVOKE_INTERFACE_RANGE = new Opcode<Ins3rc>(120, 6, "invoke-interface/range", SectionType.METHOD_ID, new Ins3rcCreator(120));
        values[123] = NEG_INT = new Opcode<Ins12x>(123, 2, "neg-int", new Ins12xCreator(123));
        values[124] = NOT_INT = new Opcode<Ins12x>(124, 2, "not-int", new Ins12xCreator(124));
        values[125] = NEG_LONG = new Opcode<Ins12x>(125, 2, "neg-long", new Ins12xCreator(125));
        values[126] = NOT_LONG = new Opcode<Ins12x>(126, 2, "not-long", new Ins12xCreator(126));
        values[127] = NEG_FLOAT = new Opcode<Ins12x>(127, 2, "neg-float", new Ins12xCreator(127));
        values[128] = NEG_DOUBLE = new Opcode<Ins12x>(128, 2, "neg-double", new Ins12xCreator(128));
        values[129] = INT_TO_LONG = new Opcode<Ins12x>(129, 2, "int-to-long", new Ins12xCreator(129));
        values[130] = INT_TO_FLOAT = new Opcode<Ins12x>(130, 2, "int-to-float", new Ins12xCreator(130));
        values[131] = INT_TO_DOUBLE = new Opcode<Ins12x>(131, 2, "int-to-double", new Ins12xCreator(131));
        values[132] = LONG_TO_INT = new Opcode<Ins12x>(132, 2, "long-to-int", new Ins12xCreator(132));
        values[133] = LONG_TO_FLOAT = new Opcode<Ins12x>(133, 2, "long-to-float", new Ins12xCreator(133));
        values[134] = LONG_TO_DOUBLE = new Opcode<Ins12x>(134, 2, "long-to-double", new Ins12xCreator(134));
        values[135] = FLOAT_TO_INT = new Opcode<Ins12x>(135, 2, "float-to-int", new Ins12xCreator(135));
        values[136] = FLOAT_TO_LONG = new Opcode<Ins12x>(136, 2, "float-to-long", new Ins12xCreator(136));
        values[137] = FLOAT_TO_DOUBLE = new Opcode<Ins12x>(137, 2, "float-to-double", new Ins12xCreator(137));
        values[138] = DOUBLE_TO_INT = new Opcode<Ins12x>(138, 2, "double-to-int", new Ins12xCreator(138));
        values[139] = DOUBLE_TO_LONG = new Opcode<Ins12x>(139, 2, "double-to-long", new Ins12xCreator(139));
        values[140] = DOUBLE_TO_FLOAT = new Opcode<Ins12x>(140, 2, "double-to-float", new Ins12xCreator(140));
        values[141] = INT_TO_BYTE = new Opcode<Ins12x>(141, 2, "int-to-byte", new Ins12xCreator(141));
        values[142] = INT_TO_CHAR = new Opcode<Ins12x>(142, 2, "int-to-char", new Ins12xCreator(142));
        values[143] = INT_TO_SHORT = new Opcode<Ins12x>(143, 2, "int-to-short", new Ins12xCreator(143));
        values[144] = ADD_INT = new Opcode<Ins23x>(144, 4, "add-int", new Ins23xCreator(144));
        values[145] = SUB_INT = new Opcode<Ins23x>(145, 4, "sub-int", new Ins23xCreator(145));
        values[146] = MUL_INT = new Opcode<Ins23x>(146, 4, "mul-int", new Ins23xCreator(146));
        values[147] = DIV_INT = new Opcode<Ins23x>(147, 4, "div-int", new Ins23xCreator(147));
        values[148] = REM_INT = new Opcode<Ins23x>(148, 4, "rem-int", new Ins23xCreator(148));
        values[149] = AND_INT = new Opcode<Ins23x>(149, 4, "and-int", new Ins23xCreator(149));
        values[150] = OR_INT = new Opcode<Ins23x>(150, 4, "or-int", new Ins23xCreator(150));
        values[151] = XOR_INT = new Opcode<Ins23x>(151, 4, "xor-int", new Ins23xCreator(151));
        values[152] = SHL_INT = new Opcode<Ins23x>(152, 4, "shl-int", new Ins23xCreator(152));
        values[153] = SHR_INT = new Opcode<Ins23x>(153, 4, "shr-int", new Ins23xCreator(153));
        values[154] = USHR_INT = new Opcode<Ins23x>(154, 4, "ushr-int", new Ins23xCreator(154));
        values[155] = ADD_LONG = new Opcode<Ins23x>(155, 4, "add-long", new Ins23xCreator(155));
        values[156] = SUB_LONG = new Opcode<Ins23x>(156, 4, "sub-long", new Ins23xCreator(156));
        values[157] = MUL_LONG = new Opcode<Ins23x>(157, 4, "mul-long", new Ins23xCreator(157));
        values[158] = DIV_LONG = new Opcode<Ins23x>(158, 4, "div-long", new Ins23xCreator(158));
        values[159] = REM_LONG = new Opcode<Ins23x>(159, 4, "rem-long", new Ins23xCreator(159));
        values[160] = AND_LONG = new Opcode<Ins23x>(160, 4, "and-long", new Ins23xCreator(160));
        values[161] = OR_LONG = new Opcode<Ins23x>(161, 4, "or-long", new Ins23xCreator(161));
        values[162] = XOR_LONG = new Opcode<Ins23x>(162, 4, "xor-long", new Ins23xCreator(162));
        values[163] = SHL_LONG = new Opcode<Ins23x>(163, 4, "shl-long", new Ins23xCreator(163));
        values[164] = SHR_LONG = new Opcode<Ins23x>(164, 4, "shr-long", new Ins23xCreator(164));
        values[165] = USHR_LONG = new Opcode<Ins23x>(165, 4, "ushr-long", new Ins23xCreator(165));
        values[166] = ADD_FLOAT = new Opcode<Ins23x>(166, 4, "add-float", new Ins23xCreator(166));
        values[167] = SUB_FLOAT = new Opcode<Ins23x>(167, 4, "sub-float", new Ins23xCreator(167));
        values[168] = MUL_FLOAT = new Opcode<Ins23x>(168, 4, "mul-float", new Ins23xCreator(168));
        values[169] = DIV_FLOAT = new Opcode<Ins23x>(169, 4, "div-float", new Ins23xCreator(169));
        values[170] = REM_FLOAT = new Opcode<Ins23x>(170, 4, "rem-float", new Ins23xCreator(170));
        values[171] = ADD_DOUBLE = new Opcode<Ins23x>(171, 4, "add-double", new Ins23xCreator(171));
        values[172] = SUB_DOUBLE = new Opcode<Ins23x>(172, 4, "sub-double", new Ins23xCreator(172));
        values[173] = MUL_DOUBLE = new Opcode<Ins23x>(173, 4, "mul-double", new Ins23xCreator(173));
        values[174] = DIV_DOUBLE = new Opcode<Ins23x>(174, 4, "div-double", new Ins23xCreator(174));
        values[175] = REM_DOUBLE = new Opcode<Ins23x>(175, 4, "rem-double", new Ins23xCreator(175));
        values[176] = ADD_INT_2ADDR = new Opcode<Ins12x>(176, 2, "add-int/2addr", new Ins12xCreator(176));
        values[177] = SUB_INT_2ADDR = new Opcode<Ins12x>(177, 2, "sub-int/2addr", new Ins12xCreator(177));
        values[178] = MUL_INT_2ADDR = new Opcode<Ins12x>(178, 2, "mul-int/2addr", new Ins12xCreator(178));
        values[179] = DIV_INT_2ADDR = new Opcode<Ins12x>(179, 2, "div-int/2addr", new Ins12xCreator(179));
        values[180] = REM_INT_2ADDR = new Opcode<Ins12x>(180, 2, "rem-int/2addr", new Ins12xCreator(180));
        values[181] = AND_INT_2ADDR = new Opcode<Ins12x>(181, 2, "and-int/2addr", new Ins12xCreator(181));
        values[182] = OR_INT_2ADDR = new Opcode<Ins12x>(182, 2, "or-int/2addr", new Ins12xCreator(182));
        values[183] = XOR_INT_2ADDR = new Opcode<Ins12x>(183, 2, "xor-int/2addr", new Ins12xCreator(183));
        values[184] = SHL_INT_2ADDR = new Opcode<Ins12x>(184, 2, "shl-int/2addr", new Ins12xCreator(184));
        values[185] = SHR_INT_2ADDR = new Opcode<Ins12x>(185, 2, "shr-int/2addr", new Ins12xCreator(185));
        values[186] = USHR_INT_2ADDR = new Opcode<Ins12x>(186, 2, "ushr-int/2addr", new Ins12xCreator(186));
        values[187] = ADD_LONG_2ADDR = new Opcode<Ins12x>(187, 2, "add-long/2addr", new Ins12xCreator(187));
        values[188] = SUB_LONG_2ADDR = new Opcode<Ins12x>(188, 2, "sub-long/2addr", new Ins12xCreator(188));
        values[189] = MUL_LONG_2ADDR = new Opcode<Ins12x>(189, 2, "mul-long/2addr", new Ins12xCreator(189));
        values[190] = DIV_LONG_2ADDR = new Opcode<Ins12x>(190, 2, "div-long/2addr", new Ins12xCreator(190));
        values[191] = REM_LONG_2ADDR = new Opcode<Ins12x>(191, 2, "rem-long/2addr", new Ins12xCreator(191));
        values[192] = AND_LONG_2ADDR = new Opcode<Ins12x>(192, 2, "and-long/2addr", new Ins12xCreator(192));
        values[193] = OR_LONG_2ADDR = new Opcode<Ins12x>(193, 2, "or-long/2addr", new Ins12xCreator(193));
        values[194] = XOR_LONG_2ADDR = new Opcode<Ins12x>(194, 2, "xor-long/2addr", new Ins12xCreator(194));
        values[195] = SHL_LONG_2ADDR = new Opcode<Ins12x>(195, 2, "shl-long/2addr", new Ins12xCreator(195));
        values[196] = SHR_LONG_2ADDR = new Opcode<Ins12x>(196, 2, "shr-long/2addr", new Ins12xCreator(196));
        values[197] = USHR_LONG_2ADDR = new Opcode<Ins12x>(197, 2, "ushr-long/2addr", new Ins12xCreator(197));
        values[198] = ADD_FLOAT_2ADDR = new Opcode<Ins12x>(198, 2, "add-float/2addr", new Ins12xCreator(198));
        values[199] = SUB_FLOAT_2ADDR = new Opcode<Ins12x>(199, 2, "sub-float/2addr", new Ins12xCreator(199));
        values[200] = MUL_FLOAT_2ADDR = new Opcode<Ins12x>(200, 2, "mul-float/2addr", new Ins12xCreator(200));
        values[201] = DIV_FLOAT_2ADDR = new Opcode<Ins12x>(201, 2, "div-float/2addr", new Ins12xCreator(201));
        values[202] = REM_FLOAT_2ADDR = new Opcode<Ins12x>(202, 2, "rem-float/2addr", new Ins12xCreator(202));
        values[203] = ADD_DOUBLE_2ADDR = new Opcode<Ins12x>(203, 2, "add-double/2addr", new Ins12xCreator(203));
        values[204] = SUB_DOUBLE_2ADDR = new Opcode<Ins12x>(204, 2, "sub-double/2addr", new Ins12xCreator(204));
        values[205] = MUL_DOUBLE_2ADDR = new Opcode<Ins12x>(205, 2, "mul-double/2addr", new Ins12xCreator(205));
        values[206] = DIV_DOUBLE_2ADDR = new Opcode<Ins12x>(206, 2, "div-double/2addr", new Ins12xCreator(206));
        values[207] = REM_DOUBLE_2ADDR = new Opcode<Ins12x>(207, 2, "rem-double/2addr", new Ins12xCreator(207));
        values[208] = ADD_INT_LIT16 = new Opcode<Ins22s>(208, 4, "add-int/lit16", new Ins22sCreator(208));
        values[209] = RSUB_INT = new Opcode<Ins22s>(209, 4, "rsub-int", new Ins22sCreator(209));
        values[210] = MUL_INT_LIT16 = new Opcode<Ins22s>(210, 4, "mul-int/lit16", new Ins22sCreator(210));
        values[211] = DIV_INT_LIT16 = new Opcode<Ins22s>(211, 4, "div-int/lit16", new Ins22sCreator(211));
        values[212] = REM_INT_LIT16 = new Opcode<Ins22s>(212, 4, "rem-int/lit16", new Ins22sCreator(212));
        values[213] = AND_INT_LIT16 = new Opcode<Ins22s>(213, 4, "and-int/lit16", new Ins22sCreator(213));
        values[214] = OR_INT_LIT16 = new Opcode<Ins22s>(214, 4, "or-int/lit16", new Ins22sCreator(214));
        values[215] = XOR_INT_LIT16 = new Opcode<Ins22s>(215, 4, "xor-int/lit16", new Ins22sCreator(215));
        values[216] = ADD_INT_LIT8 = new Opcode<Ins22b>(216, 4, "add-int/lit8", new Ins22bCreator(216));
        values[217] = RSUB_INT_LIT8 = new Opcode<Ins22b>(217, 4, "rsub-int/lit8", new Ins22bCreator(217));
        values[218] = MUL_INT_LIT8 = new Opcode<Ins22b>(218, 4, "mul-int/lit8", new Ins22bCreator(218));
        values[219] = DIV_INT_LIT8 = new Opcode<Ins22b>(219, 4, "div-int/lit8", new Ins22bCreator(219));
        values[220] = REM_INT_LIT8 = new Opcode<Ins22b>(220, 4, "rem-int/lit8", new Ins22bCreator(220));
        values[221] = AND_INT_LIT8 = new Opcode<Ins22b>(221, 4, "and-int/lit8", new Ins22bCreator(221));
        values[222] = OR_INT_LIT8 = new Opcode<Ins22b>(222, 4, "or-int/lit8", new Ins22bCreator(222));
        values[223] = XOR_INT_LIT8 = new Opcode<Ins22b>(223, 4, "xor-int/lit8", new Ins22bCreator(223));
        values[224] = SHL_INT_LIT8 = new Opcode<Ins22b>(224, 4, "shl-int/lit8", new Ins22bCreator(224));
        values[225] = SHR_INT_LIT8 = new Opcode<Ins22b>(225, 4, "shr-int/lit8", new Ins22bCreator(225));
        values[226] = USHR_INT_LIT8 = new Opcode<Ins22b>(226, 4, "ushr-int/lit8", new Ins22bCreator(226));
        values[227] = IGET_VOLATILE = new Opcode<Ins22c>(227, 4, "iget-volatile", SectionType.FIELD_ID, new Ins22cCreator(227));
        values[228] = IPUT_VOLATILE = new Opcode<Ins22c>(228, 4, "iput-volatile", SectionType.FIELD_ID, new Ins22cPutCreator(228));
        values[229] = SGET_VOLATILE = new Opcode<Ins21c>(229, 4, "sget-volatile", SectionType.FIELD_ID, new Ins21cCreator(229));
        values[230] = SPUT_VOLATILE = new Opcode<Ins21c>(230, 4, "sput-volatile", SectionType.FIELD_ID, new Ins21cPutCreator(230));
        values[231] = IGET_OBJECT_VOLATILE = new Opcode<Ins22c>(231, 4, "iget-object-volatile", SectionType.FIELD_ID, new Ins22cCreator(231));
        values[232] = IGET_WIDE_VOLATILE = new Opcode<Ins22c>(232, 4, "iget-wide-volatile", SectionType.FIELD_ID, new Ins22cCreator(232));
        values[233] = IPUT_WIDE_VOLATILE = new Opcode<Ins22c>(233, 4, "iput-wide-volatile", SectionType.FIELD_ID, new Ins22cPutCreator(233));
        values[234] = SGET_WIDE_VOLATILE = new Opcode<Ins21c>(234, 4, "sget-wide-volatile", SectionType.FIELD_ID, new Ins21cCreator(234));
        values[235] = SPUT_WIDE_VOLATILE = new Opcode<Ins21c>(235, 4, "sput-wide-volatile", SectionType.FIELD_ID, new Ins21cPutCreator(235));
        values[236] = IPUT_BYTE_QUICK = new Opcode<Ins22cs>(236, 4, "iput-byte-quick", SectionType.FIELD_ID, new Ins22csPutCreator(236));
        values[237] = THROW_VERIFICATION_ERROR = new Opcode<Ins20bc>(237, 4, "throw-verification-error", new Ins20bcCreator(237));
        values[238] = EXECUTE_INLINE = new Opcode<Ins35mi>(238, 6, "execute-inline", new Ins35miCreator(238));
        values[239] = EXECUTE_INLINE_RANGE = new Opcode<Ins3rmi>(239, 6, "execute-inline/range", new Ins3rmiCreator(239));
        values[240] = INVOKE_DIRECT_EMPTY = new Opcode<Ins35c>(240, 6, "invoke-direct-empty", SectionType.METHOD_ID, new Ins35cCreator(240));
        values[241] = RETURN_VOID_BARRIER = new Opcode<Ins10x>(241, 2, "return-void-barrier", new Ins10xCreator(241));
        values[242] = IGET_QUICK = new Opcode<Ins22cs>(242, 4, "iget-quick", SectionType.FIELD_ID, new Ins22csCreator(242));
        values[243] = IGET_WIDE_QUICK = new Opcode<Ins22cs>(243, 4, "iget-wide-quick", SectionType.FIELD_ID, new Ins22csCreator(243));
        values[244] = IGET_OBJECT_QUICK = new Opcode<Ins22cs>(244, 4, "iget-object-quick", SectionType.FIELD_ID, new Ins22csCreator(244));
        values[245] = IPUT_QUICK = new Opcode<Ins22cs>(245, 4, "iput-quick", SectionType.FIELD_ID, new Ins22csPutCreator(245));
        values[246] = IPUT_WIDE_QUICK = new Opcode<Ins22cs>(246, 4, "iput-wide-quick", SectionType.FIELD_ID, new Ins22csPutCreator(246));
        values[247] = IPUT_OBJECT_QUICK = new Opcode<Ins22cs>(247, 4, "iput-object-quick", SectionType.FIELD_ID, new Ins22csPutCreator(247));
        values[248] = INVOKE_VIRTUAL_QUICK = new Opcode<Ins35ms>(248, 6, "invoke-virtual-quick", SectionType.METHOD_ID, new Ins35msCreator(248));
        values[249] = INVOKE_VIRTUAL_QUICK_RANGE = new Opcode<Ins3rms>(249, 6, "invoke-virtual-quick/range", SectionType.METHOD_ID, new Ins3rmsCreator(249));
        values[250] = INVOKE_SUPER_QUICK = new Opcode<Ins35ms>(250, 6, "invoke-super-quick", SectionType.METHOD_ID, new Ins35msCreator(250));
        values[251] = INVOKE_SUPER_QUICK_RANGE = new Opcode<Ins3rms>(251, 6, "invoke-super-quick/range", SectionType.METHOD_ID, new Ins3rmsCreator(251));
        values[252] = IPUT_OBJECT_VOLATILE = new Opcode<Ins22c>(252, 4, "iput-object-volatile", SectionType.FIELD_ID, new Ins22cCreator(252));
        values[253] = SGET_OBJECT_VOLATILE = new Opcode<Ins21c>(253, 4, "sget-object-volatile", SectionType.FIELD_ID, new Ins21cCreator(253));
        values[254] = SPUT_OBJECT_VOLATILE = new Opcode<Ins21c>(254, 4, "sput-object-volatile", SectionType.FIELD_ID, new Ins21cPutCreator(254));
        values[255] = CONST_METHOD_TYPE = new Opcode<Ins21c>(255, 4, "const-method-type", SectionType.METHOD_ID, new Ins21cCreator(255));
        PACKED_SWITCH_PAYLOAD = new Opcode<InsPackedSwitchData>(256, -1, "packed-switch-payload", new InsPackedSwitchDataCreator(256));
        Opcode.PAYLOADS[0] = PACKED_SWITCH_PAYLOAD;
        SPARSE_SWITCH_PAYLOAD = new Opcode<InsSparseSwitchData>(512, -1, "sparse-switch-payload", new InsSparseSwitchDataCreator(512));
        Opcode.PAYLOADS[1] = SPARSE_SWITCH_PAYLOAD;
        ARRAY_PAYLOAD = new Opcode<InsArrayData>(768, -1, "array-data", new InsArrayDataCreator(768));
        Opcode.PAYLOADS[2] = ARRAY_PAYLOAD;
        IPUT_BOOLEAN_QUICK = new Opcode<Ins22cs>(235, 4, "iput-boolean-quick", SectionType.FIELD_ID, new Ins22csPutCreator(235));
        Opcode.VALUES_2[0] = IPUT_BOOLEAN_QUICK;
        IPUT_CHAR_QUICK = new Opcode<Ins22cs>(237, 4, "iput-char-quick", SectionType.FIELD_ID, new Ins22csPutCreator(237));
        Opcode.VALUES_2[1] = IPUT_CHAR_QUICK;
        IPUT_SHORT_QUICK = new Opcode<Ins22cs>(238, 4, "iput-short-quick", SectionType.FIELD_ID, new Ins22csPutCreator(238));
        Opcode.VALUES_2[2] = IPUT_SHORT_QUICK;
        IGET_BOOLEAN_QUICK = new Opcode<Ins22cs>(239, 4, "iget-boolean-quick", SectionType.FIELD_ID, new Ins22csCreator(239));
        Opcode.VALUES_2[3] = IGET_BOOLEAN_QUICK;
        INVOKE_OBJECT_INIT_RANGE = new Opcode<Ins3rc>(240, 6, "invoke-object-init/range", SectionType.METHOD_ID, new Ins3rcCreator(240));
        Opcode.VALUES_2[4] = INVOKE_OBJECT_INIT_RANGE;
        IGET_CHAR_QUICK = new Opcode<Ins22cs>(241, 4, "iget-char-quick", SectionType.FIELD_ID, new Ins22csCreator(241));
        Opcode.VALUES_2[5] = IGET_CHAR_QUICK;
        IGET_SHORT_QUICK = new Opcode<Ins22cs>(242, 4, "iget-short-quick", SectionType.FIELD_ID, new Ins22csCreator(242));
        Opcode.VALUES_2[6] = IGET_SHORT_QUICK;
        INVOKE_POLYMORPHIC = new Opcode<Ins45cc>(250, 8, "invoke-polymorphic", SectionType.METHOD_ID, new Ins45ccCreator(250));
        Opcode.VALUES_2[7] = INVOKE_POLYMORPHIC;
        INVOKE_POLYMORPHIC_RANGE = new Opcode<Ins4rcc>(251, 8, "invoke-polymorphic/range", SectionType.METHOD_ID, new Ins4rccCreator(251));
        Opcode.VALUES_2[8] = INVOKE_POLYMORPHIC_RANGE;
        INVOKE_CUSTOM = new Opcode<Ins35c>(252, 6, "invoke-custom", SectionType.METHOD_ID, new Ins35cCreator(252));
        Opcode.VALUES_2[9] = INVOKE_CUSTOM;
        INVOKE_CUSTOM_RANGE = new Opcode<Ins3rc>(253, 6, "invoke-custom/range", SectionType.METHOD_ID, new Ins3rcCreator(253));
        Opcode.VALUES_2[10] = INVOKE_CUSTOM_RANGE;
        CONST_METHOD_HANDLE = new Opcode<Ins21c>(254, 4, "const-method-handle", SectionType.METHOD_HANDLE, new Ins21cCreator(254));
        Opcode.VALUES_2[11] = CONST_METHOD_HANDLE;
        IGET_BYTE_QUICK = new Opcode<Ins22cs>(240, 4, "iget-byte-quick", SectionType.FIELD_ID, new Ins22csCreator(240));
        Opcode.VALUES_3[0] = IGET_BYTE_QUICK;
        for (Opcode opcode : values) {
            if (opcode == null) continue;
            map.put(opcode.name, opcode);
        }
        for (Opcode opcode : PAYLOADS) {
            map.put(opcode.name, opcode);
        }
        for (Opcode opcode : VALUES_2) {
            map.put(opcode.name, opcode);
        }
        for (Opcode opcode : VALUES_3) {
            map.put(opcode.name, opcode);
        }
    }

    static class InsSparseSwitchDataCreator
    extends InsCreator<InsSparseSwitchData> {
        InsSparseSwitchDataCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public InsSparseSwitchData newInstance() {
            return new InsSparseSwitchData();
        }
    }

    static class InsSparseSwitchCreator
    extends InsCreator<InsSparseSwitch> {
        InsSparseSwitchCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public InsSparseSwitch newInstance() {
            return new InsSparseSwitch();
        }
    }

    static class InsPackedSwitchDataCreator
    extends InsCreator<InsPackedSwitchData> {
        InsPackedSwitchDataCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsPackedSwitchData newInstance() {
            return new InsPackedSwitchData();
        }
    }

    static class InsPackedSwitchCreator
    extends InsCreator<InsPackedSwitch> {
        InsPackedSwitchCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public InsPackedSwitch newInstance() {
            return new InsPackedSwitch();
        }
    }

    static class InsNopCreator
    extends InsCreator<InsNop> {
        InsNopCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public InsNop newInstance() {
            return new InsNop();
        }
    }

    static class InsGotoCreator
    extends InsCreator<InsGoto> {
        InsGotoCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public InsGoto newInstance() {
            return new InsGoto(this.getOpcode());
        }
    }

    static class InsFillArrayDataCreator
    extends InsCreator<InsFillArrayData> {
        InsFillArrayDataCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public InsFillArrayData newInstance() {
            return new InsFillArrayData();
        }
    }

    static class InsConstWideCreator
    extends InsCreator<InsConstWide> {
        InsConstWideCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConstWide newInstance() {
            return new InsConstWide();
        }
    }

    static class InsConstStringJumboCreator
    extends InsCreator<InsConstStringJumbo> {
        InsConstStringJumboCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public InsConstStringJumbo newInstance() {
            return new InsConstStringJumbo();
        }
    }

    static class InsConstStringCreator
    extends InsCreator<InsConstString> {
        InsConstStringCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public InsConstString newInstance() {
            return new InsConstString();
        }
    }

    static class InsConstCreator
    extends InsCreator<InsConst> {
        InsConstCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConst newInstance() {
            return new InsConst();
        }
    }

    static class InsConst4Creator
    extends InsCreator<InsConst4> {
        InsConst4Creator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConst4 newInstance() {
            return new InsConst4();
        }
    }

    static class InsConst16HighCreator
    extends InsCreator<InsConst16High> {
        InsConst16HighCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConst16High newInstance() {
            return new InsConst16High();
        }
    }

    static class InsArrayDataCreator
    extends InsCreator<InsArrayData> {
        InsArrayDataCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.DECIMAL;
        }

        @Override
        public InsArrayData newInstance() {
            return new InsArrayData();
        }
    }

    static class Ins4rccCreator
    extends InsCreator<Ins4rcc> {
        Ins4rccCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT_RANGE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins4rcc newInstance() {
            return new Ins4rcc(this.getOpcode());
        }
    }

    static class Ins45ccCreator
    extends InsCreator<Ins45cc> {
        Ins45ccCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins45cc newInstance() {
            return new Ins45cc(this.getOpcode());
        }
    }

    static class Ins3rmsCreator
    extends InsCreator<Ins3rms> {
        Ins3rmsCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT_RANGE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins3rms newInstance() {
            return new Ins3rms(this.getOpcode());
        }
    }

    static class Ins3rmiCreator
    extends InsCreator<Ins3rmi> {
        Ins3rmiCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins3rmi newInstance() {
            return new Ins3rmi(this.getOpcode());
        }
    }

    static class Ins3rcCreator
    extends InsCreator<Ins3rc> {
        Ins3rcCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT_RANGE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins3rc newInstance() {
            return new Ins3rc(this.getOpcode());
        }
    }

    static class Ins35msCreator
    extends InsCreator<Ins35ms> {
        Ins35msCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins35ms newInstance() {
            return new Ins35ms(this.getOpcode());
        }
    }

    static class Ins35miCreator
    extends InsCreator<Ins35mi> {
        Ins35miCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins35mi newInstance() {
            return new Ins35mi(this.getOpcode());
        }
    }

    static class Ins35cCreator
    extends InsCreator<Ins35c> {
        Ins35cCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.OUT;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins35c newInstance() {
            return new Ins35c(this.getOpcode());
        }
    }

    static class Ins32xCreator
    extends InsCreator<Ins32x> {
        Ins32xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins32x newInstance() {
            return new Ins32x(this.getOpcode());
        }
    }

    static class InsConstWide32Creator
    extends InsCreator<InsConstWide32> {
        InsConstWide32Creator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConstWide32 newInstance() {
            return new InsConstWide32();
        }

        @Override
        Opcode<InsConstWide32> getOpcode() {
            return CONST_WIDE_32;
        }
    }

    static class Ins31iCreator
    extends InsCreator<Ins31i> {
        Ins31iCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public Ins31i newInstance() {
            return new Ins31i(this.getOpcode());
        }
    }

    static class Ins23xAputCreator
    extends Ins23xCreator {
        Ins23xAputCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ_READ_READ;
        }
    }

    static class Ins23xCreator
    extends InsCreator<Ins23x> {
        Ins23xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins23x newInstance() {
            return new Ins23x(this.getOpcode());
        }
    }

    static class Ins22xCreator
    extends InsCreator<Ins22x> {
        Ins22xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins22x newInstance() {
            return new Ins22x(this.getOpcode());
        }
    }

    static class Ins22tCreator
    extends InsCreator<Ins22t> {
        Ins22tCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public Ins22t newInstance() {
            return new Ins22t(this.getOpcode());
        }
    }

    static class Ins22sCreator
    extends InsCreator<Ins22s> {
        Ins22sCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public Ins22s newInstance() {
            return new Ins22s(this.getOpcode());
        }
    }

    static class Ins22csPutCreator
    extends Ins22csCreator {
        Ins22csPutCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ_READ;
        }
    }

    static class Ins22csCreator
    extends InsCreator<Ins22cs> {
        Ins22csCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins22cs newInstance() {
            return new Ins22cs(this.getOpcode());
        }
    }

    static class Ins22cPutCreator
    extends Ins22cCreator {
        Ins22cPutCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }
    }

    static class Ins22cCreator
    extends InsCreator<Ins22c> {
        Ins22cCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins22c newInstance() {
            return new Ins22c(this.getOpcode());
        }
    }

    static class Ins22bCreator
    extends InsCreator<Ins22b> {
        Ins22bCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public Ins22b newInstance() {
            return new Ins22b(this.getOpcode());
        }
    }

    static class Ins21tCreator
    extends InsCreator<Ins21t> {
        Ins21tCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.LABEL;
        }

        @Override
        public Ins21t newInstance() {
            return new Ins21t(this.getOpcode());
        }
    }

    static class InsConst16Creator
    extends InsCreator<InsConst16> {
        InsConst16Creator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConst16 newInstance() {
            return new InsConst16();
        }

        @Override
        Opcode<InsConst16> getOpcode() {
            return CONST_16;
        }
    }

    static class InsConstWide16Creator
    extends InsCreator<InsConstWide16> {
        InsConstWide16Creator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConstWide16 newInstance() {
            return new InsConstWide16();
        }

        @Override
        Opcode<?> getOpcode() {
            return CONST_WIDE_16;
        }
    }

    static class Ins21sCreator
    extends InsCreator<Ins21s> {
        Ins21sCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public Ins21s newInstance() {
            return new Ins21s(this.getOpcode());
        }
    }

    static class InsConstWideHigh16Creator
    extends InsCreator<InsConstWideHigh16> {
        InsConstWideHigh16Creator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.HEX;
        }

        @Override
        public InsConstWideHigh16 newInstance() {
            return new InsConstWideHigh16();
        }

        @Override
        Opcode<InsConstWideHigh16> getOpcode() {
            return CONST_WIDE_HIGH16;
        }
    }

    static class Ins21cPutCreator
    extends Ins21cCreator {
        Ins21cPutCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }
    }

    static class Ins21cCreator
    extends InsCreator<Ins21c> {
        Ins21cCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.KEY;
        }

        @Override
        public Ins21c newInstance() {
            return new Ins21c(this.getOpcode());
        }
    }

    static class Ins20bcCreator
    extends InsCreator<Ins20bc> {
        Ins20bcCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins20bc newInstance() {
            return new Ins20bc(this.getOpcode());
        }
    }

    static class Ins12xCreator
    extends InsCreator<Ins12x> {
        Ins12xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE_READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins12x newInstance() {
            return new Ins12x(this.getOpcode());
        }
    }

    static class Ins11xWriteCreator
    extends Ins11xCreator {
        Ins11xWriteCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.WRITE;
        }
    }

    static class Ins11xCreator
    extends InsCreator<Ins11x> {
        Ins11xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.READ;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins11x newInstance() {
            return new Ins11x(this.getOpcode());
        }
    }

    static class Ins10xCreator
    extends InsCreator<Ins10x> {
        Ins10xCreator(int opcodeValue) {
            super(opcodeValue);
        }

        @Override
        public RegisterFormat getRegisterFormat() {
            return RegisterFormat.NONE;
        }

        @Override
        public OperandType getOperandType() {
            return OperandType.NONE;
        }

        @Override
        public Ins10x newInstance() {
            return new Ins10x(this.getOpcode());
        }
    }

    static abstract class InsCreator<T extends Ins>
    implements BlockCreator<T> {
        private final int opcodeValue;
        private Opcode<?> opcode;

        InsCreator(int opcodeValue) {
            this.opcodeValue = opcodeValue;
        }

        Opcode<?> getOpcode() {
            if (this.opcode == null) {
                this.opcode = Opcode.valueOf(this.opcodeValue);
            }
            return this.opcode;
        }

        public abstract RegisterFormat getRegisterFormat();

        public abstract OperandType getOperandType();
    }
}

