/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerArrayBlock;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliPayloadSparseSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliSparseSwitchEntry;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class InsSparseSwitchData
extends PayloadData
implements BlockLoad,
ArraySupplier<Data>,
LabelsSet,
SmaliFormat {
    private final ShortItem elementCount = new ShortItem();
    final IntegerArrayBlock elements = new IntegerArrayBlock();
    final IntegerArrayBlock keys = new IntegerArrayBlock();
    private InsSparseSwitch insSparseSwitch;

    public InsSparseSwitchData() {
        super(3, Opcode.SPARSE_SWITCH_PAYLOAD);
        this.addChild(1, this.elementCount);
        this.addChild(2, this.elements);
        this.addChild(3, this.keys);
        this.elementCount.setBlockLoad(this);
    }

    @Override
    public int getCount() {
        return this.keys.size();
    }

    public void setCount(int count) {
        this.elements.setSize(count);
        this.keys.setSize(count);
        this.elementCount.set(count);
    }

    @Override
    public Data get(int i) {
        if (i < 0 || i >= this.getCount()) {
            return null;
        }
        return new Data(this, i);
    }

    public Iterator<Data> getLabels() {
        return new ArraySupplierIterator<Data>(this);
    }

    public int getBaseAddress() {
        InsSparseSwitch sparseSwitch = this.getParentSparseSwitch();
        if (sparseSwitch == null) {
            return 0;
        }
        return sparseSwitch.getAddress();
    }

    public InsSparseSwitch getParentSparseSwitch() {
        InsSparseSwitch sparseSwitch = this.insSparseSwitch;
        if (sparseSwitch == null) {
            sparseSwitch = this.findOnExtraLines();
            if (sparseSwitch == null) {
                sparseSwitch = this.findByAddress();
            }
            this.insSparseSwitch = sparseSwitch;
        }
        return this.insSparseSwitch;
    }

    private InsSparseSwitch findOnExtraLines() {
        Iterator<ExtraLine> iterator = this.getExtraLines();
        while (iterator.hasNext()) {
            ExtraLine extraLine = iterator.next();
            if (!(extraLine instanceof InsSparseSwitch)) continue;
            return (InsSparseSwitch)extraLine;
        }
        return null;
    }

    private InsSparseSwitch findByAddress() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            Iterator<InsSparseSwitch> iterator = instructionList.iterator(Opcode.SPARSE_SWITCH);
            int address = this.getAddress();
            while (iterator.hasNext()) {
                InsSparseSwitch sparseSwitch = iterator.next();
                if (sparseSwitch.getTargetAddress() != address) continue;
                return sparseSwitch;
            }
        }
        return null;
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.elementCount) {
            this.keys.setSize(this.elementCount.get());
            this.elements.setSize(this.elementCount.get());
        }
    }

    @Override
    public void merge(Ins ins) {
        int i;
        InsSparseSwitchData switchData = (InsSparseSwitchData)ins;
        int size = switchData.elements.size();
        this.elements.setSize(size);
        for (i = 0; i < size; ++i) {
            this.elements.put(i, switchData.elements.get(i));
        }
        size = switchData.keys.size();
        this.keys.setSize(size);
        for (i = 0; i < size; ++i) {
            this.keys.put(i, switchData.keys.get(i));
        }
        this.elementCount.set(switchData.elementCount.get());
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) throws IOException {
        SmaliPayloadSparseSwitch smaliPayloadSparseSwitch = (SmaliPayloadSparseSwitch)smaliInstruction;
        SmaliSet entries = smaliPayloadSparseSwitch.getEntries();
        int count = entries.size();
        this.setCount(count);
        for (int i = 0; i < count; ++i) {
            SmaliSparseSwitchEntry smaliEntry = (SmaliSparseSwitchEntry)entries.get(i);
            Data data = this.get(i);
            data.fromSmali(smaliEntry);
        }
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        writer.newLine();
        this.getSmaliDirective().append(writer);
        int size = this.getCount();
        writer.indentPlus();
        for (int i = 0; i < size; ++i) {
            this.get(i).append(writer);
        }
        writer.indentMinus();
        writer.newLine();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.SPARSE_SWITCH;
    }

    public static class Data
    implements IntegerReference,
    Label,
    SmaliFormat {
        private final InsSparseSwitchData switchData;
        private final int index;

        Data(InsSparseSwitchData switchData, int index) {
            this.switchData = switchData;
            this.index = index;
        }

        public int getKey() {
            return this.switchData.keys.get(this.index);
        }

        public void setKey(int value) {
            this.switchData.keys.put(this.index, value);
        }

        @Override
        public int get() {
            return this.switchData.elements.get(this.index);
        }

        @Override
        public void set(int value) {
            this.switchData.elements.put(this.index, value);
        }

        @Override
        public int getSortOrder() {
            return 5;
        }

        @Override
        public int getAddress() {
            return this.switchData.getAddress();
        }

        @Override
        public int getTargetAddress() {
            return this.getKey() + this.switchData.getBaseAddress();
        }

        @Override
        public void setTargetAddress(int targetAddress) {
            this.setKey(targetAddress - this.switchData.getBaseAddress());
        }

        @Override
        public String getLabelName() {
            return HexUtil.toHex(":sswitch_", this.getTargetAddress(), 1);
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.newLine();
            writer.appendHex(this.get());
            writer.append(" -> ");
            writer.append(this.getLabelName());
        }

        public void fromSmali(SmaliSparseSwitchEntry smaliEntry) throws IOException {
            this.set(smaliEntry.getIntegerValue());
            this.setTargetAddress(smaliEntry.getLabel().getIntegerData());
        }

        public int hashCode() {
            return Objects.hash(this.switchData, this.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Data data = (Data)obj;
            return this.index == data.index && this.switchData == data.switchData;
        }

        public String toString() {
            return HexUtil.toHex8(this.get());
        }
    }
}

