/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.util.Iterator;

public class InsPackedSwitchData
extends PayloadData
implements LabelsSet,
SmaliRegion {
    private final ShortItem elementCount = new ShortItem();
    private final IntegerItem firstKey = new IntegerItem();
    private final PackedSwitchDataList elements = new PackedSwitchDataList(this, this.elementCount, this.firstKey);
    private InsPackedSwitch insPackedSwitch;

    public InsPackedSwitchData() {
        super(3, Opcode.PACKED_SWITCH_PAYLOAD);
        this.addChild(1, this.elementCount);
        this.addChild(2, this.firstKey);
        this.addChild(3, this.elements);
    }

    public int getFirstKey() {
        return this.firstKey.get();
    }

    public void setFirstKey(int firstKey) {
        this.firstKey.set(firstKey);
    }

    public InsPackedSwitch getParentPackedSwitch() {
        InsPackedSwitch packedSwitch = this.insPackedSwitch;
        if (packedSwitch == null) {
            packedSwitch = this.findOnExtraLines();
            if (packedSwitch == null) {
                packedSwitch = this.findByAddress();
            }
            this.insPackedSwitch = packedSwitch;
        }
        return this.insPackedSwitch;
    }

    private InsPackedSwitch findOnExtraLines() {
        Iterator<ExtraLine> iterator = this.getExtraLines();
        while (iterator.hasNext()) {
            ExtraLine extraLine = iterator.next();
            if (!(extraLine instanceof InsPackedSwitch)) continue;
            return (InsPackedSwitch)extraLine;
        }
        return null;
    }

    private InsPackedSwitch findByAddress() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            Iterator<InsPackedSwitch> iterator = instructionList.iterator(Opcode.PACKED_SWITCH);
            int address = this.getAddress();
            while (iterator.hasNext()) {
                InsPackedSwitch packedSwitch = iterator.next();
                if (packedSwitch.getTargetAddress() != address) continue;
                return packedSwitch;
            }
        }
        return null;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PACKED_SWITCH;
    }

    public Iterator<PackedSwitchDataList.Data> getLabels() {
        return this.elements.getLabels();
    }

    @Override
    public void merge(Ins ins) {
        InsPackedSwitchData switchData = (InsPackedSwitchData)ins;
        this.elements.merge(switchData.elements);
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        SmaliPayloadPackedSwitch smaliPayloadPackedSwitch = (SmaliPayloadPackedSwitch)smaliInstruction;
        this.setFirstKey(smaliPayloadPackedSwitch.getFirstKey());
        SmaliSet entries = smaliPayloadPackedSwitch.getEntries();
        int size = entries.size();
        PackedSwitchDataList dataList = this.elements;
        dataList.setSize(size);
        for (int i = 0; i < size; ++i) {
            SmaliLabel smaliLabel = (SmaliLabel)entries.get(i);
            PackedSwitchDataList.Data data = dataList.getData(i);
            data.setTargetAddress(smaliLabel.getAddress());
        }
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.append(HexUtil.toHex(this.firstKey.get(), 1));
        writer.indentPlus();
        this.elements.append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public String toString() {
        return "InsPackedSwitchData{elementCount=" + this.elementCount + ", firstKey=" + this.firstKey + ", elements=" + this.elements + '}';
    }
}

