/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class InsGoto
extends SizeXIns
implements Label {
    public InsGoto(Opcode<?> opcode) {
        super(opcode);
    }

    @Override
    public int getData() {
        int size = this.getOpcode().size();
        if (size == 2) {
            return this.getByteSigned();
        }
        if (size == 4) {
            return this.getShortSigned();
        }
        return this.getInteger();
    }

    @Override
    public void setData(int data) {
        int size = this.getOpcode().size();
        if (size == 2) {
            this.setByte(1, data);
        }
        if (size == 4) {
            this.setShort(2, data);
        }
        this.setInteger(data);
    }

    @Override
    public int getTargetAddress() {
        return this.getAddress() + this.getData();
    }

    @Override
    public void setTargetAddress(int targetAddress) {
        this.setData(targetAddress - this.getAddress());
    }

    @Override
    public String getLabelName() {
        return HexUtil.toHex(":goto_", this.getTargetAddress(), 1);
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        writer.newLine();
        writer.append(this.getOpcode().getName());
        writer.append(' ');
        writer.append(this.getLabelName());
    }

    @Override
    public int getSortOrder() {
        return 5;
    }
}

