/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.base.DexBlockAlign;
import com.reandroid.dex.base.NumberArray;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsFillArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliValidateException;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public class InsArrayData
extends PayloadData
implements SmaliRegion {
    private final NumberArray numberArray;
    private final DexBlockAlign blockAlign;

    public InsArrayData() {
        super(4, Opcode.ARRAY_PAYLOAD);
        ShortItem elementWidth = new ShortItem();
        IntegerItem elementCount = new IntegerItem();
        this.numberArray = new NumberArray(elementWidth, elementCount);
        this.blockAlign = new DexBlockAlign(this.numberArray);
        this.blockAlign.setAlignment(2);
        this.addChild(1, elementWidth);
        this.addChild(2, elementCount);
        this.addChild(3, this.numberArray);
        this.addChild(4, this.blockAlign);
    }

    public Iterator<InsFillArrayData> getInsFillArrayData() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return EmptyIterator.of();
        }
        instructionList.buildExtraLines();
        return InstanceIterator.of(this.getExtraLines(), InsFillArrayData.class);
    }

    public int size() {
        return this.getNumberArray().size();
    }

    public void setSize(int size) {
        this.getNumberArray().setSize(size);
        this.refreshAlignment();
    }

    public int getWidth() {
        return this.getNumberArray().getWidth();
    }

    public void setWidth(int width) {
        this.getNumberArray().setWidth(width);
        this.refreshAlignment();
    }

    public void set(byte[] values) {
        NumberArray numberArray = this.getNumberArray();
        numberArray.setSize(0);
        numberArray.setWidth(1);
        numberArray.put(values);
        this.refreshAlignment();
    }

    public void set(short[] values) {
        NumberArray numberArray = this.getNumberArray();
        numberArray.setSize(0);
        numberArray.setWidth(2);
        numberArray.put(values);
        this.refreshAlignment();
    }

    public void set(int[] values) {
        NumberArray numberArray = this.getNumberArray();
        numberArray.setSize(0);
        numberArray.put(values);
        this.refreshAlignment();
    }

    public void set(long[] values) {
        NumberArray numberArray = this.getNumberArray();
        numberArray.setSize(0);
        numberArray.setWidth(8);
        numberArray.putLong(values);
        this.refreshAlignment();
    }

    public Iterator<IntegerReference> getReferences() {
        return this.getNumberArray().getReferences();
    }

    public IntegerReference getReference(int i) {
        return this.getNumberArray().getReference(i);
    }

    public int getAsInteger(int index) {
        return this.getNumberArray().getAsInteger(index);
    }

    public long getLong(int index) {
        return this.getNumberArray().getLong(index);
    }

    public void put(int index, int value) {
        this.getNumberArray().put(index, value);
    }

    public void putLong(int index, long value) {
        this.getNumberArray().putLong(index, value);
    }

    public NumberArray getNumberArray() {
        return this.numberArray;
    }

    public void refreshAlignment() {
        this.blockAlign.align(this);
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.appendInteger(this.getWidth());
        writer.indentPlus();
        this.appendData(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    private void appendData(SmaliWriter writer) throws IOException {
        NumberArray numberArray = this.getNumberArray();
        int width = numberArray.getWidth();
        int size = numberArray.size();
        if (width < 2) {
            for (int i = 0; i < size; ++i) {
                writer.newLine();
                writer.appendHex(numberArray.getByte(i));
            }
        } else if (width < 4) {
            for (int i = 0; i < size; ++i) {
                writer.newLine();
                writer.appendHex(numberArray.getShort(i));
            }
        } else if (width == 4) {
            for (int i = 0; i < size; ++i) {
                writer.newLine();
                writer.appendHex(numberArray.getInteger(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                writer.newLine();
                writer.appendHex(numberArray.getLong(i));
            }
        }
    }

    @Override
    public void merge(Ins ins) {
        InsArrayData coming = (InsArrayData)ins;
        this.getNumberArray().merge(coming.getNumberArray());
        this.refreshAlignment();
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) throws IOException {
        SmaliPayloadArray smaliPayloadArray = (SmaliPayloadArray)smaliInstruction;
        int width = smaliPayloadArray.getWidth();
        if (width < 1 || width > 8) {
            throw new SmaliValidateException("Array values width out of range '" + width + "'", smaliInstruction);
        }
        this.setWidth(width);
        if (width > 4) {
            this.set(smaliPayloadArray.unsignedLong());
        } else {
            this.set(smaliPayloadArray.unsignedInt());
        }
        this.refreshAlignment();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.ARRAY_DATA;
    }
}

