/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.ins.Size8Ins;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public class Ins4rcc
extends Size8Ins
implements RegistersSet {
    private ProtoId mProtoId;

    public Ins4rcc(Opcode<?> opcode) {
        super(opcode);
    }

    public ProtoId getProtoId() {
        return this.mProtoId;
    }

    public void setProtoId(ProtoKey protoKey) {
        Section<ProtoId> section = this.getSection(SectionType.PROTO_ID);
        this.setProtoId(section.getOrCreate(protoKey));
    }

    public void setProtoId(ProtoId protoId) {
        this.mProtoId = protoId;
        this.setShort(6, protoId.getIndex());
    }

    @Override
    public int getData() {
        return this.getShortUnsigned(2);
    }

    @Override
    public void setData(int data) {
        this.setShort(2, data);
    }

    @Override
    public int getRegistersCount() {
        return this.getByteUnsigned(1);
    }

    @Override
    public void setRegistersCount(int count) {
        this.setByte(1, count);
    }

    @Override
    public int getRegister(int index) {
        return this.getShortUnsigned(4) + index;
    }

    @Override
    public void setRegister(int index, int value) {
        if (index != 0) {
            this.setShort(1, value + 1);
        } else {
            this.setShort(4, value);
        }
    }

    @Override
    public boolean isRegistersRange() {
        return true;
    }

    @Override
    public int getRegistersLimit() {
        return 65535;
    }

    public int getProtoIndex() {
        return this.getShortUnsigned(6);
    }

    public void setProtoIndex(int data) {
        this.setShort(6, data);
        this.cacheProto();
    }

    @Override
    void cacheSectionItem() {
        super.cacheSectionItem();
        this.cacheProto();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.refreshProtoId();
    }

    private void refreshProtoId() {
        ProtoId protoId = this.mProtoId;
        protoId = (ProtoId)protoId.getReplace();
        this.setProtoIndex(protoId.getIndex());
        this.mProtoId = protoId;
    }

    private void cacheProto() {
        this.mProtoId = this.getSectionItem(SectionType.PROTO_ID, this.getProtoIndex());
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        super.appendCode(writer);
        writer.append(", ");
        this.getProtoId().append(writer);
    }
}

