/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.ins.Size8Ins;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public class Ins45cc
extends Size8Ins
implements RegistersSet {
    private ProtoId mProtoId;

    public Ins45cc(Opcode<?> opcode) {
        super(opcode);
    }

    public ProtoId getProtoId() {
        return this.mProtoId;
    }

    public void setProtoId(ProtoKey protoKey) {
        Section<ProtoId> section = this.getSection(SectionType.PROTO_ID);
        this.setProtoId(section.getOrCreate(protoKey));
    }

    public void setProtoId(ProtoId protoId) {
        this.setShort(6, protoId.getIndex());
        this.mProtoId = protoId;
    }

    @Override
    public int getRegistersCount() {
        return this.getNibble(3);
    }

    @Override
    public void setRegistersCount(int count) {
        this.setNibble(3, count);
    }

    @Override
    public int getRegister(int index) {
        if (index < 4) {
            return this.getNibble(8 + index);
        }
        return this.getNibble(2);
    }

    @Override
    public void setRegister(int index, int value) {
        if (index < 4) {
            this.setNibble(8 + index, value);
        } else {
            this.setNibble(2, value);
        }
    }

    @Override
    public int getRegistersLimit() {
        return 15;
    }

    @Override
    public int getData() {
        return this.getShortUnsigned(2);
    }

    @Override
    public void setData(int data) {
        this.setShort(2, data);
    }

    public int getProtoIndex() {
        return this.getShortUnsigned(6);
    }

    public void setProtoIndex(int data) {
        this.setShort(6, data);
        this.cacheProto();
    }

    @Override
    void cacheSectionItem() {
        super.cacheSectionItem();
        this.cacheProto();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.refreshProtoId();
    }

    private void refreshProtoId() {
        ProtoId protoId = this.mProtoId;
        protoId = (ProtoId)protoId.getReplace();
        this.setProtoIndex(protoId.getIndex());
    }

    private void cacheProto() {
        this.mProtoId = this.getSectionItem(SectionType.PROTO_ID, this.getProtoIndex());
    }

    @Override
    void appendCode(SmaliWriter writer) throws IOException {
        super.appendCode(writer);
        writer.append(", ");
        this.getProtoId().append(writer);
    }
}

