/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.ins.Ins22;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class Ins22t
extends Ins22
implements Label {
    public Ins22t(Opcode<?> opcode) {
        super(opcode);
    }

    @Override
    public int getRegister(int index) {
        return this.getNibble(2 + index);
    }

    @Override
    public void setRegister(int index, int value) {
        this.setNibble(2 + index, value);
    }

    @Override
    public int getRegistersLimit() {
        return 15;
    }

    @Override
    public int getData() {
        return this.getShortSigned();
    }

    @Override
    public void setData(int data) {
        this.setShort(2, data);
    }

    @Override
    public int getTargetAddress() {
        return this.getAddress() + this.getData();
    }

    @Override
    public void setTargetAddress(int targetAddress) {
        this.setData(targetAddress - this.getAddress());
    }

    @Override
    public String getLabelName() {
        return HexUtil.toHex(":cond_", this.getTargetAddress(), 1);
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        Opcode<?> opcode = this.getOpcode();
        writer.newLine();
        writer.append(opcode.getName());
        writer.append(' ');
        this.getRegistersIterator().append(writer);
        writer.append(", ");
        writer.append(this.getLabelName());
    }

    @Override
    public int getSortOrder() {
        return 5;
    }
}

