/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.RegisterFormat;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugLineNumber;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.ExtraLineList;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;

public class Ins
extends FixedDexContainerWithTool
implements SmaliFormat {
    private final Opcode<?> opcode;
    private ExtraLineList extraLineList;
    private int address;

    Ins(int childesCount, Opcode<?> opcode) {
        super(childesCount);
        this.opcode = opcode;
        this.extraLineList = ExtraLineList.EMPTY;
    }

    Ins(Opcode<?> opcode) {
        this(1, opcode);
    }

    public MethodDef getMethodDef() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getMethodDef();
        }
        return null;
    }

    public DebugSequence getOrCreateDebugSequence() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getOrCreateDebugSequence();
        }
        return null;
    }

    public DebugSequence getDebugSequence() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getDebugSequence();
        }
        return null;
    }

    public InstructionList getInstructionList() {
        return this.getParentInstance(InstructionList.class);
    }

    public void updateLabelAddress() {
        int address = this.getAddress();
        Iterator<ExtraLine> iterator = this.getExtraLines();
        while (iterator.hasNext()) {
            ExtraLine extraLine = iterator.next();
            if (address == extraLine.getTargetAddress()) continue;
            extraLine.setTargetAddress(address);
        }
    }

    public void transferExtraLines(Ins target) {
        target.extraLineList = this.extraLineList;
        this.extraLineList = ExtraLineList.EMPTY;
    }

    public void replace(Ins ins) {
        if (ins == null || ins == this) {
            return;
        }
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return;
        }
        instructionList.replace(this, ins);
    }

    public <T1 extends Ins> T1 replace(Opcode<T1> opcode) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Missing parent " + InstructionList.class.getSimpleName());
        }
        return instructionList.replace(this, opcode);
    }

    public <T1 extends Ins> T1 createNext(Opcode<T1> opcode) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Parent " + this.getClass().getSimpleName() + " == null");
        }
        return instructionList.createAt(this.getIndex() + 1, opcode);
    }

    public Ins[] createNext(Opcode<?>[] opcodeArray) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Parent " + this.getClass().getSimpleName() + " == null");
        }
        return instructionList.createAt(this.getIndex() + 1, opcodeArray);
    }

    public void moveTo(int index) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            throw new DexException("Parent " + this.getClass().getSimpleName() + " == null");
        }
        instructionList.moveTo(this, index);
    }

    public boolean is(Opcode<?> opcode) {
        return opcode == this.getOpcode();
    }

    public Opcode<?> getOpcode() {
        return this.opcode;
    }

    public RegisterFormat getRegisterFormat() {
        return this.getOpcode().getRegisterFormat();
    }

    public int getCodeUnits() {
        return this.countBytes() / 2;
    }

    public int getOutSize() {
        return 0;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public boolean isLonelyInTryCatch() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.isLonelyInTryCatch(this);
        }
        return false;
    }

    public void trimExtraLines() {
        this.extraLineList.trimToSize();
    }

    public void addExtraLine(ExtraLine extraLine) {
        if (extraLine != this) {
            this.extraLineList = ExtraLineList.add(this.extraLineList, extraLine);
        }
    }

    public void addExtraLine(Iterator<ExtraLine> iterator) {
        this.extraLineList = ExtraLineList.add(this.extraLineList, iterator);
    }

    public DebugLineNumber getDebugLineNumber() {
        return CollectionUtil.getFirst(this.getDebugLineNumbers());
    }

    public Iterator<DebugLineNumber> getDebugLineNumbers() {
        return InstanceIterator.of(this.getExtraLines(), DebugLineNumber.class);
    }

    public boolean removeDebugElement(DebugElement element) {
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            return debugSequence.remove(element);
        }
        return false;
    }

    public Iterator<DebugElement> getDebugElements() {
        return InstanceIterator.of(this.getExtraLines(), DebugElement.class);
    }

    public Iterator<ExtraLine> getExtraLines() {
        return this.extraLineList.iterator();
    }

    public <T1> Iterator<T1> getExtraLines(Class<T1> instance) {
        return this.extraLineList.iterator(instance);
    }

    public void clearExtraLines() {
        this.extraLineList = ExtraLineList.EMPTY;
    }

    public boolean hasExtraLines() {
        return !this.extraLineList.isEmpty();
    }

    private void appendExtraLines(SmaliWriter writer) throws IOException {
        Iterator<ExtraLine> iterator = this.getExtraLines();
        ExtraLine extraLine = null;
        boolean hasHandler = false;
        ExtraLine previous = null;
        while (iterator.hasNext()) {
            extraLine = iterator.next();
            if (extraLine.isEqualExtraLine(previous)) continue;
            writer.newLine();
            extraLine.appendExtra(writer);
            if (!hasHandler) {
                hasHandler = extraLine.getSortOrder() == 3;
            }
            previous = extraLine;
        }
        if (hasHandler && extraLine.getSortOrder() >= 3) {
            writer.newLine();
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.clearExtraLines();
    }

    public void replaceKeys(Key search, Key replace) {
    }

    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public void merge(Ins ins) {
    }

    public void fromSmali(SmaliInstruction smaliInstruction) throws IOException {
    }

    @Override
    public final void append(SmaliWriter writer) throws IOException {
        this.appendExtraLines(writer);
        this.appendCode(writer);
    }

    void appendCode(SmaliWriter writer) throws IOException {
        writer.newLine();
        writer.append(this.getOpcode().getName());
        writer.append(' ');
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        SmaliWriter smaliWriter = new SmaliWriter(writer);
        try {
            this.appendCode(smaliWriter);
            smaliWriter.close();
            return writer.toString().trim();
        }
        catch (Throwable exception) {
            return exception.toString();
        }
    }

    static int toSigned(int unsigned, int width) {
        int half = width / 2;
        if (unsigned <= half) {
            return unsigned;
        }
        return unsigned - width - 1;
    }
}

