/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.reference.IdItemIndirectReference;
import com.reandroid.dex.reference.IndirectStringReference;
import com.reandroid.dex.reference.TypeListReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class ProtoId
extends IdItem
implements Comparable<ProtoId> {
    private final IndirectStringReference shorty = new IndirectStringReference(this, 0, UsageMarker.USAGE_SHORTY);
    private final IdItemIndirectReference<TypeId> returnType = new IdItemIndirectReference<TypeId>(SectionType.TYPE_ID, this, 4, UsageMarker.USAGE_PROTO);
    private final TypeListReference parameters = new TypeListReference(this, 8, UsageMarker.USAGE_PROTO);
    private static final int SIZE = 12;

    public ProtoId() {
        super(12);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.singleThree(this, SingleIterator.of((TypeId)this.returnType.getItem()), this.getParameterIds(), SingleIterator.of((StringId)this.shorty.getItem()));
    }

    public SectionType<ProtoId> getSectionType() {
        return SectionType.PROTO_ID;
    }

    @Override
    public ProtoKey getKey() {
        return this.checkKey(ProtoKey.create(this));
    }

    @Override
    public void setKey(Key key) {
        this.setKey((ProtoKey)key);
    }

    public void setKey(ProtoKey key) {
        ProtoKey old = this.getKey();
        if (key.equals(old)) {
            return;
        }
        this.shorty.setString(key.getShorty());
        this.returnType.setItem(key.getReturnType());
        this.parameters.setItem(key.getParameterListKey());
        this.keyChanged(old);
    }

    public int getParameterRegistersCount() {
        TypeList typeList = this.getTypeList();
        if (typeList != null) {
            return typeList.getParameterRegistersCount();
        }
        return 0;
    }

    public int getParametersCount() {
        TypeList typeList = this.getTypeList();
        if (typeList != null) {
            return typeList.size();
        }
        return 0;
    }

    public TypeId getParameter(int index) {
        return this.parameters.get(index);
    }

    public TypeId getForRegister(int register) {
        return this.parameters.getForRegister(register);
    }

    public String[] getParameterNames() {
        TypeList typeList = this.getTypeList();
        if (typeList != null) {
            return typeList.getNames();
        }
        return null;
    }

    public Iterator<TypeId> getParameterIds() {
        TypeList typeList = this.getTypeList();
        if (typeList != null) {
            return typeList.iterator();
        }
        return EmptyIterator.of();
    }

    public TypeList getTypeList() {
        return (TypeList)this.parameters.getItem();
    }

    public TypeListReference getParametersReference() {
        return this.parameters;
    }

    public void setParameters(TypeListKey key) {
        this.parameters.setItem(key);
    }

    public TypeListKey getParameters() {
        return this.parameters.getKey();
    }

    public TypeKey getReturnType() {
        return (TypeKey)this.returnType.getKey();
    }

    public TypeId getReturnTypeId() {
        return (TypeId)this.returnType.getItem();
    }

    public String getShorty() {
        return this.shorty.getString();
    }

    public void setShorty(StringKey key) {
        this.shorty.setItem(key);
    }

    public void setShorty(String shortyString) {
        this.shorty.setString(shortyString);
    }

    public void rebuildShorty() {
        this.shorty.setString(this.getKey().getShorty());
    }

    @Override
    public void refresh() {
        this.shorty.refresh();
        this.returnType.refresh();
        this.parameters.refresh();
    }

    @Override
    void cacheItems() {
        this.shorty.pullItem();
        this.returnType.pullItem();
        this.parameters.pullItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('(');
        Iterator<TypeId> iterator = this.getParameterIds();
        while (iterator.hasNext()) {
            iterator.next().append(writer);
        }
        writer.append(')');
        writer.appendRequired(this.getReturnTypeId());
    }

    @Override
    public int compareTo(ProtoId protoId) {
        if (protoId == this) {
            return 0;
        }
        if (protoId == null) {
            return -1;
        }
        int i = SectionTool.compareIdx(this.getReturnTypeId(), protoId.getReturnTypeId());
        if (i != 0) {
            return i;
        }
        return SectionTool.compareIdx(this.getParameterIds(), protoId.getParameterIds());
    }

    public String toString() {
        ProtoKey key = this.getKey();
        if (key != null) {
            return key.toString();
        }
        return "(" + this.getTypeList() + ")" + this.getReturnTypeId();
    }
}

