/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.reference.IdItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.CombiningIterator;
import java.io.IOException;
import java.util.Iterator;

public class MethodHandle
extends IdItem
implements Comparable<MethodHandle> {
    private final IdItemIndirectReference<MethodId> id = new IdItemIndirectReference<MethodId>(SectionType.METHOD_ID, this, 0);
    private final IdItemIndirectReference<MethodId> member = new IdItemIndirectReference<MethodId>(SectionType.METHOD_ID, this, 4);

    public MethodHandle() {
        super(8);
    }

    @Override
    public MethodHandleKey getKey() {
        return this.checkKey(new MethodHandleKey(this.getIdKey(), this.getMemberKey()));
    }

    @Override
    public void setKey(Key key) {
        MethodHandleKey methodHandle = (MethodHandleKey)key;
        this.setId(methodHandle.getId());
        this.setMember(methodHandle.getMember());
    }

    public MethodId getId() {
        return (MethodId)this.id.getItem();
    }

    public MethodKey getIdKey() {
        return (MethodKey)this.id.getKey();
    }

    public void setId(MethodKey methodKey) {
        this.id.setItem(methodKey);
    }

    public MethodId getMember() {
        return (MethodId)this.member.getItem();
    }

    public MethodKey getMemberKey() {
        return (MethodKey)this.member.getKey();
    }

    public void setMember(MethodKey methodKey) {
        this.member.setItem(methodKey);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.two(this.getId().usedIds(), this.getMember().usedIds());
    }

    public SectionType<MethodHandle> getSectionType() {
        return SectionType.METHOD_HANDLE;
    }

    @Override
    public void refresh() {
        this.id.refresh();
        this.member.refresh();
    }

    @Override
    void cacheItems() {
        this.id.pullItem();
        this.member.pullItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        MethodId id = this.getId();
        if (id == null) {
            writer.append("error id = ");
            writer.appendInteger(this.id.get());
        } else {
            id.append(writer);
        }
        writer.append(", ");
        MethodId member = this.getMember();
        if (member == null) {
            writer.append("error member = ");
            writer.appendInteger(this.member.get());
        } else {
            member.append(writer);
        }
    }

    @Override
    public int compareTo(MethodHandle methodHandle) {
        if (methodHandle == null) {
            return -1;
        }
        int i = CompareUtil.compare(this.getId(), methodHandle.getId());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getMember(), methodHandle.getMember());
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

