/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.ClassTypeId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.SourceFile;
import com.reandroid.dex.id.SuperClassId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.reference.TypeListReference;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.IntValue;
import com.reandroid.dex.value.MethodIdValue;
import com.reandroid.dex.value.StringValue;
import com.reandroid.dex.value.TypeValue;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class ClassId
extends IdItem
implements IdDefinition<TypeId>,
Comparable<ClassId> {
    private final ClassTypeId classTypeId;
    private final IndirectInteger accessFlagValue;
    private final SuperClassId superClassId;
    private final TypeListReference interfaces;
    private final SourceFile sourceFile;
    private final DataItemIndirectReference<AnnotationsDirectory> annotationsDirectory;
    private final DataItemIndirectReference<ClassData> classData;
    private final DataItemIndirectReference<EncodedArray> staticValues;
    private static final int SIZE = 32;

    public ClassId() {
        super(32);
        int offset = -4;
        this.classTypeId = new ClassTypeId(this, offset += 4);
        this.accessFlagValue = new IndirectInteger(this, offset += 4);
        this.superClassId = new SuperClassId(this, offset += 4);
        this.interfaces = new TypeListReference(this, offset += 4, USAGE_INTERFACE);
        this.sourceFile = new SourceFile(this, offset += 4);
        this.annotationsDirectory = new DataItemIndirectReference<AnnotationsDirectory>(SectionType.ANNOTATION_DIRECTORY, this, offset += 4, UsageMarker.USAGE_DEFINITION);
        this.classData = new DataItemIndirectReference<ClassData>(SectionType.CLASS_DATA, this, offset += 4, UsageMarker.USAGE_DEFINITION);
        this.staticValues = new DataItemIndirectReference<EncodedArray>(SectionType.ENCODED_ARRAY, this, offset += 4, UsageMarker.USAGE_STATIC_VALUES);
        this.addUsageType(UsageMarker.USAGE_DEFINITION);
    }

    @Override
    public void clearUsageType() {
    }

    @Override
    public void edit() {
        this.editInternal(this);
    }

    @Override
    public void editInternal(Block user) {
        this.annotationsDirectory.editInternal(this);
        this.classData.editInternal(this);
        this.staticValues.editInternal(this);
    }

    public SectionType<ClassId> getSectionType() {
        return SectionType.CLASS_ID;
    }

    @Override
    public TypeKey getKey() {
        return this.checkKey(TypeKey.create(this.getName()));
    }

    @Override
    public void setKey(Key key) {
        TypeKey old = this.getKey();
        if (Objects.equals(old, key)) {
            return;
        }
        this.classTypeId.setItem(key);
        this.keyChanged(old);
    }

    public String getName() {
        TypeId typeId = this.getId();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public void setName(String typeName) {
        this.setKey(new TypeKey(typeName));
    }

    public ClassTypeId getClassTypeId() {
        return this.classTypeId;
    }

    @Override
    public TypeId getId() {
        return (TypeId)this.getClassTypeId().getItem();
    }

    @Override
    public int getAccessFlagsValue() {
        return this.accessFlagValue.get();
    }

    @Override
    public Iterator<? extends Modifier> getAccessFlags() {
        return AccessFlag.valuesOfClass(this.getAccessFlagsValue());
    }

    @Override
    public void setAccessFlagsValue(int value) {
        this.accessFlagValue.set(value);
    }

    public void setId(TypeId typeId) {
        this.classTypeId.setItem(typeId);
    }

    public SuperClassId getSuperClassId() {
        return this.superClassId;
    }

    public TypeId getSuperClassType() {
        return (TypeId)this.getSuperClassId().getItem();
    }

    public TypeKey getSuperClassKey() {
        return this.getSuperClassId().getKey();
    }

    public void setSuperClass(TypeKey typeKey) {
        this.superClassId.setItem(typeKey);
    }

    public void setSuperClass(String superClass) {
        this.superClassId.setItem(new TypeKey(superClass));
    }

    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public String getSourceFileName() {
        return this.getSourceFile().getString();
    }

    public void setSourceFile(String sourceFile) {
        this.getSourceFile().setString(sourceFile);
    }

    public Iterator<TypeKey> getInstanceKeys() {
        return CombiningIterator.singleOne(this.getSuperClassKey(), this.getInterfaceKeys());
    }

    public Iterator<TypeKey> getInterfaceKeys() {
        return this.getInterfacesReference().getTypeKeys();
    }

    public TypeList getInterfaceTypeList() {
        return (TypeList)this.interfaces.getItem();
    }

    public TypeListReference getInterfacesReference() {
        return this.interfaces;
    }

    public void setInterfaces(TypeListKey typeListKey) {
        this.interfaces.setItem(typeListKey);
    }

    public Key getDalvikEnclosing() {
        TypeValue typeValue = this.getDalvikEnclosingClass();
        if (typeValue != null) {
            return typeValue.getKey();
        }
        MethodIdValue methodIdValue = this.getDalvikEnclosingMethodId();
        if (methodIdValue != null) {
            return methodIdValue.getKey();
        }
        return null;
    }

    public MethodIdValue getDalvikEnclosingMethodId() {
        DexValueBlock<?> value;
        AnnotationItem annotationItem = this.getDalvikEnclosingMethod();
        if (annotationItem != null && (value = annotationItem.getElementValue(Key.DALVIK_value)) instanceof MethodIdValue) {
            return (MethodIdValue)value;
        }
        return null;
    }

    public Iterator<TypeKey> getMemberClassKeys() {
        return ComputeIterator.of(this.getDalvikMemberClasses(), TypeValue::getKey);
    }

    public Iterator<TypeValue> getDalvikMemberClasses() {
        DexValueBlock<?> value;
        AnnotationItem annotationItem = this.getDalvikMemberClass();
        if (annotationItem != null && (value = annotationItem.getElementValue(Key.DALVIK_value)) instanceof ArrayValue) {
            return ((ArrayValue)value).iterator(TypeValue.class);
        }
        return EmptyIterator.of();
    }

    public AnnotationItem getDalvikEnclosingMethod() {
        return this.getClassAnnotation(TypeKey.DALVIK_EnclosingMethod);
    }

    public AnnotationItem getDalvikMemberClass() {
        return this.getClassAnnotation(TypeKey.DALVIK_MemberClass);
    }

    public AnnotationItem getDalvikInnerClass() {
        AnnotationSet annotationSet = this.getClassAnnotations();
        if (annotationSet == null) {
            return null;
        }
        return annotationSet.get(TypeKey.DALVIK_InnerClass);
    }

    public AnnotationItem getOrCreateDalvikInnerClass() {
        TypeKey typeKey = this.getKey();
        if (typeKey == null) {
            return null;
        }
        String inner = typeKey.getSimpleInnerName();
        if (AccessFlag.SYNTHETIC.isSet(this.getAccessFlagsValue()) || inner.equals(typeKey.getSimpleName()) || StringsUtil.isDigits(inner)) {
            inner = null;
        }
        return this.getOrCreateDalvikInnerClass(this.getAccessFlagsValue(), inner);
    }

    public AnnotationItem getOrCreateDalvikInnerClass(int flags, String name) {
        AnnotationSet annotationSet = this.getOrCreateClassAnnotations();
        AnnotationItem item = annotationSet.getOrCreate(TypeKey.DALVIK_InnerClass);
        item.setVisibility(AnnotationVisibility.SYSTEM);
        AnnotationElement accessFlags = item.getOrCreateElement(Key.DALVIK_accessFlags);
        IntValue accessFlagsValue = accessFlags.getOrCreateValue(DexValueType.INT);
        accessFlagsValue.set(flags);
        AnnotationElement nameElement = item.getOrCreateElement(Key.DALVIK_name);
        if (name != null) {
            StringValue stringValue = nameElement.getOrCreateValue(DexValueType.STRING);
            stringValue.setItem(new StringKey(name));
        } else {
            nameElement.getOrCreateValue(DexValueType.NULL);
        }
        return item;
    }

    public TypeValue getOrCreateDalvikEnclosingClass() {
        TypeKey enclosing;
        TypeKey key = this.getKey();
        if (key != null && !key.equals(enclosing = key.getEnclosingClass())) {
            return this.getOrCreateDalvikEnclosingClass(enclosing);
        }
        return null;
    }

    public TypeValue getOrCreateDalvikEnclosingClass(TypeKey enclosing) {
        if (enclosing == null) {
            return null;
        }
        AnnotationSet annotationSet = this.getOrCreateClassAnnotations();
        AnnotationItem item = annotationSet.getOrCreate(TypeKey.DALVIK_EnclosingClass);
        item.setVisibility(AnnotationVisibility.SYSTEM);
        AnnotationElement element = item.getOrCreateElement(Key.DALVIK_value);
        TypeValue typeValue = element.getOrCreateValue(DexValueType.TYPE);
        typeValue.setKey(enclosing);
        return typeValue;
    }

    public TypeValue getDalvikEnclosingClass() {
        AnnotationItem item = this.getDalvikEnclosingClassAnnotation();
        if (item == null) {
            return null;
        }
        AnnotationElement element = item.getElement(Key.DALVIK_value);
        DexValueBlock<?> value = element.getValue();
        if (value instanceof TypeValue) {
            return (TypeValue)value;
        }
        return null;
    }

    public AnnotationItem getDalvikEnclosingClassAnnotation() {
        AnnotationSet annotationSet = this.getClassAnnotations();
        if (annotationSet != null) {
            return annotationSet.get(TypeKey.DALVIK_EnclosingClass);
        }
        return null;
    }

    public AnnotationSet getOrCreateClassAnnotations() {
        return this.getOrCreateAnnotationsDirectory().getOrCreateClassAnnotations();
    }

    public AnnotationItem getClassAnnotation(TypeKey typeKey) {
        AnnotationSet classAnnotations = this.getClassAnnotations();
        if (classAnnotations != null) {
            return classAnnotations.get(typeKey);
        }
        return null;
    }

    public Iterator<AnnotationItem> getClassAnnotations(TypeKey typeKey) {
        AnnotationSet classAnnotations = this.getClassAnnotations();
        if (classAnnotations != null) {
            return classAnnotations.getAll(typeKey);
        }
        return EmptyIterator.of();
    }

    public AnnotationSet getClassAnnotations() {
        AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
        if (annotationsDirectory != null) {
            return annotationsDirectory.getClassAnnotations();
        }
        return null;
    }

    public void setClassAnnotations(AnnotationSet annotationSet) {
        AnnotationsDirectory annotationsDirectory = this.getAnnotationsDirectory();
        if (annotationsDirectory != null) {
            annotationsDirectory.setClassAnnotations(annotationSet);
        }
    }

    public AnnotationsDirectory getOrCreateAnnotationsDirectory() {
        AnnotationsDirectory directory = this.annotationsDirectory.getOrCreate();
        directory.addUniqueUser(this);
        return directory;
    }

    public AnnotationsDirectory getUniqueAnnotationsDirectory() {
        return this.annotationsDirectory.getUniqueItem(this);
    }

    public AnnotationsDirectory getOrCreateUniqueAnnotationsDirectory() {
        return this.annotationsDirectory.getOrCreateUniqueItem(this);
    }

    public AnnotationsDirectory getAnnotationsDirectory() {
        return (AnnotationsDirectory)this.annotationsDirectory.getItem();
    }

    public void setAnnotationsDirectory(AnnotationsDirectory directory) {
        this.annotationsDirectory.setItem(directory);
    }

    public ClassData getOrCreateClassData() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData;
        }
        Section<ClassData> section = this.getSection(SectionType.CLASS_DATA);
        classData = section.createItem();
        this.setClassData(classData);
        return classData;
    }

    public ClassData getClassData() {
        ClassData data = (ClassData)this.classData.getItem();
        this.linkClassData(data);
        return data;
    }

    public void setClassData(ClassData classData) {
        this.classData.setItem(classData);
        this.linkClassData(classData);
    }

    public EncodedArray getStaticValues() {
        return (EncodedArray)this.staticValues.getItem();
    }

    public EncodedArray getOrCreateUniqueStaticValues() {
        return this.staticValues.getOrCreateUniqueItem(this);
    }

    public EncodedArray getUniqueStaticValues() {
        return this.staticValues.getUniqueItem(this);
    }

    public DexValueBlock<?> getStaticValue(int i) {
        EncodedArray encodedArray = this.getStaticValues();
        if (encodedArray != null) {
            return encodedArray.get(i);
        }
        return null;
    }

    public <T1 extends DexValueBlock<?>> T1 getOrCreateStaticValue(DexValueType<T1> valueType, int i) {
        return this.getOrCreateUniqueStaticValues().getOrCreate(valueType, i);
    }

    public void setStaticValues(EncodedArray staticValues) {
        this.staticValues.setItem(staticValues);
    }

    @Override
    public void refresh() {
        this.annotationsDirectory.addUniqueUser(this);
        this.classData.addUniqueUser(this);
        this.staticValues.addUniqueUser(this);
        this.classTypeId.refresh();
        this.superClassId.refresh();
        this.interfaces.refresh();
        this.sourceFile.refresh();
        this.annotationsDirectory.refresh();
        this.classData.refresh();
        this.staticValues.refresh();
    }

    @Override
    void cacheItems() {
        this.classTypeId.pullItem();
        this.superClassId.pullItem();
        this.interfaces.pullItem();
        this.sourceFile.pullItem();
        this.annotationsDirectory.pullItem();
        this.classData.pullItem();
        this.staticValues.pullItem();
        this.annotationsDirectory.addUniqueUser(this);
        this.classData.addUniqueUser(this);
        this.staticValues.addUniqueUser(this);
        this.linkClassData((ClassData)this.classData.getItem());
    }

    private void linkClassData(ClassData classData) {
        if (classData != null) {
            classData.setClassId(this);
        }
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        this.classTypeId.unlink();
        this.superClassId.unlink();
        this.sourceFile.unlink();
        this.classData.unlink();
        this.annotationsDirectory.unlink();
        this.staticValues.unlink();
    }

    public void replaceKeys(Key search, Key replace) {
        this.classTypeId.replaceKeys(search, replace);
        this.superClassId.replaceKeys(search, replace);
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            directory = this.getUniqueAnnotationsDirectory();
            directory.replaceKeys(search, replace);
        }
        this.interfaces.replaceKeys(search, replace);
        ClassData classData = this.getClassData();
        if (classData != null) {
            classData.replaceKeys(search, replace);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return this.listUsedIds().iterator();
    }

    public ArrayCollection<IdItem> listUsedIds() {
        EncodedArray encodedArray;
        ClassData classData;
        ArrayCollection<IdItem> collection = new ArrayCollection<IdItem>(200);
        collection.add((IdItem)this.classTypeId.getItem());
        collection.add((IdItem)this.superClassId.getItem());
        collection.add((IdItem)this.sourceFile.getItem());
        collection.addAll(this.interfaces.iterator());
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            collection.addAll(directory.usedIds());
        }
        if ((classData = this.getClassData()) != null) {
            collection.addAll(classData.usedIds());
        }
        if ((encodedArray = this.getStaticValues()) != null) {
            collection.addAll(encodedArray.usedIds());
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IdItem idItem = collection.get(i);
            collection.addAll(idItem.usedIds());
        }
        return collection;
    }

    public void merge(ClassId classId) {
        ClassData comingData;
        if (classId == this) {
            return;
        }
        this.accessFlagValue.set(classId.accessFlagValue.get());
        this.superClassId.setItem(classId.superClassId.getKey());
        this.sourceFile.setItem(classId.sourceFile.getKey());
        this.interfaces.setItem(classId.interfaces.getKey());
        this.annotationsDirectory.setItem(classId.annotationsDirectory.getKey());
        EncodedArray comingArray = classId.getStaticValues();
        if (comingArray != null) {
            EncodedArray encodedArray = this.staticValues.getOrCreate();
            encodedArray.merge(comingArray);
        }
        if ((comingData = classId.getClassData()) != null) {
            ClassData classData = this.getOrCreateClassData();
            classData.merge(comingData);
        }
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        this.setKey(smaliClass.getKey());
        this.setAccessFlagsValue(smaliClass.getAccessFlagsValue());
        this.setSuperClass(smaliClass.getSuperClass());
        this.setSourceFile(smaliClass.getSourceFileName());
        this.setInterfaces(smaliClass.getInterfacesKey());
        if (smaliClass.hasClassData()) {
            this.getOrCreateClassData().fromSmali(smaliClass);
        }
        if (smaliClass.hasAnnotation()) {
            this.getOrCreateClassAnnotations().fromSmali(smaliClass.getAnnotation());
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        ClassData classData;
        AnnotationSet annotationSet;
        this.getClassTypeId().append(writer);
        this.getSuperClassId().append(writer);
        this.getSourceFile().append(writer);
        writer.newLine();
        TypeList interfaces = this.getInterfaceTypeList();
        if (interfaces != null) {
            interfaces.appendInterfaces(writer);
        }
        if ((annotationSet = this.getClassAnnotations()) != null) {
            writer.newLine();
            writer.newLine();
            writer.appendComment("annotations");
            annotationSet.append(writer);
            writer.newLine();
        }
        if ((classData = this.getClassData()) != null) {
            classData.append(writer);
        } else {
            writer.appendComment("Null class data: " + this.classData.get());
        }
    }

    @Override
    public int compareTo(ClassId classId) {
        if (classId == null) {
            return -1;
        }
        if (classId == this) {
            return 0;
        }
        return SectionTool.compareIdx(this.getId(), classId.getId());
    }

    public String toString() {
        if (this.isReading()) {
            return ".class " + this.getKey();
        }
        return SmaliWriter.toStringSafe(this);
    }
}

