/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodHandle;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.IdKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class CallSiteId
extends IdItem
implements Comparable<CallSiteId> {
    private final DataItemIndirectReference<EncodedArray> encodedArrayReference = new DataItemIndirectReference<EncodedArray>(SectionType.ENCODED_ARRAY, this, 0, UsageMarker.USAGE_CALL_SITE);
    private final IdKey<CallSiteId> mKey = new IdKey<CallSiteId>(this);

    public CallSiteId() {
        super(4);
    }

    @Override
    public IdKey<CallSiteId> getKey() {
        return this.mKey;
    }

    @Override
    public void setKey(Key key) {
        IdKey idKey = (IdKey)key;
        this.merge((CallSiteId)idKey.getItem());
    }

    public MethodHandle getMethodHandle() {
        return this.getValue(SectionType.METHOD_HANDLE, 0);
    }

    public void setMethodHandle(MethodHandleKey key) {
        this.getOrCreateValue(SectionType.METHOD_HANDLE, 0, key);
    }

    public String getMethodName() {
        StringId stringId = this.getMethodNameId();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public void setMethodName(String methodName) {
        this.setMethodName(StringKey.create(methodName));
    }

    public void setMethodName(StringKey methodName) {
        this.getOrCreateValue(SectionType.STRING_ID, 1, methodName);
    }

    public StringId getMethodNameId() {
        return this.getValue(SectionType.STRING_ID, 1);
    }

    public MethodId getMethodId() {
        return this.getValue(SectionType.METHOD_ID, 2);
    }

    public void setMethodId(MethodKey methodKey) {
        this.getOrCreateValue(SectionType.METHOD_ID, 2, methodKey);
    }

    private <T1 extends IdItem> T1 getOrCreateValue(SectionType<T1> sectionType, int index, Key key) {
        EncodedArray encodedArray = this.getOrCreateEncodedArray();
        SectionValue<T1> sectionValue = encodedArray.getOrCreate(sectionType, index);
        sectionValue.setItem(key);
        return (T1)((IdItem)sectionValue.getItem());
    }

    private <T1 extends IdItem> T1 getValue(SectionType<T1> sectionType, int index) {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray == null) {
            return null;
        }
        DexValueBlock<?> value = encodedArray.get(index);
        if (!(value instanceof SectionValue)) {
            return null;
        }
        SectionValue sectionValue = (SectionValue)value;
        if (sectionValue.getSectionType() != sectionType) {
            return null;
        }
        return (T1)((IdItem)((SectionValue)value).getItem());
    }

    public EncodedArray getOrCreateEncodedArray() {
        return this.encodedArrayReference.getOrCreate();
    }

    public EncodedArray getEncodedArray() {
        return (EncodedArray)this.encodedArrayReference.getItem();
    }

    @Override
    void cacheItems() {
        this.encodedArrayReference.pullItem();
    }

    @Override
    public void refresh() {
        this.encodedArrayReference.refresh();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray == null) {
            return EmptyIterator.of();
        }
        return encodedArray.usedIds();
    }

    public SectionType<CallSiteId> getSectionType() {
        return SectionType.CALL_SITE_ID;
    }

    public void merge(CallSiteId callSiteId) {
        if (callSiteId == this) {
            return;
        }
        EncodedArray encodedArray = this.getOrCreateEncodedArray();
        encodedArray.merge(callSiteId.getEncodedArray());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
    }

    @Override
    public int compareTo(CallSiteId callSiteId) {
        if (callSiteId == this) {
            return 0;
        }
        if (callSiteId == null) {
            return -1;
        }
        int i = CompareUtil.compare(this.getMethodHandle(), callSiteId.getMethodHandle());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getMethodNameId(), callSiteId.getMethodNameId());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getMethodId(), callSiteId.getMethodId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallSiteId callSiteId = (CallSiteId)o;
        return Objects.equals(this.getEncodedArray(), callSiteId.getEncodedArray());
    }

    public int hashCode() {
        EncodedArray encodedArray = this.getEncodedArray();
        if (encodedArray != null) {
            return encodedArray.hashCode();
        }
        return 0;
    }
}

