/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.header.HeaderPiece;

public class Version
extends HeaderPiece {
    private int mCache;
    private static final byte[] DEFAULT_BYTES = new byte[]{48, 51, 53, 0};
    public static final int ClassDefinitionOrderEnforcedVersion = 37;

    public Version() {
        super.set((byte[])DEFAULT_BYTES.clone());
    }

    public int getVersionAsInteger() {
        if (this.mCache != 0) {
            return this.mCache;
        }
        byte[] bytes = this.getBytesInternal();
        if (bytes == null || bytes.length != 4) {
            return -1;
        }
        this.mCache = ((bytes[0] & 0xFF) - 48) * 100 + ((bytes[1] & 0xFF) - 48) * 10 + ((bytes[2] & 0xFF) - 48);
        return this.mCache;
    }

    public void setVersionAsInteger(int version) {
        this.setSize(4);
        byte[] bytes = this.getBytesInternal();
        if (version < 0 || version > 999) {
            version = 0;
        }
        int i = version / 100;
        bytes[0] = (byte)((i & 0xFF) + 48);
        version -= i * 100;
        i = version / 10;
        bytes[1] = (byte)((i & 0xFF) + 48);
        version -= i * 10;
        i = version;
        bytes[2] = (byte)((i & 0xFF) + 48);
        bytes[3] = 0;
        this.mCache = 0;
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = 0;
    }

    public boolean isDefault() {
        return ByteArray.equals(this.getBytesInternal(), DEFAULT_BYTES);
    }

    public boolean isClassDefinitionOrderEnforced() {
        return this.getVersionAsInteger() >= 37;
    }

    @Override
    public String toString() {
        int version = this.getVersionAsInteger();
        if (version <= 0) {
            return super.toString();
        }
        return String.valueOf(version);
    }
}

