/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberIntegerReference;
import com.reandroid.dex.header.Checksum;
import com.reandroid.dex.header.CountAndOffset;
import com.reandroid.dex.header.Endian;
import com.reandroid.dex.header.Magic;
import com.reandroid.dex.header.Signature;
import com.reandroid.dex.header.Version;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.SpecialItem;
import java.io.IOException;
import java.io.InputStream;

public class DexHeader
extends SpecialItem
implements OffsetSupplier,
BlockLoad {
    private final IntegerReference offsetReference;
    public final Magic magic;
    public final Version version;
    public final Checksum checksum;
    public final Signature signature;
    public final IntegerItem fileSize;
    public final IntegerItem headerSize;
    public final Endian endian;
    public final IntegerItem map;
    public final CountAndOffset string_id;
    public final CountAndOffset type_id;
    public final CountAndOffset proto_id;
    public final CountAndOffset field_id;
    public final CountAndOffset method_id;
    public final CountAndOffset class_id;
    public final CountAndOffset data;
    public final ByteArray unknown;
    private static final int COMMON_HEADER_SIZE = 112;

    public DexHeader(IntegerReference offsetReference) {
        super(16);
        this.offsetReference = offsetReference;
        this.magic = new Magic();
        this.version = new Version();
        this.checksum = new Checksum();
        this.signature = new Signature();
        this.fileSize = new IntegerItem();
        this.headerSize = new IntegerItem();
        this.endian = new Endian();
        this.map = new IntegerItem();
        this.string_id = new CountAndOffset();
        this.type_id = new CountAndOffset();
        this.proto_id = new CountAndOffset();
        this.field_id = new CountAndOffset();
        this.method_id = new CountAndOffset();
        this.class_id = new CountAndOffset();
        this.data = new CountAndOffset();
        this.unknown = new ByteArray();
        this.addChild(0, this.magic);
        this.addChild(1, this.version);
        this.addChild(2, this.checksum);
        this.addChild(3, this.signature);
        this.addChild(4, this.fileSize);
        this.addChild(5, this.headerSize);
        this.addChild(6, this.endian);
        this.addChild(7, this.map);
        this.addChild(8, this.string_id);
        this.addChild(9, this.type_id);
        this.addChild(10, this.proto_id);
        this.addChild(11, this.field_id);
        this.addChild(12, this.method_id);
        this.addChild(13, this.class_id);
        this.addChild(14, this.data);
        this.addChild(15, this.unknown);
        this.headerSize.setBlockLoad(this);
        this.setOffsetReference(offsetReference);
    }

    public DexHeader() {
        this(new NumberIntegerReference(0));
    }

    public SectionType<DexHeader> getSectionType() {
        return SectionType.HEADER;
    }

    public int getVersion() {
        return this.version.getVersionAsInteger();
    }

    public void setVersion(int version) {
        this.version.setVersionAsInteger(version);
    }

    public CountAndOffset get(SectionType<?> sectionType) {
        if (sectionType == SectionType.STRING_ID) {
            return this.string_id;
        }
        if (sectionType == SectionType.TYPE_ID) {
            return this.type_id;
        }
        if (sectionType == SectionType.PROTO_ID) {
            return this.proto_id;
        }
        if (sectionType == SectionType.FIELD_ID) {
            return this.field_id;
        }
        if (sectionType == SectionType.METHOD_ID) {
            return this.method_id;
        }
        if (sectionType == SectionType.CLASS_ID) {
            return this.class_id;
        }
        return null;
    }

    public void updateHeaderInternal(Block parent) {
        byte[] bytes = parent.getBytes();
        this.headerSize.set(this.countBytes());
        this.fileSize.set(bytes.length);
        this.signature.update(parent, bytes);
        this.checksum.update(parent, bytes);
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.offsetReference;
    }

    @Override
    protected boolean isValidOffset(int offset) {
        return offset >= 0;
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.headerSize) {
            this.unknown.setSize(this.headerSize.get() - this.countBytes());
        }
    }

    public boolean isClassDefinitionOrderEnforced() {
        return this.version.isClassDefinitionOrderEnforced();
    }

    public String toString() {
        return "Header {magic=" + this.magic + ", version=" + this.version + ", checksum=" + this.checksum + ", signature=" + this.signature + ", fileSize=" + this.fileSize + ", headerSize=" + this.headerSize + ", endian=" + this.endian + ", map=" + this.map + ", strings=" + this.string_id + ", type=" + this.type_id + ", proto=" + this.proto_id + ", field=" + this.field_id + ", method=" + this.method_id + ", clazz=" + this.class_id + ", data=" + this.data + ", unknown=" + this.unknown + '}';
    }

    public static DexHeader readHeader(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[112];
        int read = inputStream.read(bytes, 0, bytes.length);
        if (read < 0) {
            throw new IOException("Finished reading");
        }
        if (read < bytes.length) {
            throw new IOException("Few bytes to read header: " + read);
        }
        BlockReader reader = new BlockReader(bytes);
        DexHeader dexHeader = new DexHeader();
        dexHeader.headerSize.setBlockLoad(null);
        dexHeader.readBytes(reader);
        reader.close();
        return dexHeader;
    }
}

