/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugStartLocal;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class DebugStartLocalExtended
extends DebugStartLocal {
    private final Base1Ule128IdItemReference<StringId> mSignature = new Base1Ule128IdItemReference<StringId>(SectionType.STRING_ID);

    public DebugStartLocalExtended() {
        super(1, DebugElementType.START_LOCAL_EXTENDED);
        this.addChild(4, this.mSignature);
    }

    @Override
    public boolean isValid() {
        return this.mSignature.getItem() != null;
    }

    public String getSignature() {
        StringId stringId = (StringId)this.mSignature.getItem();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public StringKey getSignatureKey() {
        return (StringKey)this.mSignature.getKey();
    }

    public void setSignature(String signature) {
        this.mSignature.setItem(StringKey.create(signature));
    }

    public void setSignature(StringKey key) {
        this.mSignature.setItem(key);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        super.appendExtra(writer);
        writer.append(", ");
        this.mSignature.append(writer);
    }

    public DebugElementType<DebugStartLocalExtended> getElementType() {
        return DebugElementType.START_LOCAL_EXTENDED;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.two(super.usedIds(), SingleIterator.of((StringId)this.mSignature.getItem()));
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugStartLocalExtended coming = (DebugStartLocalExtended)element;
        this.mSignature.setItem(coming.mSignature.getKey());
    }

    @Override
    public void fromSmali(SmaliDebug smaliDebug) throws IOException {
        super.fromSmali(smaliDebug);
        this.setSignature(((SmaliDebugLocal)smaliDebug).getSignature());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugStartLocalExtended debug = (DebugStartLocalExtended)obj;
        return this.getFlag() == debug.getFlag() && Objects.equals(this.getName(), debug.getName()) && Objects.equals(this.getType(), debug.getType()) && Objects.equals(this.getSignature(), debug.getSignature());
    }

    @Override
    public int hashCode() {
        int hash = this.getFlag();
        hash *= 31;
        String text = this.getName();
        if (text != null) {
            hash += text.hashCode();
        }
        hash *= 31;
        text = this.getType();
        if (text != null) {
            hash += text.hashCode();
        }
        hash *= 31;
        text = this.getSignature();
        if (text != null) {
            hash += text.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mSignature;
    }
}

