/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugRegisterNumber;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class DebugStartLocal
extends DebugRegisterNumber {
    private final Base1Ule128IdItemReference<StringId> mName = new Base1Ule128IdItemReference<StringId>(SectionType.STRING_ID);
    private final Base1Ule128IdItemReference<TypeId> mType = new Base1Ule128IdItemReference<TypeId>(SectionType.TYPE_ID);

    DebugStartLocal(int childesCount, int flag) {
        super(childesCount + 2, flag);
        this.addChild(2, this.mName);
        this.addChild(3, this.mType);
    }

    DebugStartLocal(int childesCount, DebugElementType<?> elementType) {
        this(childesCount, elementType.getFlag());
    }

    public DebugStartLocal() {
        this(0, DebugElementType.START_LOCAL.getFlag());
    }

    @Override
    public boolean isValid() {
        return this.mName.getItem() != null && this.mType.getItem() != null;
    }

    public String getName() {
        StringId stringId = (StringId)this.mName.getItem();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public StringKey getNameKey() {
        return (StringKey)this.mName.getKey();
    }

    public void setName(String name) {
        this.setName(StringKey.create(name));
    }

    public void setName(StringKey key) {
        this.mName.setItem(key);
    }

    public String getType() {
        TypeId typeId = (TypeId)this.mType.getItem();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public TypeId getTypeId() {
        return (TypeId)this.mType.getItem();
    }

    public TypeKey getTypeKey() {
        return (TypeKey)this.mType.getKey();
    }

    public void setType(String type) {
        this.mType.setItem(TypeKey.create(type));
    }

    public void setType(TypeKey typeKey) {
        this.mType.setItem(typeKey);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendRegister(this.getRegisterNumber());
        writer.append(", ");
        this.mName.append(writer);
        writer.append(':');
        this.mType.append(writer);
    }

    public DebugElementType<? extends DebugStartLocal> getElementType() {
        return DebugElementType.START_LOCAL;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.two(SingleIterator.of((StringId)this.mName.getItem()), SingleIterator.of((TypeId)this.mType.getItem()));
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugStartLocal coming = (DebugStartLocal)element;
        this.mName.setItem(coming.mName.getKey());
        this.mType.setItem(coming.mType.getKey());
    }

    @Override
    public void fromSmali(SmaliDebug smaliDebug) throws IOException {
        super.fromSmali(smaliDebug);
        SmaliDebugLocal smaliDebugLocal = (SmaliDebugLocal)smaliDebug;
        this.setName(smaliDebugLocal.getName());
        this.setType(smaliDebugLocal.getType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugStartLocal debug = (DebugStartLocal)obj;
        return this.getFlag() == debug.getFlag() && Objects.equals(this.getName(), debug.getName()) && Objects.equals(this.getType(), debug.getType());
    }

    @Override
    public int hashCode() {
        int hash = this.getFlag();
        hash *= 31;
        String text = this.getName();
        if (text != null) {
            hash += text.hashCode();
        }
        hash *= 31;
        text = this.getType();
        if (text != null) {
            hash += text.hashCode();
        }
        return hash;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mName + ':' + this.mType;
    }
}

