/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;

public class DebugSetSourceFile
extends DebugElement {
    private final Base1Ule128IdItemReference<StringId> mName = new Base1Ule128IdItemReference<StringId>(SectionType.STRING_ID);

    public DebugSetSourceFile() {
        super(1, DebugElementType.SET_SOURCE_FILE);
        this.addChild(1, this.mName);
    }

    @Override
    public boolean isValid() {
        return this.mName.getItem() != null;
    }

    public String getName() {
        StringId stringId = (StringId)this.mName.getItem();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public StringKey getNameKey() {
        return (StringKey)this.mName.getKey();
    }

    public void setName(String name) {
        this.mName.setItem(StringKey.create(name));
    }

    public void setName(StringKey key) {
        this.mName.setItem(key);
    }

    public DebugElementType<DebugSetSourceFile> getElementType() {
        return DebugElementType.SET_SOURCE_FILE;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.mName.getItem());
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugSetSourceFile coming = (DebugSetSourceFile)element;
        this.mName.setItem(coming.mName.getKey());
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mName;
    }
}

