/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.FixedDexContainer;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.debug.DebugAdvance;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugEndSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class DebugSequence
extends FixedDexContainer
implements Iterable<DebugElement> {
    private final IntegerReference lineStart;
    private BlockList<DebugElement> elementList;

    public DebugSequence(IntegerReference lineStart) {
        super(2);
        this.lineStart = lineStart;
        this.addChild(1, DebugEndSequence.INSTANCE);
    }

    public <T1 extends DebugElement> T1 getOrCreateAtAddress(DebugElementType<T1> elementType, int address) {
        Block prev = null;
        Iterator<T1> iterator = this.iterator(elementType);
        while (iterator.hasNext()) {
            DebugElement element = (DebugElement)iterator.next();
            int a = element.getTargetAddress();
            if (a == address) {
                return (T1)element;
            }
            if (a > address) break;
            prev = element;
        }
        int index = 0;
        if (prev != null) {
            index = prev.getIndex() + 1;
        }
        T1 element = this.createAtPosition(elementType, index);
        ((DebugElement)element).setTargetAddress(address);
        return element;
    }

    public Iterator<DebugElement> getAtAddress(int address) {
        return FilterIterator.of(this.iterator(), element -> address == element.getTargetAddress());
    }

    public void removeInvalid() {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            DebugElement element = this.get(i);
            if (element.isValid()) continue;
            this.remove(element);
        }
    }

    public int getLineStart() {
        return this.lineStart.get();
    }

    public void setLineStart(int start) {
        if (start == this.getLineStart()) {
            return;
        }
        this.setLineStartInternal(start);
        this.cacheValues();
    }

    void setLineStartInternal(int start) {
        this.lineStart.set(start);
    }

    public Iterator<DebugElement> getExtraLines() {
        return new FilterIterator<DebugElement>(this.iterator(), element -> !(element instanceof DebugAdvance));
    }

    public void fixDebugLineNumbers() {
        Predicate<DebugElement> filter = new Predicate<DebugElement>(){
            DebugElement previous = null;

            @Override
            public boolean test(DebugElement element) {
                if (element.getElementType() != DebugElementType.LINE_NUMBER) {
                    return false;
                }
                if (this.previous != null && this.previous.getTargetAddress() == element.getTargetAddress()) {
                    this.previous = element;
                    return true;
                }
                this.previous = element;
                return false;
            }
        };
        this.removeAll((Predicate<? super DebugElement>)filter);
    }

    public boolean removeInvalid(InstructionList instructionList) {
        return this.removeAll(element -> element.getElementType() == DebugElementType.LINE_NUMBER && instructionList.getAtAddress(element.getTargetAddress()) == null);
    }

    public boolean removeAll(Predicate<? super DebugElement> filter) {
        boolean removedOnce = false;
        Iterator<? super DebugElement> iterator = FilterIterator.of(this.clonedIterator(), filter);
        while (iterator.hasNext()) {
            boolean removed = this.removeInternal(iterator.next());
            if (!removed) continue;
            removedOnce = true;
        }
        if (removedOnce) {
            this.updateValues();
        }
        return removedOnce;
    }

    public boolean remove(DebugElement element) {
        if (element == null || element.getParent(this.getClass()) != this) {
            return false;
        }
        boolean removed = this.removeInternal(element);
        if (removed) {
            this.updateValues();
        }
        return removed;
    }

    private boolean removeInternal(DebugElement element) {
        element.onPreRemove(this);
        boolean removed = this.getElementList().remove(element);
        if (removed) {
            element.setParent(null);
            element.setIndex(-1);
        }
        return removed;
    }

    public <T1 extends DebugElement> T1 createAtPosition(DebugElementType<T1> type, int index) {
        Block element = type.newInstance();
        this.add(index, (DebugElement)element);
        return (T1)element;
    }

    public <T1 extends DebugElement> T1 createNext(DebugElementType<T1> type) {
        if (type == DebugElementType.END_SEQUENCE) {
            return (T1)DebugEndSequence.INSTANCE;
        }
        Block element = type.newInstance();
        this.add((DebugElement)element);
        return (T1)element;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int position = reader.getPosition();
        int count = 0;
        while (reader.read() != 0) {
            ++count;
        }
        if (count == 0) {
            return;
        }
        reader.seek(position);
        BlockList<DebugElement> elementList = this.unlockElementList();
        this.unlockElementList().ensureCapacity(count);
        DebugElementType<DebugEndSequence> type = this.readNext(reader);
        while (!type.is(DebugElementType.END_SEQUENCE)) {
            type = this.readNext(reader);
        }
        elementList.trimToSize();
        this.cacheValues();
    }

    private DebugElementType<?> readNext(BlockReader reader) throws IOException {
        Block debugElement;
        DebugElementType<?> type = DebugElementType.readFlag(reader);
        if (type == DebugElementType.END_SEQUENCE) {
            debugElement = DebugEndSequence.INSTANCE;
        } else {
            debugElement = type.newInstance();
            this.unlockElementList().add((DebugElement)debugElement);
        }
        debugElement.readBytes(reader);
        return type;
    }

    private void cacheValues() {
        DebugElement previous = null;
        for (DebugElement element : this) {
            element.cacheValues(this, previous);
            previous = element;
        }
    }

    private void updateValues() {
        DebugElement previous = null;
        Iterator<DebugElement> iterator = this.clonedIterator();
        while (iterator.hasNext()) {
            DebugElement element = iterator.next();
            element.updateValues(this, previous);
            previous = element;
        }
    }

    public DebugElement get(int i) {
        return this.getElementList().get(i);
    }

    public void add(int i, DebugElement element) {
        this.unlockElementList().add(i, element);
    }

    public <T1 extends DebugElement> Iterator<T1> iterator(DebugElementType<T1> type) {
        return ComputeIterator.of(this.iterator(), element -> {
            if (element.getElementType() == type) {
                return element;
            }
            return null;
        });
    }

    public int size() {
        return this.getElementList().getCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<DebugElement> iterator() {
        return this.getElementList().iterator();
    }

    public Iterator<DebugElement> clonedIterator() {
        return this.getElementList().clonedIterator();
    }

    public boolean add(DebugElement element) {
        if (element == null || element.getClass() == DebugEndSequence.class) {
            return false;
        }
        return this.unlockElementList().add(element);
    }

    public void clear() {
        this.getElementList().clearChildes();
    }

    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DebugElement, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(DebugElement element) {
                return element.usedIds();
            }
        };
    }

    private BlockList<DebugElement> unlockElementList() {
        BlockList<DebugElement> elementList = this.elementList;
        if (elementList == null || BlockList.isImmutableEmpty(elementList)) {
            this.elementList = elementList = new BlockList();
            this.addChild(0, elementList);
        }
        return elementList;
    }

    private BlockList<DebugElement> getElementList() {
        BlockList<DebugElement> elementList = this.elementList;
        if (elementList == null) {
            elementList = BlockList.empty();
        }
        return elementList;
    }

    public void merge(DebugSequence sequence) {
        this.lineStart.set(sequence.lineStart.get());
        int size = sequence.size();
        if (size == 0) {
            return;
        }
        this.unlockElementList().ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            DebugElement coming = sequence.get(i);
            Object element = this.createNext(coming.getElementType());
            ((DebugElement)element).merge(coming);
        }
        this.cacheValues();
        this.getElementList().trimToSize();
    }

    public void fromSmali(SmaliMethod smaliMethod) throws IOException {
        Iterator<SmaliDebug> iterator = smaliMethod.getDebugs();
        while (iterator.hasNext()) {
            SmaliDebug smaliDebug = iterator.next();
            DebugElementType<?> type = smaliDebug.getDebugElementType();
            if (type == null) continue;
            ((DebugElement)this.createNext(type)).fromSmali(smaliDebug);
        }
    }

    public int hashCode() {
        return this.getElementList().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugSequence sequence = (DebugSequence)obj;
        return this.getElementList().equals(sequence.getElementList());
    }

    public String toString() {
        return "start=" + this.lineStart + ", elements=" + this.getElementList();
    }
}

