/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDebugRegister;
import java.io.IOException;

abstract class DebugRegisterNumber
extends DebugElement {
    private final Ule128Item registerNumber = new Ule128Item();

    DebugRegisterNumber(int childesCount, int flag) {
        super(childesCount + 1, flag);
        this.addChild(1, this.registerNumber);
    }

    DebugRegisterNumber(int childesCount, DebugElementType<?> elementType) {
        this(childesCount, elementType.getFlag());
    }

    public int getRegisterNumber() {
        return this.registerNumber.get();
    }

    public void setRegister(int register) {
        this.registerNumber.set(register);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendRegister(this.getRegisterNumber());
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugRegisterNumber coming = (DebugRegisterNumber)element;
        this.registerNumber.set(coming.registerNumber.get());
    }

    @Override
    public void fromSmali(SmaliDebug smaliDebug) throws IOException {
        super.fromSmali(smaliDebug);
        SmaliDebugRegister smaliDebugRegister = (SmaliDebugRegister)smaliDebug;
        this.setRegister(smaliDebugRegister.getRegister().getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugRegisterNumber debug = (DebugRegisterNumber)obj;
        return this.getFlag() == debug.getFlag() && this.registerNumber.get() == debug.registerNumber.get();
    }

    @Override
    public int hashCode() {
        int hash = this.getFlag();
        hash = hash * 31 + this.registerNumber.get();
        return hash;
    }

    @Override
    public String toString() {
        return this.getElementType() + " v" + this.getRegisterNumber();
    }
}

