/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class DebugParameter
extends Base1Ule128IdItemReference<StringId>
implements SmaliFormat {
    public DebugParameter() {
        super(SectionType.STRING_ID);
    }

    public String getName() {
        StringId stringId = this.getNameId();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            this.setItem((StringId)null);
        } else {
            this.setItem(new StringKey(name));
        }
    }

    public StringId getNameId() {
        return (StringId)this.getItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        StringId stringId = this.getNameId();
        if (stringId == null) {
            return;
        }
        writer.append(", ");
        stringId.append(writer);
    }

    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getItem());
    }

    public void merge(DebugParameter parameter) {
        this.setItem(parameter.getKey());
    }

    @Override
    public String toString() {
        if (this.getItem() == null) {
            return super.toString();
        }
        return ".param p **, \"" + this.getNameId() + "\"";
    }
}

