/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.ShortList;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Iterator;

public class TypeList
extends ShortList
implements KeyItemCreate,
SmaliFormat,
Iterable<TypeId>,
Comparable<TypeList> {
    private TypeId[] typeIds;

    @Override
    public TypeListKey getKey() {
        return this.checkKey(TypeListKey.create(this));
    }

    @Override
    public void setKey(Key key) {
        this.setKey((TypeListKey)key);
    }

    public void setKey(TypeListKey key) {
        TypeListKey old = this.getKey();
        if (key.equals(old)) {
            return;
        }
        String[] names = key.getParameterNames();
        if (names == null) {
            this.setSize(0);
            return;
        }
        this.setSize(0);
        DexSectionPool<TypeId> pool = this.getOrCreatePool(SectionType.TYPE_ID);
        for (String name : names) {
            TypeId typeId = pool.getOrCreate(TypeKey.create(name));
            this.add(typeId);
        }
        this.keyChanged(old);
    }

    public SectionType<TypeList> getSectionType() {
        return SectionType.TYPE_LIST;
    }

    public void addAll(Iterator<String> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(Iterator<TypeKey> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(String typeName) {
        this.add(TypeKey.create(typeName));
    }

    public void add(TypeKey typeKey) {
        if (typeKey != null) {
            TypeId typeId = this.getOrCreateSectionItem(SectionType.TYPE_ID, typeKey);
            this.add(typeId);
        }
    }

    public void add(TypeId typeId) {
        if (typeId != null) {
            this.add(typeId.getIdx());
        } else {
            this.add(0);
        }
    }

    public boolean remove(TypeId typeId) {
        if (typeId != null) {
            return this.remove(this.indexOf(typeId.getIdx()));
        }
        return false;
    }

    public boolean remove(TypeKey typeKey) {
        return this.remove(this.get(typeKey));
    }

    public Iterator<TypeKey> getTypeKeys() {
        return ComputeIterator.of(this.iterator(), TypeId::getKey);
    }

    public Iterator<String> getTypeNames() {
        return ComputeIterator.of(this.iterator(), TypeId::getName);
    }

    @Override
    public Iterator<TypeId> iterator() {
        return ArrayIterator.of(this.getTypeIds());
    }

    @Override
    public int size() {
        return super.size();
    }

    public boolean contains(TypeKey typeKey) {
        if (typeKey != null) {
            for (TypeId typeId : this) {
                if (!typeKey.equals(typeId.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public TypeId get(TypeKey typeKey) {
        if (typeKey != null) {
            for (TypeId typeId : this) {
                if (!typeKey.equals(typeId.getKey())) continue;
                return typeId;
            }
        }
        return null;
    }

    public TypeId[] getTypeIds() {
        return this.typeIds;
    }

    public String[] getNames() {
        TypeId[] typeIds = this.getTypeIds();
        if (typeIds == null) {
            return null;
        }
        int length = typeIds.length;
        String[] results = new String[length];
        for (int i = 0; i < length; ++i) {
            results[i] = typeIds[i].getName();
        }
        return results;
    }

    public TypeId getTypeId(int index) {
        TypeId[] typeIds = this.getTypeIds();
        if (typeIds != null && index >= 0 && index < typeIds.length) {
            return typeIds[index];
        }
        return null;
    }

    public TypeId getTypeIdForRegister(int register) {
        TypeId[] typeIds = this.getTypeIds();
        if (typeIds == null) {
            return null;
        }
        int count = 0;
        for (TypeId typeId : typeIds) {
            if (count == register) {
                return typeId;
            }
            ++count;
            if (!typeId.isWide()) continue;
            ++count;
        }
        return null;
    }

    public int getParameterRegistersCount() {
        TypeId[] typeIds = this.getTypeIds();
        int count = 0;
        if (typeIds != null) {
            for (TypeId typeId : typeIds) {
                ++count;
                if (!typeId.isWide()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    void onChanged() {
        this.cacheTypeIds();
    }

    private void cacheTypeIds() {
        this.typeIds = (TypeId[])this.getSectionItem(SectionType.TYPE_ID, this.toArray());
        if (this.typeIds == null) {
            return;
        }
        for (TypeId typeId : this.typeIds) {
            typeId.addUsageType(UsageMarker.USAGE_INTERFACE);
        }
    }

    @Override
    protected void onPreRefresh() {
        this.refreshTypeIds();
    }

    private void refreshTypeIds() {
        TypeId[] typeIds = this.getTypeIds();
        if (typeIds == null) {
            this.setSize(0);
            return;
        }
        int length = typeIds.length;
        this.setSize(length, false);
        for (int i = 0; i < length; ++i) {
            TypeId typeId;
            typeIds[i] = typeId = (TypeId)typeIds[i].getReplace();
            typeId.addUsageType(UsageMarker.USAGE_INTERFACE);
            this.put(i, typeIds[i].getIdx());
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        for (TypeId typeId : this) {
            typeId.append(writer);
        }
    }

    public void appendInterfaces(SmaliWriter writer) throws IOException {
        SmaliDirective smaliDirective = null;
        for (TypeId typeId : this) {
            writer.newLine();
            if (smaliDirective == null) {
                writer.appendComment("interfaces");
                writer.newLine();
                smaliDirective = SmaliDirective.IMPLEMENTS;
            }
            smaliDirective.append(writer);
            typeId.append(writer);
        }
        if (smaliDirective != null) {
            writer.newLine();
        }
    }

    @Override
    public int compareTo(TypeList typeList) {
        if (typeList == null) {
            return -1;
        }
        return SectionTool.compareIdx(this.iterator(), typeList.iterator());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TypeId typeId : this) {
            builder.append(typeId);
        }
        return builder.toString();
    }

    public static boolean equals(TypeList typeList1, TypeList typeList2) {
        if (typeList1 == typeList2) {
            return true;
        }
        if (typeList1 == null) {
            return false;
        }
        return CompareUtil.compare(typeList1.getNames(), typeList2.getNames()) == 0;
    }
}

