/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.io.ByteReader;
import com.reandroid.dex.io.StreamUtil;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.io.OutputStream;

public class StringData
extends DataItem
implements SmaliFormat,
BlockRefresh,
OffsetSupplier,
OffsetReceiver,
Comparable<StringData> {
    private static final String EMPTY_STRING = StringsUtil.EMPTY;
    private final StringDataContainer mDataContainer = new StringDataContainer(this);
    private String mCache;
    private StringKey mKey;

    public StringData() {
        super(1);
        this.addChild(0, this.mDataContainer);
        this.mCache = EMPTY_STRING;
    }

    @Override
    public void removeSelf() {
        throw new DexException("Remove STRING_ID first before STRING_DATA");
    }

    public void removeSelf(StringId request) {
        if (request != null && request.getParent() != null) {
            super.removeSelf();
        }
    }

    @Override
    public StringKey getKey() {
        return this.mKey;
    }

    public void setKey(Key key) {
        StringKey stringKey = (StringKey)key;
        String text = null;
        if (stringKey != null) {
            text = stringKey.getString();
        }
        this.setString(text);
    }

    public SectionType<StringData> getSectionType() {
        return SectionType.STRING_DATA;
    }

    public String getString() {
        return this.mCache;
    }

    public void setString(String value) {
        if (this.mCache.equals(value) && this.mKey != null) {
            return;
        }
        if (value == null || value.length() == 0) {
            value = EMPTY_STRING;
        }
        this.mCache = value;
        this.encodeString(value);
        StringKey key = value.length() == 0 ? StringKey.EMPTY : new StringKey(value);
        this.mKey = key;
    }

    public String getQuotedString() {
        return DexUtils.quoteString(this.getString());
    }

    void onStringBytesChanged() {
        String cache = this.decodeString();
        StringKey key = cache.length() == 0 ? StringKey.EMPTY : new StringKey(cache);
        this.mKey = key;
    }

    @Override
    public int countBytes() {
        return this.mDataContainer.countBytes();
    }

    @Override
    public byte[] getBytes() {
        return this.mDataContainer.getBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        counter.addCount(this.countBytes());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (reader.available() < 4) {
            return;
        }
        int position = reader.getPosition();
        String text = StringData.decodeString(StreamUtil.createByteReader(reader));
        if (text.length() == 0) {
            text = EMPTY_STRING;
        }
        int length = reader.getPosition() - position;
        reader.seek(position);
        this.mDataContainer.setLength(length + 1);
        byte[] bytes = this.mDataContainer.getBytesInternal();
        reader.readFully(bytes);
        this.mCache = text;
        StringKey key = text.length() == 0 ? StringKey.EMPTY : new StringKey(text);
        this.mKey = key;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        return this.mDataContainer.onWriteBytes(stream);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        DexUtils.appendQuotedString(writer, this.getString());
    }

    @Override
    public int compareTo(StringData stringData) {
        if (stringData == null) {
            return -1;
        }
        if (stringData == this) {
            return 0;
        }
        return this.getString().compareTo(stringData.getString());
    }

    public String toString() {
        String text = this.getString();
        if (text != null) {
            return text;
        }
        return "NULL";
    }

    private String decodeString() {
        String text;
        try {
            text = StringData.decodeString(StreamUtil.createByteReader(this.mDataContainer.getBytesInternal()));
        }
        catch (IOException exception) {
            text = null;
        }
        return text;
    }

    private void encodeString(String text) {
        int length = text.length();
        this.mDataContainer.setLength(length * 3 + 4);
        byte[] buffer = this.mDataContainer.getBytesInternal();
        int position = DexBlockItem.writeUleb128(buffer, 0, length);
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch != '\u0000' && ch < '\u0080') {
                buffer[position++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buffer[position++] = (byte)(ch >> 6 & 0x1F | 0xC0);
                buffer[position++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            buffer[position++] = (byte)(ch >> 12 & 0xF | 0xE0);
            buffer[position++] = (byte)(ch >> 6 & 0x3F | 0x80);
            buffer[position++] = (byte)(ch & 0x3F | 0x80);
        }
        buffer[position++] = 0;
        this.mDataContainer.setLength(position);
    }

    private static String decodeString(ByteReader reader) throws IOException {
        int utf16Length;
        char[] chars = new char[utf16Length];
        int outAt = 0;
        int at = 0;
        for (utf16Length = DexBlockItem.readUleb128(reader); utf16Length > 0; --utf16Length) {
            char out;
            int v0 = reader.read();
            switch (v0 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (v0 == 0) {
                        return StringData.throwBadUtf8(v0, at);
                    }
                    out = (char)v0;
                    ++at;
                    break;
                }
                case 12: 
                case 13: {
                    int v1 = reader.read() & 0xFF;
                    if ((v1 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    int value = (v0 & 0x1F) << 6 | v1 & 0x3F;
                    if (value != 0 && value < 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    out = (char)value;
                    at += 2;
                    break;
                }
                case 14: {
                    int v1 = reader.read();
                    if ((v1 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v1, at + 1);
                    }
                    int v2 = reader.read();
                    if ((v2 & 0xC0) != 128) {
                        return StringData.throwBadUtf8(v2, at + 2);
                    }
                    int value = (v0 & 0xF) << 12 | (v1 & 0x3F) << 6 | v2 & 0x3F;
                    if (value < 2048) {
                        return StringData.throwBadUtf8(v2, at + 2);
                    }
                    out = (char)value;
                    at += 3;
                    break;
                }
                default: {
                    return StringData.throwBadUtf8(v0, at);
                }
            }
            chars[outAt] = out;
            ++outAt;
        }
        return new String(chars, 0, outAt);
    }

    private static String throwBadUtf8(int value, int offset) throws IOException {
        throw new IOException("bad utf-8 byte " + HexUtil.toHex2("", (byte)value) + " at offset " + offset);
    }

    public static boolean equals(StringData stringData1, StringData stringData2) {
        return CompareUtil.compare(stringData1, stringData2) == 0;
    }

    static class StringDataContainer
    extends BlockItem {
        private final StringData stringData;

        StringDataContainer(StringData stringData) {
            super(0);
            this.stringData = stringData;
        }

        void setLength(int length) {
            this.setBytesLength(length, false);
        }

        @Override
        public byte[] getBytesInternal() {
            return super.getBytesInternal();
        }

        @Override
        protected void onBytesChanged() {
            this.stringData.onStringBytesChanged();
        }

        @Override
        public int onWriteBytes(OutputStream stream) throws IOException {
            return super.onWriteBytes(stream);
        }
    }
}

