/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.FieldDefArray;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.value.BooleanValue;
import com.reandroid.dex.value.ByteValue;
import com.reandroid.dex.value.CharValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DoubleValue;
import com.reandroid.dex.value.FloatValue;
import com.reandroid.dex.value.IntValue;
import com.reandroid.dex.value.LongValue;
import com.reandroid.dex.value.NullValue;
import com.reandroid.dex.value.ShortValue;

public class StaticFieldDefArray
extends FieldDefArray {
    private boolean mValuesLinked;

    public StaticFieldDefArray(IntegerReference itemCount) {
        super(itemCount);
    }

    @Override
    public boolean remove(FieldDef fieldDef) {
        EncodedArray encodedArray = this.getUniqueStaticValues();
        DexValueBlock<?> value = fieldDef.getStaticInitialValue();
        fieldDef.holdStaticInitialValue(value);
        boolean removed = super.remove(fieldDef);
        if (value != null && encodedArray != null) {
            encodedArray.remove(value);
        }
        return removed;
    }

    @Override
    void onPreSort() {
        super.onPreSort();
        this.holdStaticValues(this.getUniqueStaticValues());
    }

    @Override
    void onPostSort() {
        super.onPostSort();
        this.sortStaticValues();
    }

    private void sortStaticValues() {
        EncodedArray encodedArray = this.getUniqueStaticValues();
        if (encodedArray == null) {
            return;
        }
        encodedArray.removeAll();
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            FieldDef def = (FieldDef)this.get(i);
            assert (def != null);
            DexValueBlock<?> valueBlock = def.getStaticInitialValue();
            if (valueBlock == null) continue;
            this.ensureArraySize(encodedArray, i + 1);
            encodedArray.set(i, valueBlock);
        }
        encodedArray.trimNull();
    }

    private void ensureArraySize(EncodedArray encodedArray, int size) {
        int arraySize = encodedArray.size();
        if (size <= arraySize) {
            return;
        }
        for (int i = arraySize; i < size; ++i) {
            FieldDef def = (FieldDef)this.get(i);
            assert (def != null);
            TypeKey typeKey = def.getKey().getType();
            encodedArray.add(StaticFieldDefArray.createFor(typeKey));
        }
    }

    private EncodedArray getUniqueStaticValues() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getUniqueStaticValues();
        }
        return null;
    }

    private EncodedArray getStaticValues() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getStaticValues();
        }
        return null;
    }

    @Override
    public void setClassId(ClassId classId) {
        if (this.getClassId() != classId) {
            this.mValuesLinked = false;
        }
        super.setClassId(classId);
        if (!this.mValuesLinked) {
            this.holdStaticValues(this.getStaticValues());
        }
    }

    private void holdStaticValues() {
        this.holdStaticValues(this.getUniqueStaticValues());
    }

    private void holdStaticValues(EncodedArray encodedArray) {
        if (encodedArray == null) {
            return;
        }
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            FieldDef def = (FieldDef)this.get(i);
            DexValueBlock<?> valueBlock = encodedArray.get(i);
            assert (def != null);
            def.holdStaticInitialValue(valueBlock);
        }
        if (count != 0) {
            this.mValuesLinked = true;
        }
    }

    @Override
    public void merge(DefArray<?> defArray) {
        super.merge(defArray);
        this.holdStaticValues();
    }

    private static DexValueBlock<?> createFor(TypeKey typeKey) {
        DexValueBlock valueBlock;
        if (typeKey.isTypeArray() || !typeKey.isPrimitive()) {
            valueBlock = NullValue.PLACE_HOLDER;
        } else if (TypeKey.TYPE_I.equals(typeKey)) {
            valueBlock = new IntValue();
        } else if (TypeKey.TYPE_J.equals(typeKey)) {
            valueBlock = new LongValue();
        } else if (TypeKey.TYPE_D.equals(typeKey)) {
            valueBlock = new DoubleValue();
        } else if (TypeKey.TYPE_F.equals(typeKey)) {
            valueBlock = new FloatValue();
        } else if (TypeKey.TYPE_S.equals(typeKey)) {
            valueBlock = new ShortValue();
        } else if (TypeKey.TYPE_B.equals(typeKey)) {
            valueBlock = new ByteValue();
        } else if (TypeKey.TYPE_C.equals(typeKey)) {
            valueBlock = new CharValue();
        } else if (TypeKey.TYPE_Z.equals(typeKey)) {
            valueBlock = new BooleanValue();
        } else {
            throw new IllegalArgumentException("Undefined: " + typeKey);
        }
        valueBlock.setTemporary(true);
        return valueBlock;
    }
}

