/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.item.ShortArrayBlock;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.data.IntegerList;
import com.reandroid.utils.HexUtil;

public class ShortList
extends IntegerList
implements PositionAlignedItem {
    public ShortList() {
        super(0, new ShortArrayBlock(), new DexPositionAlign());
    }

    @Override
    public void put(int index, int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new DexException("Short value out of range " + HexUtil.toHex(value, 4) + " > 0xffff");
        }
        super.put(index, value);
    }

    @Override
    public String toString() {
        DexPositionAlign dexPositionAlign = this.getPositionAlign();
        if (dexPositionAlign.size() > 0) {
            return super.toString() + dexPositionAlign;
        }
        return super.toString();
    }
}

