/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.data.AnnotationGroup;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.data.DirectoryEntry;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.debug.DebugParameter;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.DataItemUle128Reference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class MethodDef
extends Def<MethodId> {
    private final DataItemUle128Reference<CodeItem> codeOffset = new DataItemUle128Reference<CodeItem>(SectionType.CODE, UsageMarker.USAGE_DEFINITION);

    public MethodDef() {
        super(1, SectionType.METHOD_ID);
        this.addChild(2, this.codeOffset);
    }

    public boolean isBridge() {
        return AccessFlag.BRIDGE.isSet(this.getAccessFlagsValue());
    }

    @Override
    public boolean isDirect() {
        return this.isConstructor() || this.isPrivate() || this.isStatic();
    }

    public String getName() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (Objects.equals(this.getName(), name)) {
            return;
        }
        ((MethodId)this.getId()).setName(name);
    }

    public int getParametersCount() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getParametersCount();
        }
        return 0;
    }

    public int getParameterRegistersCount() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            int count = methodId.getParameterRegistersCount();
            if (!this.isStatic()) {
                ++count;
            }
            return count;
        }
        return 0;
    }

    public Parameter getParameter(int index) {
        if (index < 0 || index >= this.getParametersCount()) {
            return null;
        }
        return new Parameter(this, index);
    }

    public Iterator<Parameter> getParameters() {
        if (this.getParametersCount() == 0) {
            return EmptyIterator.of();
        }
        return ArraySupplierIterator.of(new ArraySupplier<Parameter>(){

            @Override
            public Parameter get(int i) {
                return MethodDef.this.getParameter(i);
            }

            @Override
            public int getCount() {
                return MethodDef.this.getParametersCount();
            }
        });
    }

    @Override
    public MethodKey getKey() {
        return (MethodKey)super.getKey();
    }

    @Override
    void onRemove() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.setMethodDef(null);
            this.codeOffset.setItem((CodeItem)null);
        }
        super.onRemove();
    }

    public void removeParameter(int index) {
        Parameter parameter = this.getParameter(index);
        if (parameter == null) {
            return;
        }
        parameter.remove();
        MethodKey methodKey = this.getKey();
        if (methodKey == null) {
            return;
        }
        methodKey = methodKey.removeParameter(index);
        this.setItem(methodKey);
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.setDebugInfo(debugInfo);
        }
    }

    public DebugInfo getDebugInfo() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getDebugInfo();
        }
        return null;
    }

    public DebugInfo getUniqueDebugInfo() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getDebugInfo();
        }
        return null;
    }

    public DebugInfo getOrCreateDebugInfo() {
        return this.getOrCreateCodeItem().getOrCreateDebugInfo();
    }

    public ProtoId getProtoId() {
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return methodId.getProto();
        }
        return null;
    }

    public Iterator<Ins> getInstructions() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.clonedIterator();
        }
        return EmptyIterator.of();
    }

    public Ins getInstruction(int i) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.get(i);
        }
        return null;
    }

    public Ins getInstructionAt(int address) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getAtAddress(address);
        }
        return null;
    }

    public int getInstructionsCount() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getCount();
        }
        return 0;
    }

    public InstructionList getOrCreateInstructionList() {
        return this.getOrCreateCodeItem().getInstructionList();
    }

    public InstructionList getInstructionList() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getInstructionList();
        }
        return null;
    }

    public TryBlock getTryBlock() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            return codeItem.getTryBlock();
        }
        return null;
    }

    public TryBlock getOrCreateTryBlock() {
        return this.getOrCreateCodeItem().getOrCreateTryBlock();
    }

    public CodeItem getOrCreateCodeItem() {
        CodeItem current = (CodeItem)this.codeOffset.getItem();
        CodeItem codeItem = this.codeOffset.getOrCreateUniqueItem(this);
        if (current == null) {
            codeItem.setMethodDef(this);
            int registers = this.getParameterRegistersCount();
            codeItem.setRegistersCount(registers);
            codeItem.setParameterRegistersCount(registers);
        }
        return codeItem;
    }

    public CodeItem getCodeItem() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.setMethodDef(this);
        }
        return codeItem;
    }

    public void clearCode() {
        this.codeOffset.setItem((CodeItem)null);
    }

    public void clearDebug() {
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.removeDebugInfo();
        }
    }

    private void linkCodeItem() {
        CodeItem codeItem = (CodeItem)this.codeOffset.getItem();
        if (codeItem != null) {
            codeItem.addUniqueUser(this);
            codeItem.setMethodDef(this);
        }
    }

    public Iterator<AnnotationGroup> getParameterAnnotations() {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            return directory.getParameterAnnotation(this);
        }
        return EmptyIterator.of();
    }

    public Iterator<AnnotationSet> getParameterAnnotations(int parameterIndex) {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory == null) {
            return EmptyIterator.of();
        }
        return directory.getParameterAnnotation(this.getDefinitionIndex(), parameterIndex);
    }

    @Override
    public Iterator<? extends Modifier> getAccessFlags() {
        return AccessFlag.valuesOfMethod(this.getAccessFlagsValue());
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.linkCodeItem();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.onWriteMethod(this.getKey());
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.appendModifiers(this.getModifiers());
        ((MethodId)this.getId()).append(writer, false);
        writer.indentPlus();
        if (!writer.appendOptional(this.getCodeItem())) {
            writer.appendAllWithDoubleNewLine(this.getParameters());
            writer.appendAllWithDoubleNewLine(this.getAnnotations());
        }
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void replaceKeys(Key search, Key replace) {
        super.replaceKeys(search, replace);
        CodeItem codeItem = this.getCodeItem();
        if (codeItem != null) {
            codeItem.replaceKeys(search, replace);
        }
    }

    @Override
    public void edit() {
        CodeItem codeItem = this.codeOffset.getUniqueItem(this);
        if (codeItem != null) {
            codeItem.setMethodDef(this);
            codeItem.edit();
        }
    }

    @Override
    public void editInternal(Block user) {
        this.edit();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        CodeItem codeItem = this.getCodeItem();
        Iterator<Object> iterator = codeItem == null ? EmptyIterator.of() : codeItem.usedIds();
        return CombiningIterator.singleOne(this.getId(), iterator);
    }

    @Override
    public void merge(Def<?> def) {
        super.merge(def);
        MethodDef comingMethod = (MethodDef)def;
        CodeItem comingCode = comingMethod.getCodeItem();
        if (comingCode != null) {
            this.codeOffset.setItem(comingCode.getKey());
        }
    }

    public void fromSmali(SmaliMethod smaliMethod) throws IOException {
        this.setKey(smaliMethod.getKey());
        this.setAccessFlagsValue(smaliMethod.getAccessFlagsValue());
        if (smaliMethod.hasInstructions()) {
            this.getOrCreateCodeItem().fromSmali(smaliMethod);
        }
        if (smaliMethod.hasAnnotation()) {
            AnnotationSet annotationSet = this.getOrCreateSection(SectionType.ANNOTATION_SET).createItem();
            annotationSet.fromSmali(smaliMethod.getAnnotation());
            this.addAnnotationSet(annotationSet);
        }
        Iterator<SmaliMethodParameter> iterator = smaliMethod.getParameters();
        while (iterator.hasNext()) {
            SmaliMethodParameter smaliMethodParameter = iterator.next();
            int index = smaliMethodParameter.getDefinitionIndex();
            if (index < 0) {
                MethodKey methodKey = smaliMethod.getKey();
                throw new RuntimeException("Parameter out of range, class = " + methodKey.getDeclaring() + ", method = " + methodKey.getName() + methodKey.getProtoKey() + "\n" + smaliMethodParameter);
            }
            Parameter parameter = this.getParameter(index);
            parameter.fromSmali(smaliMethodParameter);
        }
        this.linkCodeItem();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.METHOD;
    }

    public String toString() {
        if (this.isReading()) {
            return this.getSmaliDirective() + " " + this.getKey();
        }
        MethodId methodId = (MethodId)this.getId();
        if (methodId != null) {
            return this.getSmaliDirective() + " " + Modifier.toString(this.getAccessFlags()) + " " + methodId.toString();
        }
        return this.getSmaliDirective() + " " + Modifier.toString(this.getAccessFlags()) + " " + this.getRelativeIdValue();
    }

    public static class Parameter
    implements DefIndex,
    SmaliRegion {
        private final MethodDef methodDef;
        private final int index;

        public Parameter(MethodDef methodDef, int index) {
            this.methodDef = methodDef;
            this.index = index;
        }

        public void remove() {
            this.clearAnnotations();
            this.clearDebugParameter();
        }

        public void clearAnnotations() {
            AnnotationsDirectory directory = this.methodDef.getUniqueAnnotationsDirectory();
            if (directory == null || !this.hasAnnotations()) {
                return;
            }
            Iterator<DirectoryEntry<MethodDef, AnnotationGroup>> iterator = directory.getParameterEntries(this.methodDef);
            int index = this.getDefinitionIndex();
            while (iterator.hasNext()) {
                DirectoryEntry<MethodDef, AnnotationGroup> entry = iterator.next();
                AnnotationGroup group = entry.getValue();
                if (group == null || group.getItem(index) == null) continue;
                AnnotationGroup update = group.getSection(SectionType.ANNOTATION_GROUP).createItem();
                entry.setValue(update);
                update.put(index, 0);
                update.refresh();
            }
        }

        public boolean hasAnnotations() {
            return this.getAnnotations().hasNext();
        }

        public Iterator<AnnotationItem> getAnnotationItems() {
            return ExpandIterator.of(this.getAnnotations());
        }

        public Iterator<AnnotationSet> getAnnotations() {
            AnnotationsDirectory directory = this.methodDef.getAnnotationsDirectory();
            if (directory != null) {
                return directory.getParameterAnnotation(this.methodDef, this.getDefinitionIndex());
            }
            return EmptyIterator.of();
        }

        public AnnotationItem addAnnotationItem(TypeKey typeKey) {
            return this.getOrCreateAnnotationSet().addNewItem(typeKey);
        }

        public AnnotationItem getOrCreateAnnotationItem(TypeKey typeKey) {
            return this.getOrCreateAnnotationSet().getOrCreate(typeKey);
        }

        public AnnotationSet getOrCreateAnnotationSet() {
            AnnotationsDirectory directory = this.methodDef.getOrCreateUniqueAnnotationsDirectory();
            return directory.getOrCreateParameterAnnotation(this.methodDef, this.getDefinitionIndex());
        }

        public AnnotationSet addNewAnnotationSet() {
            AnnotationsDirectory directory = this.methodDef.getOrCreateUniqueAnnotationsDirectory();
            return directory.createNewParameterAnnotation(this.methodDef, this.getDefinitionIndex());
        }

        public TypeKey getType() {
            TypeId typeId = this.getTypeId();
            if (typeId != null) {
                return typeId.getKey();
            }
            return null;
        }

        public TypeId getTypeId() {
            ProtoId protoId = this.methodDef.getProtoId();
            if (protoId != null) {
                return protoId.getParameter(this.getDefinitionIndex());
            }
            return null;
        }

        @Override
        public int getDefinitionIndex() {
            return this.index;
        }

        public int getRegister() {
            MethodDef methodDef = this.methodDef;
            int reg = methodDef.isStatic() ? 0 : 1;
            return reg += methodDef.getKey().getRegister(this.getDefinitionIndex());
        }

        public void clearDebugParameter() {
            DebugInfo debugInfo = this.methodDef.getDebugInfo();
            if (debugInfo != null) {
                debugInfo.removeDebugParameter(this.getDefinitionIndex());
            }
        }

        public String getDebugName() {
            DebugParameter debugParameter = this.getDebugParameter();
            if (debugParameter != null) {
                return debugParameter.getName();
            }
            return null;
        }

        public void setDebugName(String name) {
            DebugInfo debugInfo;
            if (StringsUtil.isEmpty(name)) {
                name = null;
            }
            if ((debugInfo = this.methodDef.getDebugInfo()) == null) {
                if (name == null) {
                    return;
                }
                debugInfo = this.methodDef.getOrCreateDebugInfo();
            }
            if (name == null) {
                debugInfo.removeDebugParameter(this.getDefinitionIndex());
                return;
            }
            DebugParameter parameter = debugInfo.getOrCreateDebugParameter(this.getDefinitionIndex());
            parameter.setName(name);
        }

        public DebugParameter getDebugParameter() {
            DebugInfo debugInfo = this.methodDef.getDebugInfo();
            if (debugInfo != null) {
                return debugInfo.getDebugParameter(this.getDefinitionIndex());
            }
            return null;
        }

        @Override
        public Key getKey() {
            TypeId typeId = this.getTypeId();
            if (typeId != null) {
                return typeId.getKey();
            }
            return null;
        }

        public void fromSmali(SmaliMethodParameter smaliMethodParameter) {
            if (smaliMethodParameter.hasAnnotations()) {
                this.getOrCreateAnnotationSet().fromSmali(smaliMethodParameter.getAnnotationSet());
            }
            this.setDebugName(smaliMethodParameter.getName());
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            DebugParameter debugParameter = this.getDebugParameter();
            boolean has_debug = debugParameter != null && debugParameter.getNameId() != null;
            Iterator<AnnotationSet> annotations = this.getAnnotations();
            boolean has_annotation = annotations.hasNext();
            if (!has_debug && !has_annotation) {
                return;
            }
            this.getSmaliDirective().append(writer);
            writer.append('p');
            writer.appendInteger(this.getRegister());
            if (has_debug) {
                debugParameter.append(writer);
            }
            writer.appendComment(this.getTypeId().getName());
            if (!has_annotation) {
                return;
            }
            writer.indentPlus();
            writer.appendAllWithDoubleNewLine(annotations);
            writer.indentMinus();
            this.getSmaliDirective().appendEnd(writer);
        }

        public int hashCode() {
            return this.methodDef.hashCode() * 31 + this.index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)obj;
            return this.index == parameter.index && this.methodDef == parameter.methodDef;
        }

        @Override
        public SmaliDirective getSmaliDirective() {
            return SmaliDirective.PARAM;
        }

        public String toString() {
            return SmaliWriter.toStringSafe(this);
        }
    }
}

