/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerArrayBlock;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.common.IntegerArray;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.data.DataItem;
import java.io.IOException;

public class IntegerList
extends DataItem
implements IntegerArray,
PositionedItem,
OffsetSupplier,
OffsetReceiver {
    private final DexPositionAlign positionAlign;
    private final IntegerReference itemCount;
    private final IntegerArray arrayBlock;

    IntegerList(int childesCount, IntegerArray arrayBlock, DexPositionAlign positionAlign) {
        super(childesCount + 3);
        this.positionAlign = positionAlign;
        this.itemCount = new IntegerItem();
        this.arrayBlock = arrayBlock;
        this.addChild(0, (Block)((Object)this.itemCount));
        this.addChild(1, (Block)((Object)arrayBlock));
        this.addChild(2, positionAlign);
    }

    public IntegerList(IntegerReference itemCount) {
        super(1);
        this.itemCount = itemCount;
        this.arrayBlock = new IntegerArrayBlock();
        this.addChild(0, (Block)((Object)this.arrayBlock));
        this.positionAlign = null;
    }

    public IntegerList() {
        this(0, new IntegerArrayBlock(), new DexPositionAlign());
    }

    public IntegerList(DexPositionAlign positionAlign) {
        this(0, new IntegerArrayBlock(), positionAlign);
    }

    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    public int[] toArray() {
        return IntegerArray.toArray(this.arrayBlock);
    }

    public boolean removeValue(int value) {
        return this.remove(this.indexOf(value));
    }

    public boolean remove(int index) {
        if (index < 0) {
            return false;
        }
        int size = this.size();
        if (index >= size) {
            return false;
        }
        --size;
        for (int i = index; i < size; ++i) {
            this.put(i, this.get(i + 1));
        }
        this.setSize(size);
        return true;
    }

    public int indexOf(int value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (value != this.get(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean addIfAbsent(int value) {
        if (this.indexOf(value) < 0) {
            this.add(value);
            return true;
        }
        return false;
    }

    public void add(int value) {
        int index = this.size();
        this.setSize(index + 1, false);
        this.put(index, value);
        this.onChanged();
    }

    @Override
    public void put(int index, int value) {
        this.arrayBlock.put(index, value);
    }

    @Override
    public int get(int i) {
        return this.arrayBlock.get(i);
    }

    @Override
    public int size() {
        return this.arrayBlock.size();
    }

    @Override
    public void setSize(int size) {
        this.setSize(size, true);
    }

    void setSize(int size, boolean notify) {
        int old = this.size();
        this.arrayBlock.setSize(size);
        this.itemCount.set(size);
        if (notify && old != size) {
            this.onChanged();
        }
    }

    void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size, false);
        }
    }

    void onChanged() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        Block block;
        IntegerReference itemCount = this.itemCount;
        if (itemCount instanceof Block && (block = (Block)((Object)itemCount)).getParent() == this) {
            int position = reader.getPosition();
            block.readBytes(reader);
            reader.seek(position);
        }
        this.arrayBlock.setSize(itemCount.get());
        super.onReadBytes(reader);
        this.onChanged();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": ");
        IntegerReference ref = this.getOffsetReference();
        if (ref != null) {
            builder.append("offset=");
            builder.append(ref.get());
            builder.append(", ");
        }
        if (this.arrayBlock.size() != this.itemCount.get()) {
            builder.append("count=");
            builder.append(this.itemCount);
            builder.append(", ");
        }
        builder.append(IntegerArray.toString(this));
        return builder.toString();
    }
}

