/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.IntegerList;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ArraySort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegerDataItemList<T extends DataItem>
extends IntegerList
implements Iterable<T> {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T[] items;

    public IntegerDataItemList(SectionType<T> sectionType, int usageType, DexPositionAlign positionAlign) {
        super(positionAlign);
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    public T addNew(Key key) {
        DataItem item = (DataItem)this.getOrCreateSection(this.sectionType).getOrCreate(key);
        this.add(item.getIdx());
        return (T)item;
    }

    public T addNew() {
        DataItem item = (DataItem)this.getOrCreateSection(this.sectionType).createItem();
        this.add(item.getIdx());
        return (T)item;
    }

    public T getOrCreateAt(int index) {
        Object item = this.getItem(index);
        if (item == null) {
            this.ensureSize(index + 1);
            item = (DataItem)this.getOrCreateSection(this.sectionType).createItem();
            this.put(index, ((SectionItemContainer)item).getIdx());
            this.onChanged();
        }
        return item;
    }

    public void addNull() {
        this.add(0);
    }

    @Override
    public void removeSelf() {
        this.setItems(null);
        super.removeSelf();
    }

    public void remove(T item) {
        this.remove(t -> t == item);
    }

    public void remove(Predicate<? super T> filter) {
        T[] items = this.items;
        if (items == null) {
            return;
        }
        int length = items.length;
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            T item = items[i];
            if (!filter.test(item)) continue;
            items[i] = null;
            found = true;
        }
        if (found) {
            this.removeNulls();
        }
    }

    void removeNulls() {
        T[] items = this.items;
        if (items == null || items.length == 0) {
            this.setItems(null);
            return;
        }
        int length = items.length;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (items[i] != null) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        DataItem[] update = (DataItem[])this.sectionType.getCreator().newArrayInstance(length - count);
        int index = 0;
        for (int i = 0; i < length; ++i) {
            T element = items[i];
            if (element == null) continue;
            update[index] = element;
            ++index;
        }
        this.setItems(update);
    }

    @Override
    public Iterator<T> iterator() {
        return ArrayIterator.of(this.items);
    }

    public T getItem(int i) {
        if (i < 0) {
            return null;
        }
        T[] items = this.items;
        if (items == null || i >= items.length) {
            return null;
        }
        return items[i];
    }

    public T[] getItems() {
        return this.items;
    }

    public void setItems(T[] items) {
        if (items == this.items) {
            return;
        }
        if (this.isEmpty((DataItem[])items)) {
            this.items = null;
            this.setSize(0);
            return;
        }
        int length = items.length;
        this.setSize(length, false);
        for (int i = 0; i < length; ++i) {
            T item = items[i];
            this.put(i, this.getData(item));
            this.updateUsage(item);
        }
        this.items = items;
    }

    public boolean sort(Comparator<? super T> comparator) {
        Object[] items = this.items;
        if (items == null || items.length < 2) {
            return false;
        }
        boolean sorted = ArraySort.sort(items, comparator);
        if (sorted) {
            this.setItems((DataItem[])items.clone());
        }
        return sorted;
    }

    private void updateUsage(T[] items) {
        if (items == null) {
            return;
        }
        for (T item : items) {
            this.updateUsage(item);
        }
    }

    private void updateUsage(T item) {
        if (item == null) {
            return;
        }
        ((SectionItem)item).addUsageType(this.usageType);
    }

    @Override
    void onChanged() {
        super.onChanged();
        this.cacheItems();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.refreshItems();
    }

    private void refreshItems() {
        T[] items = this.items;
        if (this.isEmpty((DataItem[])items)) {
            this.items = null;
            this.setSize(0);
            return;
        }
        int length = items.length;
        this.setSize(length, false);
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            Object item = items[i];
            if (item != null) {
                items[i] = item = (DataItem)((SectionItem)item).getReplace();
            }
            int data = this.getData(item);
            this.put(i, this.getData(item));
            if (data == 0) {
                items[i] = null;
                found = true;
            }
            this.updateUsage(item);
        }
        if (found) {
            this.removeNulls();
        }
    }

    private int getData(T item) {
        if (item == null) {
            return 0;
        }
        return ((SectionItemContainer)item).getIdx();
    }

    private void cacheItems() {
        this.items = (DataItem[])this.getSectionItem(this.sectionType, this.toArray());
        this.updateUsage((T)this.items);
    }

    private boolean isEmpty(T[] items) {
        if (items == null || items.length == 0) {
            return true;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash *= 31;
            T item = this.getItem(i);
            if (item == null) continue;
            hash += item.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDataItemList itemList = (IntegerDataItemList)obj;
        int size = this.size();
        if (size != itemList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            T item2;
            T item1 = this.getItem(i);
            if (Objects.equals(item1, item2 = itemList.getItem(i))) continue;
            return false;
        }
        return true;
    }
}

