/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterType;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugLineNumber;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstNumber;
import com.reandroid.dex.ins.ConstNumberLong;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsNop;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegisterReference;
import com.reandroid.dex.ins.RegistersEditor;
import com.reandroid.dex.ins.RegistersIterator;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class InstructionList
extends FixedBlockContainer
implements Iterable<Ins>,
SmaliFormat {
    private final CodeItem codeItem;
    private final BlockList<Ins> insArray;
    private final DexPositionAlign blockAlign;
    private boolean mLockExtraLines;

    public InstructionList(CodeItem codeItem) {
        super(2);
        this.codeItem = codeItem;
        this.insArray = new BlockList();
        this.blockAlign = new DexPositionAlign();
        this.addChild(0, this.insArray);
        this.addChild(1, this.blockAlign);
    }

    public RegistersEditor editRegisters() {
        return RegistersEditor.fromIns(this.getCodeItem(), this.iterator());
    }

    public MethodDef getMethodDef() {
        return this.getCodeItem().getMethodDef();
    }

    public DebugSequence getDebugSequence() {
        DebugInfo debugInfo = this.getDebugInfo();
        if (debugInfo != null) {
            return debugInfo.getDebugSequence();
        }
        return null;
    }

    public DebugSequence getOrCreateDebugSequence() {
        return this.getOrCreateDebugInfo().getDebugSequence();
    }

    public DebugInfo getDebugInfo() {
        return this.getCodeItem().getDebugInfo();
    }

    public DebugInfo getOrCreateDebugInfo() {
        return this.getCodeItem().getOrCreateDebugInfo();
    }

    public CodeItem getCodeItem() {
        return this.codeItem;
    }

    public RegistersTable getRegistersTable() {
        return this.getCodeItem();
    }

    public void addLocalRegisters(int amount) {
        this.addLocalRegisters(false, amount);
    }

    public void addLocalRegisters(boolean start, int amount) {
        RegistersTable registersTable = this.getRegistersTable();
        Iterator<RegistersIterator> iterator = this.getRegistersIterators();
        while (iterator.hasNext()) {
            RegistersIterator registersIterator = iterator.next();
            int count = registersIterator.isRange() ? 1 : registersIterator.size();
            for (int i = 0; i < count; ++i) {
                RegisterReference reference = registersIterator.get(i);
                if (!start && !reference.isParameter()) continue;
                reference.setRegisterValue(reference.getValue() + amount);
            }
        }
        registersTable.setRegistersCount(registersTable.getRegistersCount() + amount);
    }

    public List<Register> getLocalFreeRegisters(int startIndex) {
        final RegistersTable registersTable = this.getRegistersTable();
        final int count = registersTable.getLocalRegistersCount();
        Iterator<Register> iterator = new ArraySupplierIterator<Register>(new ArraySupplier<Register>(){

            @Override
            public Register get(int i) {
                return new Register(i, false, registersTable);
            }

            @Override
            public int getCount() {
                return count;
            }
        });
        iterator = FilterIterator.of(iterator, reference -> {
            int registerValue = reference.getValue();
            return registerValue < count && this.isFreeRegister(registerValue, startIndex);
        });
        List<Register> list = CollectionUtil.toUniqueList(iterator);
        list.sort(CompareUtil.getComparableComparator());
        return list;
    }

    public boolean isFreeRegister(int registerValue, int startIndex) {
        Iterator<RegistersIterator> iterator = this.getRegistersIterators(startIndex);
        while (iterator.hasNext()) {
            RegistersIterator registersIterator = iterator.next();
            for (RegisterReference reference : registersIterator) {
                if (reference.getValue() != registerValue) continue;
                return reference.getRegisterType() == RegisterType.WRITE;
            }
        }
        return registerValue != this.getRegistersTable().getLocalRegistersCount();
    }

    private Iterator<RegisterReference> getRegisters(int startIndex) {
        return ExpandIterator.of(this.getRegistersIterators(startIndex));
    }

    private Iterator<RegistersIterator> getRegistersIterators() {
        return this.getRegistersIterators(0);
    }

    private Iterator<RegistersIterator> getRegistersIterators(int start) {
        return ComputeIterator.of(this.iterator(start), ins -> {
            if (ins instanceof SizeXIns) {
                return ((SizeXIns)ins).getRegistersIterator();
            }
            return null;
        });
    }

    public <T1 extends Ins> Iterator<T1> iterator(Opcode<T1> opcode) {
        return this.iterator(opcode, null);
    }

    public <T1 extends Ins> Iterator<T1> iterator(Opcode<T1> opcode, Predicate<? super T1> filter) {
        return ComputeIterator.of(this.iterator(), ins -> {
            Ins result = null;
            if (ins != null && ins.getOpcode() == opcode) {
                result = ins;
                if (filter != null && !filter.test((Object)result)) {
                    result = null;
                }
            }
            return result;
        });
    }

    @Override
    public Iterator<Ins> iterator() {
        return this.getInsArray().iterator();
    }

    public Iterator<Ins> clonedIterator() {
        return this.getInsArray().clonedIterator();
    }

    public Iterator<Ins> arrayIterator() {
        return this.getInsArray().arrayIterator();
    }

    public Iterator<Ins> iterator(int start, int size) {
        return this.getInsArray().iterator(start, size);
    }

    public Iterator<Ins> iterator(int start) {
        BlockList<Ins> array = this.getInsArray();
        return array.iterator(start, this.getCount() - start);
    }

    public Iterator<Ins> iteratorByAddress(int startAddress, int codeUnits) {
        Ins insStart = this.getAtAddress(startAddress);
        if (insStart == null) {
            return EmptyIterator.of();
        }
        Ins insEnd = this.getAtAddress(startAddress + codeUnits);
        int count = insEnd.getIndex() - insStart.getIndex();
        return this.iterator(insStart.getIndex(), count);
    }

    private BlockList<Ins> getInsArray() {
        return this.insArray;
    }

    public Ins get(int i) {
        return this.getInsArray().get(i);
    }

    public int getCount() {
        return this.getInsArray().getCount();
    }

    public void add(Ins ins) {
        BlockList<Ins> array = this.getInsArray();
        array.add(ins);
        Ins previous = array.get(ins.getIndex() - 1);
        int address = previous != null ? previous.getAddress() + previous.getCodeUnits() : 0;
        ins.setAddress(address);
    }

    public void add(int index, Ins item) {
        this.reBuildExtraLines();
        this.getInsArray().add(index, item);
        this.updateAddresses();
        this.updateLabelAddress();
        this.reBuildExtraLines();
    }

    public void add(int index, Ins[] insArray) {
        this.reBuildExtraLines();
        this.getInsArray().addAll(index, insArray);
        this.updateAddresses();
        this.updateLabelAddress();
        this.reBuildExtraLines();
    }

    public void moveTo(Ins ins, int index) {
        if (index == ins.getIndex()) {
            return;
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.getCount()) {
            throw new IndexOutOfBoundsException("Size = " + this.getCount() + ", " + index);
        }
        this.reBuildExtraLines();
        this.getInsArray().moveTo(ins, index);
        this.updateAddresses();
        this.updateLabelAddress();
        this.reBuildExtraLines();
    }

    public ConstNumber createConstIntegerAt(int index, int value) {
        return this.createConstIntegerAt(index, 0, value);
    }

    public ConstNumber createConstIntegerAt(int index, int register, int value) {
        ConstNumber constNumber = register <= 15 && value <= 7 && value >= -7 ? (ConstNumber)this.createAt(index, Opcode.CONST_4) : (value <= Short.MAX_VALUE && value >= -32767 ? (ConstNumber)this.createAt(index, Opcode.CONST_16) : ((value & 0xFFFF) == 0 ? (ConstNumber)this.createAt(index, Opcode.CONST_HIGH16) : (ConstNumber)this.createAt(index, Opcode.CONST)));
        constNumber.setRegister(register);
        constNumber.set(value);
        return constNumber;
    }

    public ConstNumberLong createConstLongAt(int index, long value) {
        return this.createConstLongAt(index, 0, value);
    }

    public ConstNumberLong createConstLongAt(int index, int register, long value) {
        ConstNumberLong constNumber = (value & 0xFFFF00000000L) == 0L ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_HIGH16) : ((value & 0xFFFFL) == value ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_16) : ((value & 0xFFFFFFFFL) == value ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_32) : (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE)));
        constNumber.setRegister(register);
        constNumber.set(value);
        return constNumber;
    }

    public ConstString createStringAt(int index, StringKey value) {
        return this.createStringAt(index, 0, value);
    }

    public ConstString createStringAt(int index, String value) {
        return this.createStringAt(index, 0, value);
    }

    public ConstString createStringAt(int index, int register, String value) {
        return this.createStringAt(index, register, StringKey.create(value));
    }

    public ConstString createStringAt(int index, int register, StringKey value) {
        StringId stringId = this.getCodeItem().getOrCreateSectionItem(SectionType.STRING_ID, value);
        int id = stringId.getIdx();
        ConstString constNumber = (id & 0xFFFF) == id ? (ConstString)this.createAt(index, Opcode.CONST_STRING) : (ConstString)this.createAt(index, Opcode.CONST_STRING_JUMBO);
        constNumber.setRegister(register);
        constNumber.setString(stringId);
        return constNumber;
    }

    public <T1 extends Ins> T1 createAt(int index, Opcode<T1> opcode) {
        Block item = opcode.newInstance();
        this.add(index, (Ins)item);
        return (T1)item;
    }

    public Ins[] createAt(int index, Opcode<?>[] opcodeArray) {
        int length = opcodeArray.length;
        Ins[] results = new Ins[length];
        for (int i = 0; i < length; ++i) {
            results[i] = opcodeArray[i].newInstance();
        }
        this.add(index, results);
        return results;
    }

    public <T1 extends Ins> T1 createNext(Opcode<T1> opcode) {
        Block item = opcode.newInstance();
        this.add((Ins)item);
        return (T1)item;
    }

    public boolean isLonelyInTryCatch(Ins ins) {
        this.buildExtraLines();
        int codeUnits = ins.getCodeUnits();
        Iterator<ExceptionHandler.TryStartLabel> iterator = ins.getExtraLines(ExceptionHandler.TryStartLabel.class);
        while (iterator.hasNext()) {
            ExceptionHandler.TryStartLabel startLabel = iterator.next();
            int handlerCodeUnits = startLabel.getHandler().getCodeUnit();
            if (handlerCodeUnits > codeUnits) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Ins item) {
        return this.getInsArray().contains(item);
    }

    public boolean remove(Ins item) {
        return this.remove(item, false);
    }

    public boolean remove(Ins item, boolean force) {
        Ins next;
        if (!this.contains(item)) {
            return false;
        }
        if (!force && this.isLonelyInTryCatch(item)) {
            return this.replaceWithNop(item) != null;
        }
        this.reBuildExtraLines();
        if (item.hasExtraLines() && (next = this.get(item.getIndex() + 1)) != null) {
            item.transferExtraLines(next);
        }
        this.getInsArray().remove(item);
        item.setParent(null);
        item.setIndex(-1);
        this.updateAddresses();
        this.updateLabelAddress();
        return true;
    }

    public InsNop replaceWithNop(Ins ins) {
        return this.replace(ins, Opcode.NOP);
    }

    public <T1 extends Ins> T1 replace(Ins old, Opcode<T1> opcode) {
        if (!this.contains(old)) {
            return null;
        }
        Block item = opcode.newInstance();
        this.replace(old, (Ins)item);
        return (T1)item;
    }

    public void replace(Ins old, Ins item) {
        if (old == item) {
            return;
        }
        this.reBuildExtraLines();
        int index = old.getIndex();
        old.transferExtraLines(item);
        item.setAddress(old.getAddress());
        this.getInsArray().set(index, item);
        old.setParent(null);
        old.setIndex(-1);
        this.updateAddresses();
        this.updateLabelAddress();
    }

    private void updateLabelAddress() {
        for (Ins ins : this) {
            ins.updateLabelAddress();
        }
    }

    private void updateAddresses() {
        int outSize = 0;
        int address = 0;
        for (Ins ins : this) {
            ins.setAddress(address);
            address += ins.getCodeUnits();
            int out = ins.getOutSize();
            if (out <= outSize) continue;
            outSize = out;
        }
        this.codeItem.getInstructionCodeUnitsReference().set(address);
        this.codeItem.getInstructionOutsReference().set(outSize);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.blockAlign.align(this);
        this.codeItem.getCodeUnits().set(this.getCodeUnits());
        this.clearAndUpdateAddresses();
    }

    private void clearAndUpdateAddresses() {
        int outSize = 0;
        int address = 0;
        for (Ins ins : this) {
            ins.clearExtraLines();
            ins.setAddress(address);
            address += ins.getCodeUnits();
            int out = ins.getOutSize();
            if (out <= outSize) continue;
            outSize = out;
        }
        this.codeItem.getInstructionCodeUnitsReference().set(address);
        this.codeItem.getInstructionOutsReference().set(outSize);
        this.mLockExtraLines = false;
    }

    public int getCodeUnits() {
        int result = 0;
        for (Ins ins : this) {
            result += ins.getCodeUnits();
        }
        return result;
    }

    public DexPositionAlign getBlockAlign() {
        return this.blockAlign;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.buildExtraLines();
        for (Ins ins : this) {
            writer.newLine();
            ins.append(writer);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int insCodeUnits = this.codeItem.getInstructionCodeUnitsReference().get();
        int position = reader.getPosition() + insCodeUnits * 2;
        int zeroPosition = reader.getPosition();
        int count = (insCodeUnits + 1) / 2;
        BlockList<Ins> insBlockList = this.getInsArray();
        insBlockList.ensureCapacity(count);
        while (reader.getPosition() < position) {
            Opcode<?> opcode = Opcode.read(reader);
            Block ins = opcode.newInstance();
            ((Ins)ins).setAddress((reader.getPosition() - zeroPosition) / 2);
            insBlockList.add((Ins)ins);
            ins.readBytes(reader);
        }
        insBlockList.trimToSize();
        if (position != reader.getPosition()) {
            reader.seek(position);
        }
        int totalRead = reader.getPosition() - zeroPosition;
        this.blockAlign.align(totalRead);
        reader.offset(this.blockAlign.size());
    }

    private void clearExtraLines() {
        for (Ins ins : this) {
            ins.clearExtraLines();
        }
        this.mLockExtraLines = false;
    }

    private boolean haveExtraLines() {
        if (this.mLockExtraLines) {
            return true;
        }
        for (Ins ins : this) {
            if (!ins.hasExtraLines()) continue;
            return true;
        }
        return false;
    }

    public void buildExtraLines() {
        if (this.haveExtraLines()) {
            return;
        }
        this.mLockExtraLines = true;
        this.buildLabels();
        this.buildTryBlock();
        this.buildDebugInfo();
    }

    public void reBuildExtraLines() {
        this.clearExtraLines();
        this.buildExtraLines();
    }

    public Ins getAtAddress(int address) {
        int size = this.getCount();
        for (int i = 0; i < size; ++i) {
            Ins ins = this.get(i);
            if (ins.getAddress() != address) continue;
            return ins;
        }
        return null;
    }

    private void addLabel(Label label) {
        Ins target = this.getAtAddress(label.getTargetAddress());
        if (target != null) {
            target.addExtraLine(label);
        }
    }

    private void addLabels(Iterator<? extends Label> iterator) {
        while (iterator.hasNext()) {
            this.addLabel(iterator.next());
        }
    }

    private void buildLabels() {
        for (Ins ins : this) {
            if (ins instanceof Label) {
                this.addLabel((Label)((Object)ins));
            } else if (ins instanceof LabelsSet) {
                this.addLabels(((LabelsSet)((Object)ins)).getLabels());
            }
            ins.trimExtraLines();
        }
    }

    private void buildTryBlock() {
        TryBlock tryBlock = this.codeItem.getTryBlock();
        if (tryBlock == null || tryBlock.isNull()) {
            return;
        }
        this.addLabels(tryBlock.getLabels());
    }

    private void buildDebugInfo() {
        this.mLockExtraLines = true;
        DebugInfo debugInfo = this.codeItem.getDebugInfo();
        if (debugInfo == null) {
            this.mLockExtraLines = false;
            return;
        }
        Iterator<DebugElement> iterator = debugInfo.getExtraLines();
        while (iterator.hasNext()) {
            DebugElement element = iterator.next();
            Ins target = this.getAtAddress(element.getTargetAddress());
            if (target == null) continue;
            target.addExtraLine(element);
        }
        this.mLockExtraLines = false;
    }

    public void onRemove() {
        this.clearExtraLines();
        this.getInsArray().clearChildes();
        this.getInsArray().destroy();
    }

    public boolean cleanInvalidDebugLineNumbers() {
        DebugInfo debugInfo = this.getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        this.clearExtraLines();
        boolean result = false;
        this.buildDebugInfo();
        for (Ins ins : this) {
            if (!this.cleanInvalidDebugLineNumbers(ins)) continue;
            result = true;
        }
        this.clearExtraLines();
        return result;
    }

    private boolean cleanInvalidDebugLineNumbers(Ins ins) {
        boolean result = false;
        DebugLineNumber first = null;
        int address = ins.getAddress();
        Iterator<DebugLineNumber> iterator = ins.getExtraLines(DebugLineNumber.class);
        while (iterator.hasNext()) {
            DebugLineNumber lineNumber = iterator.next();
            if (lineNumber.getParent() == null) continue;
            if (lineNumber.getTargetAddress() != address) {
                lineNumber.removeSelf();
                result = true;
                continue;
            }
            if (first == null) {
                first = lineNumber;
                continue;
            }
            lineNumber.removeSelf();
            result = true;
        }
        return result;
    }

    public void replaceKeys(Key search, Key replace) {
        for (Ins ins : this) {
            ins.replaceKeys(search, replace);
        }
    }

    public Iterator<IdItem> usedIds() {
        return new IterableIterator<Ins, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(Ins element) {
                return element.usedIds();
            }
        };
    }

    public void merge(InstructionList instructionList) {
        this.getInsArray().ensureCapacity(instructionList.getCount());
        for (Ins coming : instructionList) {
            Object ins = this.createNext(coming.getOpcode());
            ((Ins)ins).merge(coming);
        }
        this.getInsArray().trimToSize();
        this.updateAddresses();
    }

    public void fromSmali(SmaliMethod smaliMethod) throws IOException {
        Iterator<SmaliInstruction> iterator = smaliMethod.getInstructions();
        while (iterator.hasNext()) {
            SmaliInstruction smaliInstruction = iterator.next();
            Object ins = this.createNext(smaliInstruction.getOpcode());
            ((Ins)ins).fromSmali(smaliInstruction);
        }
        this.getInsArray().trimToSize();
        this.updateAddresses();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InstructionList list = (InstructionList)obj;
        return this.insArray.equals(list.insArray);
    }

    public int hashCode() {
        return this.insArray.hashCode();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        SmaliWriter smaliWriter = new SmaliWriter(writer);
        smaliWriter.indentPlus();
        try {
            this.append(smaliWriter);
            smaliWriter.close();
        }
        catch (IOException exception) {
            return exception.toString();
        }
        return writer.toString();
    }
}

