/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.HiddenApiData;
import com.reandroid.dex.data.HiddenApiDataList;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiIndexList;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;

public class HiddenApiRestrictions
extends DataItem {
    private final IntegerItem sizeReference = new IntegerItem();
    private final HiddenApiIndexList hiddenApiIndexList = new HiddenApiIndexList();
    private final HiddenApiDataList hiddenApiDataList = new HiddenApiDataList();

    public HiddenApiRestrictions() {
        super(3);
        this.addChild(0, this.sizeReference);
        this.addChild(1, this.hiddenApiIndexList);
        this.addChild(2, this.hiddenApiDataList);
    }

    public HiddenApiFlagValue getFlagValue(Key key) {
        return this.getHiddenApiIndexList().getFlagValue(key);
    }

    public HiddenApiIndexList getHiddenApiIndexList() {
        return this.hiddenApiIndexList;
    }

    public HiddenApiDataList getHiddenApiDataList() {
        return this.hiddenApiDataList;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateSizeFast();
    }

    private void updateSizeFast() {
        int size = 0;
        HiddenApiData last = this.hiddenApiDataList.getLast();
        if (last != null && (size = last.getOffset()) != 0) {
            size += last.countBytes();
        }
        if (size == 0 || size != this.sizeReference.get()) {
            size = this.countBytes();
        }
        this.sizeReference.set(size);
    }

    int getHiddenApiDataListOffset() {
        return this.sizeReference.countBytes() + this.hiddenApiIndexList.countBytes();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.sizeReference.readBytes(reader);
        BlockReader restrictionsReader = reader.create(this.sizeReference.get());
        this.hiddenApiIndexList.onReadBytes(restrictionsReader);
        this.hiddenApiDataList.onReadBytes(restrictionsReader);
        restrictionsReader.close();
        reader.seek(this.sizeReference.get());
    }

    public SectionType<HiddenApiRestrictions> getSectionType() {
        return SectionType.HIDDEN_API;
    }
}

