/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiIndex;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

public class HiddenApiIndexList
extends BlockList<HiddenApiIndex> {
    public HiddenApiIndexList() {
        this.setCreator(new HiddenApiIndexCreator(this));
    }

    public HiddenApiFlagValue getFlagValue(Key key) {
        HiddenApiIndex apiIndex = this.get(key.getDeclaring());
        if (apiIndex != null) {
            return apiIndex.get(key);
        }
        return null;
    }

    public HiddenApiIndex get(TypeKey typeKey) {
        ClassId classId;
        Section<ClassId> section = this.getClassIdSection();
        if (section == null) {
            return null;
        }
        if (section.getCount() != this.size()) {
            this.sortItems();
        }
        if ((classId = section.get(typeKey)) == null || classId.isRemoved()) {
            return null;
        }
        return (HiddenApiIndex)this.get(classId.getIdx());
    }

    public Iterator<HiddenApiIndex> getHiddenApis() {
        return FilterIterator.of(this.iterator(), HiddenApiIndex::hasValidDataOffset);
    }

    @Override
    public int countBytes() {
        return this.size() * 4;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.clearNullIndex();
        this.sortItems();
    }

    private void clearNullIndex() {
        this.remove(HiddenApiIndex::isNull);
    }

    private void sortItems() {
        this.sort(CompareUtil.getComparableComparator());
        if (this.ensureClassSectionSize()) {
            this.sort(CompareUtil.getComparableComparator());
        }
    }

    private boolean ensureClassSectionSize() {
        Section<ClassId> section = this.getClassIdSection();
        if (section == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < this.size(); ++i) {
            HiddenApiIndex apiIndex = (HiddenApiIndex)this.get(i);
            ClassId classId = apiIndex.getClassId();
            if (classId.getIndex() == i) continue;
            ClassId update = (ClassId)section.get(i);
            HiddenApiIndex hiddenApiIndex = new HiddenApiIndex(update);
            this.add(i, hiddenApiIndex);
            changed = true;
            --i;
        }
        this.setSize(section.getCount());
        return changed;
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        this.setSize(this.getClassIdSectionCount());
        super.readChildes(reader);
    }

    private int getClassIdSectionCount() {
        Section<ClassId> section = this.getClassIdSection();
        if (section != null) {
            return section.getCount();
        }
        return 0;
    }

    private Section<ClassId> getClassIdSection() {
        SectionList sectionList = this.getParentSectionList();
        if (sectionList != null) {
            return sectionList.getSection(SectionType.CLASS_ID);
        }
        return null;
    }

    private SectionList getParentSectionList() {
        return this.getParentInstance(SectionList.class);
    }

    static class HiddenApiIndexCreator
    implements Creator<HiddenApiIndex> {
        private final HiddenApiIndexList hiddenApiIndexList;

        HiddenApiIndexCreator(HiddenApiIndexList hiddenApiIndexList) {
            this.hiddenApiIndexList = hiddenApiIndexList;
        }

        public HiddenApiIndex[] newArrayInstance(int length) {
            return new HiddenApiIndex[length];
        }

        @Override
        public HiddenApiIndex newInstance() {
            throw new RuntimeException("Must call newInstanceAt(index)");
        }

        @Override
        public HiddenApiIndex newInstanceAt(int index) {
            return new HiddenApiIndex((ClassId)this.hiddenApiIndexList.getClassIdSection().get(index));
        }
    }
}

