/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.data.HiddenApiData;
import com.reandroid.dex.data.HiddenApiIndex;
import com.reandroid.dex.data.HiddenApiIndexList;
import com.reandroid.dex.data.HiddenApiRestrictions;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class HiddenApiDataList
extends SingleBlockContainer<BlockList<HiddenApiData>>
implements Iterable<HiddenApiData> {
    private final BlockList<HiddenApiData> dataList = new BlockList();

    public HiddenApiDataList() {
        this.setItem(this.dataList);
    }

    public HiddenApiData get(int offset) {
        BlockList<HiddenApiData> dataList = this.dataList;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            HiddenApiData data = dataList.get(i);
            if (offset != data.getOffset()) continue;
            return data;
        }
        return null;
    }

    @Override
    public Iterator<HiddenApiData> iterator() {
        return this.dataList.iterator();
    }

    HiddenApiData getLast() {
        return this.dataList.getLast();
    }

    private void add(HiddenApiData hiddenApiData) {
        this.dataList.add(hiddenApiData);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateOffsets();
    }

    private void updateOffsets() {
        int offset = this.getOffsetStart();
        for (HiddenApiData apiData : this) {
            apiData.setOffset(offset);
            offset += apiData.countBytes();
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        HiddenApiIndexList hiddenApiIndexList = this.getHiddenApiList();
        Iterator<HiddenApiIndex> iterator = hiddenApiIndexList.getHiddenApis();
        while (iterator.hasNext()) {
            HiddenApiIndex hiddenApiIndex = iterator.next();
            HiddenApiData hiddenApiData = new HiddenApiData();
            this.add(hiddenApiData);
            hiddenApiIndex.linkData(hiddenApiData);
            hiddenApiData.onReadBytes(reader);
        }
        Comparator comparator = (data1, data2) -> CompareUtil.compare(data1.getOffset(), data2.getOffset());
        this.dataList.sort(comparator);
    }

    private int getOffsetStart() {
        HiddenApiRestrictions restrictions = this.getParentInstance(HiddenApiRestrictions.class);
        assert (restrictions != null);
        return restrictions.getHiddenApiDataListOffset();
    }

    private HiddenApiIndexList getHiddenApiList() {
        HiddenApiRestrictions restrictions = this.getParentInstance(HiddenApiRestrictions.class);
        assert (restrictions != null);
        return restrictions.getHiddenApiIndexList();
    }
}

