/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberIntegerReference;
import com.reandroid.dex.base.FixedDexContainer;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiFlagValueList;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.io.OutputStream;

public class HiddenApiData
extends FixedDexContainer
implements OffsetSupplier,
OffsetReceiver {
    private IntegerReference offsetReference;
    private ClassId classId;
    private HiddenApiFlagValueList staticFields;
    private HiddenApiFlagValueList instanceFields;
    private HiddenApiFlagValueList directMethods;
    private HiddenApiFlagValueList virtualMethods;

    public HiddenApiData() {
        super(4);
    }

    public HiddenApiFlagValue get(Def<?> def) {
        HiddenApiFlagValueList flagValueList = this.getFlagValueList(def);
        if (flagValueList != null) {
            return (HiddenApiFlagValue)flagValueList.get(def.getIndex());
        }
        return null;
    }

    private HiddenApiFlagValueList getFlagValueList(Def<?> def) {
        Key key = def.getKey();
        if (key instanceof FieldKey) {
            if (def.isStatic()) {
                return this.getStaticFields();
            }
            return this.getInstanceFields();
        }
        if (key instanceof MethodKey) {
            if (def.isDirect()) {
                return this.getDirectMethods();
            }
            return this.getVirtualMethods();
        }
        return null;
    }

    HiddenApiData newCopy() {
        return new Copy(this);
    }

    public boolean isEmptyValueList() {
        if (this.staticFields != null && !this.staticFields.isEmptyValueList()) {
            return false;
        }
        if (this.instanceFields != null && !this.instanceFields.isEmptyValueList()) {
            return false;
        }
        if (this.directMethods != null && !this.directMethods.isEmptyValueList()) {
            return false;
        }
        return this.virtualMethods == null || this.virtualMethods.isEmptyValueList();
    }

    public ClassId getClassId() {
        return this.classId;
    }

    public void setClassId(ClassId classId) {
        if (this.classId == classId) {
            return;
        }
        this.classId = classId;
        this.initializeValueList();
        this.addChild(0, this.staticFields);
        this.addChild(1, this.instanceFields);
        this.addChild(2, this.directMethods);
        this.addChild(3, this.virtualMethods);
        this.linkDefArray(classId);
    }

    private void initializeValueList() {
        HiddenApiFlagValueList[] valueLists = this.createHiddenApiFlagValueList();
        this.staticFields = valueLists[0];
        this.instanceFields = valueLists[1];
        this.directMethods = valueLists[2];
        this.virtualMethods = valueLists[3];
    }

    HiddenApiFlagValueList[] createHiddenApiFlagValueList() {
        return new HiddenApiFlagValueList[]{new HiddenApiFlagValueList(), new HiddenApiFlagValueList(), new HiddenApiFlagValueList(), new HiddenApiFlagValueList()};
    }

    void linkDefArray(ClassId classId) {
        ClassData classData = classId.getClassData();
        this.staticFields.linkDefArray(classData.getStaticFieldsArray());
        this.instanceFields.linkDefArray(classData.getInstanceFieldsArray());
        this.directMethods.linkDefArray(classData.getDirectMethodsArray());
        this.virtualMethods.linkDefArray(classData.getVirtualMethodArray());
    }

    public HiddenApiFlagValueList getStaticFields() {
        return this.staticFields;
    }

    public HiddenApiFlagValueList getInstanceFields() {
        return this.instanceFields;
    }

    public HiddenApiFlagValueList getDirectMethods() {
        return this.directMethods;
    }

    public HiddenApiFlagValueList getVirtualMethods() {
        return this.virtualMethods;
    }

    public int getOffset() {
        IntegerReference reference = this.getOffsetReference();
        if (reference != null) {
            return reference.get();
        }
        return 0;
    }

    public void setOffset(int offset) {
        IntegerReference reference = this.getOffsetReference();
        if (reference == null) {
            reference = new NumberIntegerReference();
            this.setOffsetReference(reference);
        }
        reference.set(offset);
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.offsetReference;
    }

    @Override
    public void setOffsetReference(IntegerReference reference) {
        this.offsetReference = reference;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int offset = this.getOffset();
        if (offset == 0) {
            throw new IOException("Can not read at zero");
        }
        reader.seek(offset);
        super.onReadBytes(reader);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiddenApiData apiData = (HiddenApiData)obj;
        return ObjectsUtil.equals(this.staticFields, apiData.staticFields) && ObjectsUtil.equals(this.instanceFields, apiData.instanceFields) && ObjectsUtil.equals(this.directMethods, apiData.directMethods) && ObjectsUtil.equals(this.virtualMethods, apiData.virtualMethods);
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.staticFields, this.instanceFields, this.directMethods, this.virtualMethods);
    }

    static class Copy
    extends HiddenApiData {
        private final HiddenApiData source;

        Copy(HiddenApiData source) {
            this.source = source;
        }

        @Override
        HiddenApiData newCopy() {
            return this.source.newCopy();
        }

        @Override
        HiddenApiFlagValueList[] createHiddenApiFlagValueList() {
            return new HiddenApiFlagValueList[]{this.source.getStaticFields().newCopy(), this.source.getInstanceFields().newCopy(), this.source.getDirectMethods().newCopy(), this.source.getVirtualMethods().newCopy()};
        }

        @Override
        public IntegerReference getOffsetReference() {
            return this.source.getOffsetReference();
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
        }

        @Override
        public int onWriteBytes(OutputStream stream) throws IOException {
            return 0;
        }

        @Override
        public int countBytes() {
            return 0;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Copy)) {
                return false;
            }
            return this.source.equals(obj);
        }

        @Override
        public int hashCode() {
            return 31 * this.source.hashCode();
        }
    }
}

