/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class FieldDef
extends Def<FieldId> {
    private DexValueBlock<?> staticInitialValue;

    public FieldDef() {
        super(0, SectionType.FIELD_ID);
    }

    @Override
    public FieldKey getKey() {
        return (FieldKey)super.getKey();
    }

    public DexValueBlock<?> getStaticInitialValue() {
        return this.staticInitialValue;
    }

    public <T1 extends DexValueBlock<?>> T1 getOrCreateStaticValue(DexValueType<T1> valueType) {
        DexValueBlock<T1> valueBlock = this.staticInitialValue;
        if (valueBlock == null || !valueBlock.is(valueType)) {
            valueBlock = this.getClassId().getOrCreateStaticValue(valueType, this.getIndex());
            this.holdStaticInitialValue(valueBlock);
        }
        return (T1)valueBlock;
    }

    @Override
    public Iterator<? extends Modifier> getAccessFlags() {
        return AccessFlag.valuesOfField(this.getAccessFlagsValue());
    }

    void holdStaticInitialValue(DexValueBlock<?> staticInitialValue) {
        this.staticInitialValue = staticInitialValue;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        Iterator<AnnotationSet> annotations;
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.appendModifiers(this.getModifiers());
        ((FieldId)this.getId()).append(writer, false);
        DexValueBlock<?> value = this.getStaticInitialValue();
        if (value != null) {
            writer.append(" = ");
            value.append(writer);
        }
        if (!(annotations = this.getAnnotations()).hasNext()) {
            return;
        }
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(annotations);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getId());
    }

    public void fromSmali(SmaliField smaliField) {
        SmaliValue smaliValue;
        this.setKey(smaliField.getKey());
        this.setAccessFlagsValue(smaliField.getAccessFlagsValue());
        if (smaliField.hasAnnotation()) {
            AnnotationSet annotationSet = this.getOrCreateSection(SectionType.ANNOTATION_SET).createItem();
            annotationSet.fromSmali(smaliField.getAnnotation());
            this.addAnnotationSet(annotationSet);
        }
        if ((smaliValue = smaliField.getValue()) != null) {
            ((DexValueBlock)this.getOrCreateStaticValue(smaliValue.getValueType())).fromSmali(smaliValue);
        }
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.FIELD;
    }

    public String toString() {
        if (this.isReading()) {
            return this.getSmaliDirective() + " " + this.getKey();
        }
        FieldId fieldId = (FieldId)this.getId();
        if (fieldId != null) {
            return SmaliWriter.toStringSafe(this);
        }
        return this.getSmaliDirective() + " " + Modifier.toString(this.getAccessFlags()) + " " + this.getRelativeIdValue();
    }
}

